/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.FairshareCapacityUtilization;
import software.amazon.awssdk.services.batch.model.FairshareCapacityUtilizationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FairshareUtilizationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FairshareUtilizationDetail> {
    private static final SdkField<Long> ACTIVE_SHARE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("activeShareCount").getter(FairshareUtilizationDetail.getter(FairshareUtilizationDetail::activeShareCount)).setter(FairshareUtilizationDetail.setter(Builder::activeShareCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeShareCount").build()}).build();
    private static final SdkField<List<FairshareCapacityUtilization>> TOP_CAPACITY_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("topCapacityUtilization").getter(FairshareUtilizationDetail.getter(FairshareUtilizationDetail::topCapacityUtilization)).setter(FairshareUtilizationDetail.setter(Builder::topCapacityUtilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topCapacityUtilization").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FairshareCapacityUtilization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_SHARE_COUNT_FIELD, TOP_CAPACITY_UTILIZATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FairshareUtilizationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long activeShareCount;
    private final List<FairshareCapacityUtilization> topCapacityUtilization;

    private FairshareUtilizationDetail(BuilderImpl builder) {
        this.activeShareCount = builder.activeShareCount;
        this.topCapacityUtilization = builder.topCapacityUtilization;
    }

    public final Long activeShareCount() {
        return this.activeShareCount;
    }

    public final boolean hasTopCapacityUtilization() {
        return this.topCapacityUtilization != null && !(this.topCapacityUtilization instanceof SdkAutoConstructList);
    }

    public final List<FairshareCapacityUtilization> topCapacityUtilization() {
        return this.topCapacityUtilization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeShareCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopCapacityUtilization() ? this.topCapacityUtilization() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FairshareUtilizationDetail)) {
            return false;
        }
        FairshareUtilizationDetail other = (FairshareUtilizationDetail)obj;
        return Objects.equals(this.activeShareCount(), other.activeShareCount()) && this.hasTopCapacityUtilization() == other.hasTopCapacityUtilization() && Objects.equals(this.topCapacityUtilization(), other.topCapacityUtilization());
    }

    public final String toString() {
        return ToString.builder((String)"FairshareUtilizationDetail").add("ActiveShareCount", (Object)this.activeShareCount()).add("TopCapacityUtilization", this.hasTopCapacityUtilization() ? this.topCapacityUtilization() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeShareCount": {
                return Optional.ofNullable(clazz.cast(this.activeShareCount()));
            }
            case "topCapacityUtilization": {
                return Optional.ofNullable(clazz.cast(this.topCapacityUtilization()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("activeShareCount", ACTIVE_SHARE_COUNT_FIELD);
        map.put("topCapacityUtilization", TOP_CAPACITY_UTILIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FairshareUtilizationDetail, T> g) {
        return obj -> g.apply((FairshareUtilizationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long activeShareCount;
        private List<FairshareCapacityUtilization> topCapacityUtilization = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FairshareUtilizationDetail model) {
            this.activeShareCount(model.activeShareCount);
            this.topCapacityUtilization(model.topCapacityUtilization);
        }

        public final Long getActiveShareCount() {
            return this.activeShareCount;
        }

        public final void setActiveShareCount(Long activeShareCount) {
            this.activeShareCount = activeShareCount;
        }

        @Override
        public final Builder activeShareCount(Long activeShareCount) {
            this.activeShareCount = activeShareCount;
            return this;
        }

        public final List<FairshareCapacityUtilization.Builder> getTopCapacityUtilization() {
            List<FairshareCapacityUtilization.Builder> result = FairshareCapacityUtilizationListCopier.copyToBuilder(this.topCapacityUtilization);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopCapacityUtilization(Collection<FairshareCapacityUtilization.BuilderImpl> topCapacityUtilization) {
            this.topCapacityUtilization = FairshareCapacityUtilizationListCopier.copyFromBuilder(topCapacityUtilization);
        }

        @Override
        public final Builder topCapacityUtilization(Collection<FairshareCapacityUtilization> topCapacityUtilization) {
            this.topCapacityUtilization = FairshareCapacityUtilizationListCopier.copy(topCapacityUtilization);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topCapacityUtilization(FairshareCapacityUtilization ... topCapacityUtilization) {
            this.topCapacityUtilization(Arrays.asList(topCapacityUtilization));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topCapacityUtilization(Consumer<FairshareCapacityUtilization.Builder> ... topCapacityUtilization) {
            this.topCapacityUtilization(Stream.of(topCapacityUtilization).map(c -> (FairshareCapacityUtilization)((FairshareCapacityUtilization.Builder)FairshareCapacityUtilization.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FairshareUtilizationDetail build() {
            return new FairshareUtilizationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FairshareUtilizationDetail> {
        public Builder activeShareCount(Long var1);

        public Builder topCapacityUtilization(Collection<FairshareCapacityUtilization> var1);

        public Builder topCapacityUtilization(FairshareCapacityUtilization ... var1);

        public Builder topCapacityUtilization(Consumer<FairshareCapacityUtilization.Builder> ... var1);
    }
}

