/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.FairshareCapacityUsage;
import software.amazon.awssdk.services.batch.model.FairshareCapacityUsageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FairshareCapacityUtilization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FairshareCapacityUtilization> {
    private static final SdkField<String> SHARE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareIdentifier").getter(FairshareCapacityUtilization.getter(FairshareCapacityUtilization::shareIdentifier)).setter(FairshareCapacityUtilization.setter(Builder::shareIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareIdentifier").build()}).build();
    private static final SdkField<List<FairshareCapacityUsage>> CAPACITY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityUsage").getter(FairshareCapacityUtilization.getter(FairshareCapacityUtilization::capacityUsage)).setter(FairshareCapacityUtilization.setter(Builder::capacityUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityUsage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FairshareCapacityUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_IDENTIFIER_FIELD, CAPACITY_USAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FairshareCapacityUtilization.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String shareIdentifier;
    private final List<FairshareCapacityUsage> capacityUsage;

    private FairshareCapacityUtilization(BuilderImpl builder) {
        this.shareIdentifier = builder.shareIdentifier;
        this.capacityUsage = builder.capacityUsage;
    }

    public final String shareIdentifier() {
        return this.shareIdentifier;
    }

    public final boolean hasCapacityUsage() {
        return this.capacityUsage != null && !(this.capacityUsage instanceof SdkAutoConstructList);
    }

    public final List<FairshareCapacityUsage> capacityUsage() {
        return this.capacityUsage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shareIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityUsage() ? this.capacityUsage() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FairshareCapacityUtilization)) {
            return false;
        }
        FairshareCapacityUtilization other = (FairshareCapacityUtilization)obj;
        return Objects.equals(this.shareIdentifier(), other.shareIdentifier()) && this.hasCapacityUsage() == other.hasCapacityUsage() && Objects.equals(this.capacityUsage(), other.capacityUsage());
    }

    public final String toString() {
        return ToString.builder((String)"FairshareCapacityUtilization").add("ShareIdentifier", (Object)this.shareIdentifier()).add("CapacityUsage", this.hasCapacityUsage() ? this.capacityUsage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "shareIdentifier": {
                return Optional.ofNullable(clazz.cast(this.shareIdentifier()));
            }
            case "capacityUsage": {
                return Optional.ofNullable(clazz.cast(this.capacityUsage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shareIdentifier", SHARE_IDENTIFIER_FIELD);
        map.put("capacityUsage", CAPACITY_USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FairshareCapacityUtilization, T> g) {
        return obj -> g.apply((FairshareCapacityUtilization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shareIdentifier;
        private List<FairshareCapacityUsage> capacityUsage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FairshareCapacityUtilization model) {
            this.shareIdentifier(model.shareIdentifier);
            this.capacityUsage(model.capacityUsage);
        }

        public final String getShareIdentifier() {
            return this.shareIdentifier;
        }

        public final void setShareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
        }

        @Override
        public final Builder shareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        public final List<FairshareCapacityUsage.Builder> getCapacityUsage() {
            List<FairshareCapacityUsage.Builder> result = FairshareCapacityUsageListCopier.copyToBuilder(this.capacityUsage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityUsage(Collection<FairshareCapacityUsage.BuilderImpl> capacityUsage) {
            this.capacityUsage = FairshareCapacityUsageListCopier.copyFromBuilder(capacityUsage);
        }

        @Override
        public final Builder capacityUsage(Collection<FairshareCapacityUsage> capacityUsage) {
            this.capacityUsage = FairshareCapacityUsageListCopier.copy(capacityUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityUsage(FairshareCapacityUsage ... capacityUsage) {
            this.capacityUsage(Arrays.asList(capacityUsage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityUsage(Consumer<FairshareCapacityUsage.Builder> ... capacityUsage) {
            this.capacityUsage(Stream.of(capacityUsage).map(c -> (FairshareCapacityUsage)((FairshareCapacityUsage.Builder)FairshareCapacityUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FairshareCapacityUtilization build() {
            return new FairshareCapacityUtilization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FairshareCapacityUtilization> {
        public Builder shareIdentifier(String var1);

        public Builder capacityUsage(Collection<FairshareCapacityUsage> var1);

        public Builder capacityUsage(FairshareCapacityUsage ... var1);

        public Builder capacityUsage(Consumer<FairshareCapacityUsage.Builder> ... var1);
    }
}

