/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.ArrayJobStatusSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArrayPropertiesSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArrayPropertiesSummary> {
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("size").getter(ArrayPropertiesSummary.getter(ArrayPropertiesSummary::size)).setter(ArrayPropertiesSummary.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()}).build();
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("index").getter(ArrayPropertiesSummary.getter(ArrayPropertiesSummary::index)).setter(ArrayPropertiesSummary.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()}).build();
    private static final SdkField<Map<String, Integer>> STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("statusSummary").getter(ArrayPropertiesSummary.getter(ArrayPropertiesSummary::statusSummary)).setter(ArrayPropertiesSummary.setter(Builder::statusSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> STATUS_SUMMARY_LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("statusSummaryLastUpdatedAt").getter(ArrayPropertiesSummary.getter(ArrayPropertiesSummary::statusSummaryLastUpdatedAt)).setter(ArrayPropertiesSummary.setter(Builder::statusSummaryLastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummaryLastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_FIELD, INDEX_FIELD, STATUS_SUMMARY_FIELD, STATUS_SUMMARY_LAST_UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ArrayPropertiesSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer size;
    private final Integer index;
    private final Map<String, Integer> statusSummary;
    private final Long statusSummaryLastUpdatedAt;

    private ArrayPropertiesSummary(BuilderImpl builder) {
        this.size = builder.size;
        this.index = builder.index;
        this.statusSummary = builder.statusSummary;
        this.statusSummaryLastUpdatedAt = builder.statusSummaryLastUpdatedAt;
    }

    public final Integer size() {
        return this.size;
    }

    public final Integer index() {
        return this.index;
    }

    public final boolean hasStatusSummary() {
        return this.statusSummary != null && !(this.statusSummary instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> statusSummary() {
        return this.statusSummary;
    }

    public final Long statusSummaryLastUpdatedAt() {
        return this.statusSummaryLastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusSummary() ? this.statusSummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusSummaryLastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayPropertiesSummary)) {
            return false;
        }
        ArrayPropertiesSummary other = (ArrayPropertiesSummary)obj;
        return Objects.equals(this.size(), other.size()) && Objects.equals(this.index(), other.index()) && this.hasStatusSummary() == other.hasStatusSummary() && Objects.equals(this.statusSummary(), other.statusSummary()) && Objects.equals(this.statusSummaryLastUpdatedAt(), other.statusSummaryLastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ArrayPropertiesSummary").add("Size", (Object)this.size()).add("Index", (Object)this.index()).add("StatusSummary", this.hasStatusSummary() ? this.statusSummary() : null).add("StatusSummaryLastUpdatedAt", (Object)this.statusSummaryLastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "statusSummary": {
                return Optional.ofNullable(clazz.cast(this.statusSummary()));
            }
            case "statusSummaryLastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.statusSummaryLastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("size", SIZE_FIELD);
        map.put("index", INDEX_FIELD);
        map.put("statusSummary", STATUS_SUMMARY_FIELD);
        map.put("statusSummaryLastUpdatedAt", STATUS_SUMMARY_LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArrayPropertiesSummary, T> g) {
        return obj -> g.apply((ArrayPropertiesSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer size;
        private Integer index;
        private Map<String, Integer> statusSummary = DefaultSdkAutoConstructMap.getInstance();
        private Long statusSummaryLastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ArrayPropertiesSummary model) {
            this.size(model.size);
            this.index(model.index);
            this.statusSummary(model.statusSummary);
            this.statusSummaryLastUpdatedAt(model.statusSummaryLastUpdatedAt);
        }

        public final Integer getSize() {
            return this.size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final Integer getIndex() {
            return this.index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final Map<String, Integer> getStatusSummary() {
            if (this.statusSummary instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.statusSummary;
        }

        public final void setStatusSummary(Map<String, Integer> statusSummary) {
            this.statusSummary = ArrayJobStatusSummaryCopier.copy(statusSummary);
        }

        @Override
        public final Builder statusSummary(Map<String, Integer> statusSummary) {
            this.statusSummary = ArrayJobStatusSummaryCopier.copy(statusSummary);
            return this;
        }

        public final Long getStatusSummaryLastUpdatedAt() {
            return this.statusSummaryLastUpdatedAt;
        }

        public final void setStatusSummaryLastUpdatedAt(Long statusSummaryLastUpdatedAt) {
            this.statusSummaryLastUpdatedAt = statusSummaryLastUpdatedAt;
        }

        @Override
        public final Builder statusSummaryLastUpdatedAt(Long statusSummaryLastUpdatedAt) {
            this.statusSummaryLastUpdatedAt = statusSummaryLastUpdatedAt;
            return this;
        }

        public ArrayPropertiesSummary build() {
            return new ArrayPropertiesSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArrayPropertiesSummary> {
        public Builder size(Integer var1);

        public Builder index(Integer var1);

        public Builder statusSummary(Map<String, Integer> var1);

        public Builder statusSummaryLastUpdatedAt(Long var1);
    }
}

