/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.ListServiceJobsRequest;
import software.amazon.awssdk.services.batch.model.ListServiceJobsResponse;
import software.amazon.awssdk.services.batch.model.ServiceJobSummary;

public class ListServiceJobsIterable
implements SdkIterable<ListServiceJobsResponse> {
    private final BatchClient client;
    private final ListServiceJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceJobsIterable(BatchClient client, ListServiceJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceJobsResponseFetcher();
    }

    public Iterator<ListServiceJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceJobSummary> jobSummaryList() {
        Function<ListServiceJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaryList() != null) {
                return response.jobSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceJobsResponseFetcher
    implements SyncPageFetcher<ListServiceJobsResponse> {
        private ListServiceJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceJobsResponse nextPage(ListServiceJobsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceJobsIterable.this.client.listServiceJobs(ListServiceJobsIterable.this.firstRequest);
            }
            return ListServiceJobsIterable.this.client.listServiceJobs((ListServiceJobsRequest)((Object)ListServiceJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

