/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchAsyncClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.DescribeServiceEnvironmentsRequest;
import software.amazon.awssdk.services.batch.model.DescribeServiceEnvironmentsResponse;
import software.amazon.awssdk.services.batch.model.ServiceEnvironmentDetail;

public class DescribeServiceEnvironmentsPublisher
implements SdkPublisher<DescribeServiceEnvironmentsResponse> {
    private final BatchAsyncClient client;
    private final DescribeServiceEnvironmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeServiceEnvironmentsPublisher(BatchAsyncClient client, DescribeServiceEnvironmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeServiceEnvironmentsPublisher(BatchAsyncClient client, DescribeServiceEnvironmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeServiceEnvironmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeServiceEnvironmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceEnvironmentDetail> serviceEnvironments() {
        return this.flatMapIterable(response -> response.serviceEnvironments());
    }

    private class DescribeServiceEnvironmentsResponseFetcher
    implements AsyncPageFetcher<DescribeServiceEnvironmentsResponse> {
        private DescribeServiceEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServiceEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeServiceEnvironmentsResponse> nextPage(DescribeServiceEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeServiceEnvironmentsPublisher.this.client.describeServiceEnvironments(DescribeServiceEnvironmentsPublisher.this.firstRequest);
            }
            return DescribeServiceEnvironmentsPublisher.this.client.describeServiceEnvironments((DescribeServiceEnvironmentsRequest)((Object)DescribeServiceEnvironmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

