/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Secret
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Secret> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Secret.getter(Secret::name)).setter(Secret.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VALUE_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("valueFrom").getter(Secret.getter(Secret::valueFrom)).setter(Secret.setter(Builder::valueFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueFrom").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FROM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Secret.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String valueFrom;

    private Secret(BuilderImpl builder) {
        this.name = builder.name;
        this.valueFrom = builder.valueFrom;
    }

    public final String name() {
        return this.name;
    }

    public final String valueFrom() {
        return this.valueFrom;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueFrom());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Secret)) {
            return false;
        }
        Secret other = (Secret)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.valueFrom(), other.valueFrom());
    }

    public final String toString() {
        return ToString.builder((String)"Secret").add("Name", (Object)this.name()).add("ValueFrom", (Object)this.valueFrom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "valueFrom": {
                return Optional.ofNullable(clazz.cast(this.valueFrom()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("name", NAME_FIELD);
        map.put("valueFrom", VALUE_FROM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Secret, T> g) {
        return obj -> g.apply((Secret)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String valueFrom;

        private BuilderImpl() {
        }

        private BuilderImpl(Secret model) {
            this.name(model.name);
            this.valueFrom(model.valueFrom);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValueFrom() {
            return this.valueFrom;
        }

        public final void setValueFrom(String valueFrom) {
            this.valueFrom = valueFrom;
        }

        @Override
        public final Builder valueFrom(String valueFrom) {
            this.valueFrom = valueFrom;
            return this;
        }

        public Secret build() {
            return new Secret(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Secret> {
        public Builder name(String var1);

        public Builder valueFrom(String var1);
    }
}

