/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.ConsumableResourceSummary;
import software.amazon.awssdk.services.batch.model.ListConsumableResourcesRequest;
import software.amazon.awssdk.services.batch.model.ListConsumableResourcesResponse;

public class ListConsumableResourcesIterable
implements SdkIterable<ListConsumableResourcesResponse> {
    private final BatchClient client;
    private final ListConsumableResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConsumableResourcesIterable(BatchClient client, ListConsumableResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConsumableResourcesResponseFetcher();
    }

    public Iterator<ListConsumableResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConsumableResourceSummary> consumableResources() {
        Function<ListConsumableResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.consumableResources() != null) {
                return response.consumableResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConsumableResourcesResponseFetcher
    implements SyncPageFetcher<ListConsumableResourcesResponse> {
        private ListConsumableResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListConsumableResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConsumableResourcesResponse nextPage(ListConsumableResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListConsumableResourcesIterable.this.client.listConsumableResources(ListConsumableResourcesIterable.this.firstRequest);
            }
            return ListConsumableResourcesIterable.this.client.listConsumableResources((ListConsumableResourcesRequest)((Object)ListConsumableResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

