/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the order of a service environment for a job queue. This determines the priority order when multiple
 * service environments are associated with the same job queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceEnvironmentOrder implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceEnvironmentOrder.Builder, ServiceEnvironmentOrder> {
    private static final SdkField<Integer> ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("order")
            .getter(getter(ServiceEnvironmentOrder::order)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()).build();

    private static final SdkField<String> SERVICE_ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceEnvironment").getter(getter(ServiceEnvironmentOrder::serviceEnvironment))
            .setter(setter(Builder::serviceEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceEnvironment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDER_FIELD,
            SERVICE_ENVIRONMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer order;

    private final String serviceEnvironment;

    private ServiceEnvironmentOrder(BuilderImpl builder) {
        this.order = builder.order;
        this.serviceEnvironment = builder.serviceEnvironment;
    }

    /**
     * <p>
     * The order of the service environment. Job queues with a higher priority are evaluated first when associated with
     * the same service environment.
     * </p>
     * 
     * @return The order of the service environment. Job queues with a higher priority are evaluated first when
     *         associated with the same service environment.
     */
    public final Integer order() {
        return order;
    }

    /**
     * <p>
     * The name or ARN of the service environment.
     * </p>
     * 
     * @return The name or ARN of the service environment.
     */
    public final String serviceEnvironment() {
        return serviceEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(order());
        hashCode = 31 * hashCode + Objects.hashCode(serviceEnvironment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceEnvironmentOrder)) {
            return false;
        }
        ServiceEnvironmentOrder other = (ServiceEnvironmentOrder) obj;
        return Objects.equals(order(), other.order()) && Objects.equals(serviceEnvironment(), other.serviceEnvironment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceEnvironmentOrder").add("Order", order()).add("ServiceEnvironment", serviceEnvironment())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "order":
            return Optional.ofNullable(clazz.cast(order()));
        case "serviceEnvironment":
            return Optional.ofNullable(clazz.cast(serviceEnvironment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("order", ORDER_FIELD);
        map.put("serviceEnvironment", SERVICE_ENVIRONMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceEnvironmentOrder, T> g) {
        return obj -> g.apply((ServiceEnvironmentOrder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceEnvironmentOrder> {
        /**
         * <p>
         * The order of the service environment. Job queues with a higher priority are evaluated first when associated
         * with the same service environment.
         * </p>
         * 
         * @param order
         *        The order of the service environment. Job queues with a higher priority are evaluated first when
         *        associated with the same service environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder order(Integer order);

        /**
         * <p>
         * The name or ARN of the service environment.
         * </p>
         * 
         * @param serviceEnvironment
         *        The name or ARN of the service environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceEnvironment(String serviceEnvironment);
    }

    static final class BuilderImpl implements Builder {
        private Integer order;

        private String serviceEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceEnvironmentOrder model) {
            order(model.order);
            serviceEnvironment(model.serviceEnvironment);
        }

        public final Integer getOrder() {
            return order;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final String getServiceEnvironment() {
            return serviceEnvironment;
        }

        public final void setServiceEnvironment(String serviceEnvironment) {
            this.serviceEnvironment = serviceEnvironment;
        }

        @Override
        public final Builder serviceEnvironment(String serviceEnvironment) {
            this.serviceEnvironment = serviceEnvironment;
            return this;
        }

        @Override
        public ServiceEnvironmentOrder build() {
            return new ServiceEnvironmentOrder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
