/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.BatchServiceClientConfiguration;
import software.amazon.awssdk.services.batch.internal.BatchServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.batch.model.BatchException;
import software.amazon.awssdk.services.batch.model.CancelJobRequest;
import software.amazon.awssdk.services.batch.model.CancelJobResponse;
import software.amazon.awssdk.services.batch.model.ClientException;
import software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentRequest;
import software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse;
import software.amazon.awssdk.services.batch.model.CreateConsumableResourceRequest;
import software.amazon.awssdk.services.batch.model.CreateConsumableResourceResponse;
import software.amazon.awssdk.services.batch.model.CreateJobQueueRequest;
import software.amazon.awssdk.services.batch.model.CreateJobQueueResponse;
import software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyRequest;
import software.amazon.awssdk.services.batch.model.CreateSchedulingPolicyResponse;
import software.amazon.awssdk.services.batch.model.CreateServiceEnvironmentRequest;
import software.amazon.awssdk.services.batch.model.CreateServiceEnvironmentResponse;
import software.amazon.awssdk.services.batch.model.DeleteComputeEnvironmentRequest;
import software.amazon.awssdk.services.batch.model.DeleteComputeEnvironmentResponse;
import software.amazon.awssdk.services.batch.model.DeleteConsumableResourceRequest;
import software.amazon.awssdk.services.batch.model.DeleteConsumableResourceResponse;
import software.amazon.awssdk.services.batch.model.DeleteJobQueueRequest;
import software.amazon.awssdk.services.batch.model.DeleteJobQueueResponse;
import software.amazon.awssdk.services.batch.model.DeleteSchedulingPolicyRequest;
import software.amazon.awssdk.services.batch.model.DeleteSchedulingPolicyResponse;
import software.amazon.awssdk.services.batch.model.DeleteServiceEnvironmentRequest;
import software.amazon.awssdk.services.batch.model.DeleteServiceEnvironmentResponse;
import software.amazon.awssdk.services.batch.model.DeregisterJobDefinitionRequest;
import software.amazon.awssdk.services.batch.model.DeregisterJobDefinitionResponse;
import software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest;
import software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse;
import software.amazon.awssdk.services.batch.model.DescribeConsumableResourceRequest;
import software.amazon.awssdk.services.batch.model.DescribeConsumableResourceResponse;
import software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsResponse;
import software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobQueuesResponse;
import software.amazon.awssdk.services.batch.model.DescribeJobsRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobsResponse;
import software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesRequest;
import software.amazon.awssdk.services.batch.model.DescribeSchedulingPoliciesResponse;
import software.amazon.awssdk.services.batch.model.DescribeServiceEnvironmentsRequest;
import software.amazon.awssdk.services.batch.model.DescribeServiceEnvironmentsResponse;
import software.amazon.awssdk.services.batch.model.DescribeServiceJobRequest;
import software.amazon.awssdk.services.batch.model.DescribeServiceJobResponse;
import software.amazon.awssdk.services.batch.model.GetJobQueueSnapshotRequest;
import software.amazon.awssdk.services.batch.model.GetJobQueueSnapshotResponse;
import software.amazon.awssdk.services.batch.model.ListConsumableResourcesRequest;
import software.amazon.awssdk.services.batch.model.ListConsumableResourcesResponse;
import software.amazon.awssdk.services.batch.model.ListJobsByConsumableResourceRequest;
import software.amazon.awssdk.services.batch.model.ListJobsByConsumableResourceResponse;
import software.amazon.awssdk.services.batch.model.ListJobsRequest;
import software.amazon.awssdk.services.batch.model.ListJobsResponse;
import software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest;
import software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse;
import software.amazon.awssdk.services.batch.model.ListServiceJobsRequest;
import software.amazon.awssdk.services.batch.model.ListServiceJobsResponse;
import software.amazon.awssdk.services.batch.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.batch.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.batch.model.RegisterJobDefinitionRequest;
import software.amazon.awssdk.services.batch.model.RegisterJobDefinitionResponse;
import software.amazon.awssdk.services.batch.model.ServerException;
import software.amazon.awssdk.services.batch.model.SubmitJobRequest;
import software.amazon.awssdk.services.batch.model.SubmitJobResponse;
import software.amazon.awssdk.services.batch.model.SubmitServiceJobRequest;
import software.amazon.awssdk.services.batch.model.SubmitServiceJobResponse;
import software.amazon.awssdk.services.batch.model.TagResourceRequest;
import software.amazon.awssdk.services.batch.model.TagResourceResponse;
import software.amazon.awssdk.services.batch.model.TerminateJobRequest;
import software.amazon.awssdk.services.batch.model.TerminateJobResponse;
import software.amazon.awssdk.services.batch.model.TerminateServiceJobRequest;
import software.amazon.awssdk.services.batch.model.TerminateServiceJobResponse;
import software.amazon.awssdk.services.batch.model.UntagResourceRequest;
import software.amazon.awssdk.services.batch.model.UntagResourceResponse;
import software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentRequest;
import software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentResponse;
import software.amazon.awssdk.services.batch.model.UpdateConsumableResourceRequest;
import software.amazon.awssdk.services.batch.model.UpdateConsumableResourceResponse;
import software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest;
import software.amazon.awssdk.services.batch.model.UpdateJobQueueResponse;
import software.amazon.awssdk.services.batch.model.UpdateSchedulingPolicyRequest;
import software.amazon.awssdk.services.batch.model.UpdateSchedulingPolicyResponse;
import software.amazon.awssdk.services.batch.model.UpdateServiceEnvironmentRequest;
import software.amazon.awssdk.services.batch.model.UpdateServiceEnvironmentResponse;
import software.amazon.awssdk.services.batch.transform.CancelJobRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.CreateComputeEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.CreateConsumableResourceRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.CreateJobQueueRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.CreateSchedulingPolicyRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.CreateServiceEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DeleteComputeEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DeleteConsumableResourceRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DeleteJobQueueRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DeleteSchedulingPolicyRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DeleteServiceEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DeregisterJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeComputeEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeConsumableResourceRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeJobQueuesRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeJobsRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeSchedulingPoliciesRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeServiceEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeServiceJobRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.GetJobQueueSnapshotRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.ListConsumableResourcesRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.ListJobsByConsumableResourceRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.ListSchedulingPoliciesRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.ListServiceJobsRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.RegisterJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.SubmitJobRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.SubmitServiceJobRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.TerminateJobRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.TerminateServiceJobRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.UpdateComputeEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.UpdateConsumableResourceRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.UpdateJobQueueRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.UpdateSchedulingPolicyRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.UpdateServiceEnvironmentRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultBatchClient
implements BatchClient {
    private static final Logger log = Logger.loggerFor(DefaultBatchClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBatchClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Batch#2.35.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, cancelJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelJob");
            CancelJobResponse cancelJobResponse = (CancelJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$cancelJob$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateComputeEnvironmentResponse createComputeEnvironment(CreateComputeEnvironmentRequest createComputeEnvironmentRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateComputeEnvironmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createComputeEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, createComputeEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateComputeEnvironment");
            CreateComputeEnvironmentResponse createComputeEnvironmentResponse = (CreateComputeEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateComputeEnvironment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createComputeEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateComputeEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createComputeEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$createComputeEnvironment$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConsumableResourceResponse createConsumableResource(CreateConsumableResourceRequest createConsumableResourceRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConsumableResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConsumableResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, createConsumableResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConsumableResource");
            CreateConsumableResourceResponse createConsumableResourceResponse = (CreateConsumableResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConsumableResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createConsumableResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConsumableResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConsumableResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$createConsumableResource$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobQueueResponse createJobQueue(CreateJobQueueRequest createJobQueueRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateJobQueueResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createJobQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, createJobQueueRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJobQueue");
            CreateJobQueueResponse createJobQueueResponse = (CreateJobQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJobQueue").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createJobQueueRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateJobQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createJobQueueResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$createJobQueue$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSchedulingPolicyResponse createSchedulingPolicy(CreateSchedulingPolicyRequest createSchedulingPolicyRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSchedulingPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSchedulingPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, createSchedulingPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSchedulingPolicy");
            CreateSchedulingPolicyResponse createSchedulingPolicyResponse = (CreateSchedulingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSchedulingPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSchedulingPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSchedulingPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSchedulingPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$createSchedulingPolicy$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateServiceEnvironmentResponse createServiceEnvironment(CreateServiceEnvironmentRequest createServiceEnvironmentRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServiceEnvironmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createServiceEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, createServiceEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateServiceEnvironment");
            CreateServiceEnvironmentResponse createServiceEnvironmentResponse = (CreateServiceEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateServiceEnvironment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createServiceEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateServiceEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createServiceEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$createServiceEnvironment$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteComputeEnvironmentResponse deleteComputeEnvironment(DeleteComputeEnvironmentRequest deleteComputeEnvironmentRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteComputeEnvironmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteComputeEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, deleteComputeEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteComputeEnvironment");
            DeleteComputeEnvironmentResponse deleteComputeEnvironmentResponse = (DeleteComputeEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteComputeEnvironment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteComputeEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteComputeEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteComputeEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$deleteComputeEnvironment$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConsumableResourceResponse deleteConsumableResource(DeleteConsumableResourceRequest deleteConsumableResourceRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConsumableResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConsumableResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, deleteConsumableResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConsumableResource");
            DeleteConsumableResourceResponse deleteConsumableResourceResponse = (DeleteConsumableResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConsumableResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConsumableResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConsumableResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConsumableResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$deleteConsumableResource$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteJobQueueResponse deleteJobQueue(DeleteJobQueueRequest deleteJobQueueRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteJobQueueResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteJobQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, deleteJobQueueRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteJobQueue");
            DeleteJobQueueResponse deleteJobQueueResponse = (DeleteJobQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteJobQueue").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteJobQueueRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteJobQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteJobQueueResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$deleteJobQueue$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSchedulingPolicyResponse deleteSchedulingPolicy(DeleteSchedulingPolicyRequest deleteSchedulingPolicyRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSchedulingPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSchedulingPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, deleteSchedulingPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSchedulingPolicy");
            DeleteSchedulingPolicyResponse deleteSchedulingPolicyResponse = (DeleteSchedulingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSchedulingPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSchedulingPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSchedulingPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSchedulingPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$deleteSchedulingPolicy$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceEnvironmentResponse deleteServiceEnvironment(DeleteServiceEnvironmentRequest deleteServiceEnvironmentRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceEnvironmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServiceEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, deleteServiceEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServiceEnvironment");
            DeleteServiceEnvironmentResponse deleteServiceEnvironmentResponse = (DeleteServiceEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServiceEnvironment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteServiceEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServiceEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServiceEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$deleteServiceEnvironment$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterJobDefinitionResponse deregisterJobDefinition(DeregisterJobDefinitionRequest deregisterJobDefinitionRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterJobDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterJobDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, deregisterJobDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterJobDefinition");
            DeregisterJobDefinitionResponse deregisterJobDefinitionResponse = (DeregisterJobDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterJobDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterJobDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterJobDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterJobDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$deregisterJobDefinition$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeComputeEnvironmentsResponse describeComputeEnvironments(DescribeComputeEnvironmentsRequest describeComputeEnvironmentsRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeComputeEnvironmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeComputeEnvironmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, describeComputeEnvironmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeComputeEnvironments");
            DescribeComputeEnvironmentsResponse describeComputeEnvironmentsResponse = (DescribeComputeEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeComputeEnvironments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeComputeEnvironmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeComputeEnvironmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeComputeEnvironmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$describeComputeEnvironments$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConsumableResourceResponse describeConsumableResource(DescribeConsumableResourceRequest describeConsumableResourceRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConsumableResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConsumableResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, describeConsumableResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConsumableResource");
            DescribeConsumableResourceResponse describeConsumableResourceResponse = (DescribeConsumableResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConsumableResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConsumableResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConsumableResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConsumableResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$describeConsumableResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobDefinitionsResponse describeJobDefinitions(DescribeJobDefinitionsRequest describeJobDefinitionsRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobDefinitionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeJobDefinitionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, describeJobDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJobDefinitions");
            DescribeJobDefinitionsResponse describeJobDefinitionsResponse = (DescribeJobDefinitionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJobDefinitions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeJobDefinitionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeJobDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeJobDefinitionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$describeJobDefinitions$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobQueuesResponse describeJobQueues(DescribeJobQueuesRequest describeJobQueuesRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobQueuesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeJobQueuesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, describeJobQueuesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJobQueues");
            DescribeJobQueuesResponse describeJobQueuesResponse = (DescribeJobQueuesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJobQueues").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeJobQueuesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeJobQueuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeJobQueuesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$describeJobQueues$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobsResponse describeJobs(DescribeJobsRequest describeJobsRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, describeJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJobs");
            DescribeJobsResponse describeJobsResponse = (DescribeJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$describeJobs$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSchedulingPoliciesResponse describeSchedulingPolicies(DescribeSchedulingPoliciesRequest describeSchedulingPoliciesRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSchedulingPoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSchedulingPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, describeSchedulingPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSchedulingPolicies");
            DescribeSchedulingPoliciesResponse describeSchedulingPoliciesResponse = (DescribeSchedulingPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSchedulingPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSchedulingPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSchedulingPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSchedulingPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$describeSchedulingPolicies$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServiceEnvironmentsResponse describeServiceEnvironments(DescribeServiceEnvironmentsRequest describeServiceEnvironmentsRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServiceEnvironmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServiceEnvironmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, describeServiceEnvironmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServiceEnvironments");
            DescribeServiceEnvironmentsResponse describeServiceEnvironmentsResponse = (DescribeServiceEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServiceEnvironments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeServiceEnvironmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeServiceEnvironmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeServiceEnvironmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$describeServiceEnvironments$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServiceJobResponse describeServiceJob(DescribeServiceJobRequest describeServiceJobRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServiceJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeServiceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, describeServiceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServiceJob");
            DescribeServiceJobResponse describeServiceJobResponse = (DescribeServiceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServiceJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeServiceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeServiceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeServiceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$describeServiceJob$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobQueueSnapshotResponse getJobQueueSnapshot(GetJobQueueSnapshotRequest getJobQueueSnapshotRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobQueueSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJobQueueSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, getJobQueueSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobQueueSnapshot");
            GetJobQueueSnapshotResponse getJobQueueSnapshotResponse = (GetJobQueueSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobQueueSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getJobQueueSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetJobQueueSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getJobQueueSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$getJobQueueSnapshot$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConsumableResourcesResponse listConsumableResources(ListConsumableResourcesRequest listConsumableResourcesRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConsumableResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConsumableResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, listConsumableResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConsumableResources");
            ListConsumableResourcesResponse listConsumableResourcesResponse = (ListConsumableResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConsumableResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listConsumableResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConsumableResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConsumableResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$listConsumableResources$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, listJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobs");
            ListJobsResponse listJobsResponse = (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$listJobs$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsByConsumableResourceResponse listJobsByConsumableResource(ListJobsByConsumableResourceRequest listJobsByConsumableResourceRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobsByConsumableResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listJobsByConsumableResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, listJobsByConsumableResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobsByConsumableResource");
            ListJobsByConsumableResourceResponse listJobsByConsumableResourceResponse = (ListJobsByConsumableResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobsByConsumableResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listJobsByConsumableResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListJobsByConsumableResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listJobsByConsumableResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$listJobsByConsumableResource$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSchedulingPoliciesResponse listSchedulingPolicies(ListSchedulingPoliciesRequest listSchedulingPoliciesRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSchedulingPoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSchedulingPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, listSchedulingPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSchedulingPolicies");
            ListSchedulingPoliciesResponse listSchedulingPoliciesResponse = (ListSchedulingPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSchedulingPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSchedulingPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSchedulingPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSchedulingPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$listSchedulingPolicies$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServiceJobsResponse listServiceJobs(ListServiceJobsRequest listServiceJobsRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServiceJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, listServiceJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceJobs");
            ListServiceJobsResponse listServiceJobsResponse = (ListServiceJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listServiceJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServiceJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServiceJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$listServiceJobs$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$listTagsForResource$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterJobDefinitionResponse registerJobDefinition(RegisterJobDefinitionRequest registerJobDefinitionRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterJobDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerJobDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, registerJobDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterJobDefinition");
            RegisterJobDefinitionResponse registerJobDefinitionResponse = (RegisterJobDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterJobDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerJobDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterJobDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerJobDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$registerJobDefinition$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmitJobResponse submitJob(SubmitJobRequest submitJobRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubmitJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)submitJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, submitJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubmitJob");
            SubmitJobResponse submitJobResponse = (SubmitJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubmitJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)submitJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SubmitJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return submitJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$submitJob$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmitServiceJobResponse submitServiceJob(SubmitServiceJobRequest submitServiceJobRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubmitServiceJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)submitServiceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, submitServiceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubmitServiceJob");
            SubmitServiceJobResponse submitServiceJobResponse = (SubmitServiceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubmitServiceJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)submitServiceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SubmitServiceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return submitServiceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$submitServiceJob$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$tagResource$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateJobResponse terminateJob(TerminateJobRequest terminateJobRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)terminateJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, terminateJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateJob");
            TerminateJobResponse terminateJobResponse = (TerminateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)terminateJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TerminateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return terminateJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$terminateJob$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateServiceJobResponse terminateServiceJob(TerminateServiceJobRequest terminateServiceJobRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateServiceJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)terminateServiceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, terminateServiceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateServiceJob");
            TerminateServiceJobResponse terminateServiceJobResponse = (TerminateServiceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateServiceJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)terminateServiceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TerminateServiceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return terminateServiceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$terminateServiceJob$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$untagResource$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateComputeEnvironmentResponse updateComputeEnvironment(UpdateComputeEnvironmentRequest updateComputeEnvironmentRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateComputeEnvironmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateComputeEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, updateComputeEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateComputeEnvironment");
            UpdateComputeEnvironmentResponse updateComputeEnvironmentResponse = (UpdateComputeEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateComputeEnvironment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateComputeEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateComputeEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateComputeEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$updateComputeEnvironment$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConsumableResourceResponse updateConsumableResource(UpdateConsumableResourceRequest updateConsumableResourceRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConsumableResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateConsumableResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, updateConsumableResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConsumableResource");
            UpdateConsumableResourceResponse updateConsumableResourceResponse = (UpdateConsumableResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConsumableResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateConsumableResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConsumableResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConsumableResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$updateConsumableResource$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobQueueResponse updateJobQueue(UpdateJobQueueRequest updateJobQueueRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateJobQueueResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateJobQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, updateJobQueueRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobQueue");
            UpdateJobQueueResponse updateJobQueueResponse = (UpdateJobQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobQueue").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateJobQueueRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateJobQueueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateJobQueueResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$updateJobQueue$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSchedulingPolicyResponse updateSchedulingPolicy(UpdateSchedulingPolicyRequest updateSchedulingPolicyRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSchedulingPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSchedulingPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, updateSchedulingPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSchedulingPolicy");
            UpdateSchedulingPolicyResponse updateSchedulingPolicyResponse = (UpdateSchedulingPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSchedulingPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateSchedulingPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSchedulingPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSchedulingPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$updateSchedulingPolicy$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceEnvironmentResponse updateServiceEnvironment(UpdateServiceEnvironmentRequest updateServiceEnvironmentRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceEnvironmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateServiceEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultBatchClient.resolveMetricPublishers(clientConfiguration, updateServiceEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Batch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServiceEnvironment");
            UpdateServiceEnvironmentResponse updateServiceEnvironmentResponse = (UpdateServiceEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServiceEnvironment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateServiceEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServiceEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServiceEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBatchClient.lambda$updateServiceEnvironment$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "batch";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        BatchServiceClientConfigurationBuilder serviceConfigBuilder = new BatchServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(BatchException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final BatchServiceClientConfiguration serviceClientConfiguration() {
        return new BatchServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateServiceEnvironment$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSchedulingPolicy$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJobQueue$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConsumableResource$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateComputeEnvironment$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$terminateServiceJob$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$terminateJob$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$submitServiceJob$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$submitJob$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerJobDefinition$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceJobs$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSchedulingPolicies$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobsByConsumableResource$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobs$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConsumableResources$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobQueueSnapshot$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServiceJob$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServiceEnvironments$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSchedulingPolicies$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJobs$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJobQueues$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJobDefinitions$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConsumableResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeComputeEnvironments$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterJobDefinition$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServiceEnvironment$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSchedulingPolicy$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteJobQueue$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConsumableResource$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteComputeEnvironment$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createServiceEnvironment$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSchedulingPolicy$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createJobQueue$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConsumableResource$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createComputeEnvironment$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelJob$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

