/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for <code>ListJobs</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsRequest extends BatchRequest implements ToCopyableBuilder<ListJobsRequest.Builder, ListJobsRequest> {
    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobQueue").getter(getter(ListJobsRequest::jobQueue)).setter(setter(Builder::jobQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()).build();

    private static final SdkField<String> ARRAY_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("arrayJobId").getter(getter(ListJobsRequest::arrayJobId)).setter(setter(Builder::arrayJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayJobId").build()).build();

    private static final SdkField<String> MULTI_NODE_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("multiNodeJobId").getter(getter(ListJobsRequest::multiNodeJobId)).setter(setter(Builder::multiNodeJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiNodeJobId").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobStatus").getter(getter(ListJobsRequest::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<KeyValuesPair>> FILTERS_FIELD = SdkField
            .<List<KeyValuesPair>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListJobsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValuesPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValuesPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_QUEUE_FIELD,
            ARRAY_JOB_ID_FIELD, MULTI_NODE_JOB_ID_FIELD, JOB_STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobQueue;

    private final String arrayJobId;

    private final String multiNodeJobId;

    private final String jobStatus;

    private final Integer maxResults;

    private final String nextToken;

    private final List<KeyValuesPair> filters;

    private ListJobsRequest(BuilderImpl builder) {
        super(builder);
        this.jobQueue = builder.jobQueue;
        this.arrayJobId = builder.arrayJobId;
        this.multiNodeJobId = builder.multiNodeJobId;
        this.jobStatus = builder.jobStatus;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The name or full Amazon Resource Name (ARN) of the job queue used to list jobs.
     * </p>
     * 
     * @return The name or full Amazon Resource Name (ARN) of the job queue used to list jobs.
     */
    public final String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * The job ID for an array job. Specifying an array job ID with this parameter lists all child jobs from within the
     * specified array.
     * </p>
     * 
     * @return The job ID for an array job. Specifying an array job ID with this parameter lists all child jobs from
     *         within the specified array.
     */
    public final String arrayJobId() {
        return arrayJobId;
    }

    /**
     * <p>
     * The job ID for a multi-node parallel job. Specifying a multi-node parallel job ID with this parameter lists all
     * nodes that are associated with the specified job.
     * </p>
     * 
     * @return The job ID for a multi-node parallel job. Specifying a multi-node parallel job ID with this parameter
     *         lists all nodes that are associated with the specified job.
     */
    public final String multiNodeJobId() {
        return multiNodeJobId;
    }

    /**
     * <p>
     * The job status used to filter jobs in the specified queue. If the <code>filters</code> parameter is specified,
     * the <code>jobStatus</code> parameter is ignored and jobs with any status are returned. If you don't specify a
     * status, only <code>RUNNING</code> jobs are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The job status used to filter jobs in the specified queue. If the <code>filters</code> parameter is
     *         specified, the <code>jobStatus</code> parameter is ignored and jobs with any status are returned. If you
     *         don't specify a status, only <code>RUNNING</code> jobs are returned.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The job status used to filter jobs in the specified queue. If the <code>filters</code> parameter is specified,
     * the <code>jobStatus</code> parameter is ignored and jobs with any status are returned. If you don't specify a
     * status, only <code>RUNNING</code> jobs are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The job status used to filter jobs in the specified queue. If the <code>filters</code> parameter is
     *         specified, the <code>jobStatus</code> parameter is ignored and jobs with any status are returned. If you
     *         don't specify a status, only <code>RUNNING</code> jobs are returned.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>ListJobs</code> in a paginated output. When this parameter is
     * used, <code>ListJobs</code> returns up to <code>maxResults</code> results in a single page and a
     * <code>nextToken</code> response element, if applicable. The remaining results of the initial request can be seen
     * by sending another <code>ListJobs</code> request with the returned <code>nextToken</code> value.
     * </p>
     * <p>
     * The following outlines key parameters and limitations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The minimum value is 1.
     * </p>
     * </li>
     * <li>
     * <p>
     * When <code>--job-status</code> is used, Batch returns up to 1000 values.
     * </p>
     * </li>
     * <li>
     * <p>
     * When <code>--filters</code> is used, Batch returns up to 100 values.
     * </p>
     * </li>
     * <li>
     * <p>
     * If neither parameter is used, then <code>ListJobs</code> returns up to 1000 results (jobs that are in the
     * <code>RUNNING</code> status) and a <code>nextToken</code> value, if applicable.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The maximum number of results returned by <code>ListJobs</code> in a paginated output. When this
     *         parameter is used, <code>ListJobs</code> returns up to <code>maxResults</code> results in a single page
     *         and a <code>nextToken</code> response element, if applicable. The remaining results of the initial
     *         request can be seen by sending another <code>ListJobs</code> request with the returned
     *         <code>nextToken</code> value.</p>
     *         <p>
     *         The following outlines key parameters and limitations:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The minimum value is 1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When <code>--job-status</code> is used, Batch returns up to 1000 values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When <code>--filters</code> is used, Batch returns up to 100 values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If neither parameter is used, then <code>ListJobs</code> returns up to 1000 results (jobs that are in the
     *         <code>RUNNING</code> status) and a <code>nextToken</code> value, if applicable.
     *         </p>
     *         </li>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code>
     * when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not for other
     * programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request where
     *         <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value. This value
     *         is <code>null</code> when there are no more results to return.</p> <note>
     *         <p>
     *         Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not
     *         for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter to apply to the query. Only one filter can be used at a time. When the filter is used,
     * <code>jobStatus</code> is ignored. The filter doesn't apply to child jobs in an array or multi-node parallel
     * (MNP) jobs. The results are sorted by the <code>createdAt</code> field, with the most recent jobs being first.
     * </p>
     * <dl>
     * <dt>JOB_NAME</dt>
     * <dd>
     * <p>
     * The value of the filter is a case-insensitive match for the job name. If the value ends with an asterisk (*), the
     * filter matches any job name that begins with the string before the '*'. This corresponds to the
     * <code>jobName</code> value. For example, <code>test1</code> matches both <code>Test1</code> and
     * <code>test1</code>, and <code>test1*</code> matches both <code>test1</code> and <code>Test10</code>. When the
     * <code>JOB_NAME</code> filter is used, the results are grouped by the job name and version.
     * </p>
     * </dd>
     * <dt>JOB_DEFINITION</dt>
     * <dd>
     * <p>
     * The value for the filter is the name or Amazon Resource Name (ARN) of the job definition. This corresponds to the
     * <code>jobDefinition</code> value. The value is case sensitive. When the value for the filter is the job
     * definition name, the results include all the jobs that used any revision of that job definition name. If the
     * value ends with an asterisk (*), the filter matches any job definition name that begins with the string before
     * the '*'. For example, <code>jd1</code> matches only <code>jd1</code>, and <code>jd1*</code> matches both
     * <code>jd1</code> and <code>jd1A</code>. The version of the job definition that's used doesn't affect the sort
     * order. When the <code>JOB_DEFINITION</code> filter is used and the ARN is used (which is in the form
     * <code>arn:${Partition}:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code>), the
     * results include jobs that used the specified revision of the job definition. Asterisk (*) isn't supported when
     * the ARN is used.
     * </p>
     * </dd>
     * <dt>BEFORE_CREATED_AT</dt>
     * <dd>
     * <p>
     * The value for the filter is the time that's before the job was created. This corresponds to the
     * <code>createdAt</code> value. The value is a string representation of the number of milliseconds since 00:00:00
     * UTC (midnight) on January 1, 1970.
     * </p>
     * </dd>
     * <dt>AFTER_CREATED_AT</dt>
     * <dd>
     * <p>
     * The value for the filter is the time that's after the job was created. This corresponds to the
     * <code>createdAt</code> value. The value is a string representation of the number of milliseconds since 00:00:00
     * UTC (midnight) on January 1, 1970.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filter to apply to the query. Only one filter can be used at a time. When the filter is used,
     *         <code>jobStatus</code> is ignored. The filter doesn't apply to child jobs in an array or multi-node
     *         parallel (MNP) jobs. The results are sorted by the <code>createdAt</code> field, with the most recent
     *         jobs being first.</p>
     *         <dl>
     *         <dt>JOB_NAME</dt>
     *         <dd>
     *         <p>
     *         The value of the filter is a case-insensitive match for the job name. If the value ends with an asterisk
     *         (*), the filter matches any job name that begins with the string before the '*'. This corresponds to the
     *         <code>jobName</code> value. For example, <code>test1</code> matches both <code>Test1</code> and
     *         <code>test1</code>, and <code>test1*</code> matches both <code>test1</code> and <code>Test10</code>. When
     *         the <code>JOB_NAME</code> filter is used, the results are grouped by the job name and version.
     *         </p>
     *         </dd>
     *         <dt>JOB_DEFINITION</dt>
     *         <dd>
     *         <p>
     *         The value for the filter is the name or Amazon Resource Name (ARN) of the job definition. This
     *         corresponds to the <code>jobDefinition</code> value. The value is case sensitive. When the value for the
     *         filter is the job definition name, the results include all the jobs that used any revision of that job
     *         definition name. If the value ends with an asterisk (*), the filter matches any job definition name that
     *         begins with the string before the '*'. For example, <code>jd1</code> matches only <code>jd1</code>, and
     *         <code>jd1*</code> matches both <code>jd1</code> and <code>jd1A</code>. The version of the job definition
     *         that's used doesn't affect the sort order. When the <code>JOB_DEFINITION</code> filter is used and the
     *         ARN is used (which is in the form
     *         <code>arn:${Partition}:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code>
     *         ), the results include jobs that used the specified revision of the job definition. Asterisk (*) isn't
     *         supported when the ARN is used.
     *         </p>
     *         </dd>
     *         <dt>BEFORE_CREATED_AT</dt>
     *         <dd>
     *         <p>
     *         The value for the filter is the time that's before the job was created. This corresponds to the
     *         <code>createdAt</code> value. The value is a string representation of the number of milliseconds since
     *         00:00:00 UTC (midnight) on January 1, 1970.
     *         </p>
     *         </dd>
     *         <dt>AFTER_CREATED_AT</dt>
     *         <dd>
     *         <p>
     *         The value for the filter is the time that's after the job was created. This corresponds to the
     *         <code>createdAt</code> value. The value is a string representation of the number of milliseconds since
     *         00:00:00 UTC (midnight) on January 1, 1970.
     *         </p>
     *         </dd>
     */
    public final List<KeyValuesPair> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(arrayJobId());
        hashCode = 31 * hashCode + Objects.hashCode(multiNodeJobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest) obj;
        return Objects.equals(jobQueue(), other.jobQueue()) && Objects.equals(arrayJobId(), other.arrayJobId())
                && Objects.equals(multiNodeJobId(), other.multiNodeJobId())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobsRequest").add("JobQueue", jobQueue()).add("ArrayJobId", arrayJobId())
                .add("MultiNodeJobId", multiNodeJobId()).add("JobStatus", jobStatusAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueue":
            return Optional.ofNullable(clazz.cast(jobQueue()));
        case "arrayJobId":
            return Optional.ofNullable(clazz.cast(arrayJobId()));
        case "multiNodeJobId":
            return Optional.ofNullable(clazz.cast(multiNodeJobId()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobQueue", JOB_QUEUE_FIELD);
        map.put("arrayJobId", ARRAY_JOB_ID_FIELD);
        map.put("multiNodeJobId", MULTI_NODE_JOB_ID_FIELD);
        map.put("jobStatus", JOB_STATUS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListJobsRequest, T> g) {
        return obj -> g.apply((ListJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListJobsRequest> {
        /**
         * <p>
         * The name or full Amazon Resource Name (ARN) of the job queue used to list jobs.
         * </p>
         * 
         * @param jobQueue
         *        The name or full Amazon Resource Name (ARN) of the job queue used to list jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * The job ID for an array job. Specifying an array job ID with this parameter lists all child jobs from within
         * the specified array.
         * </p>
         * 
         * @param arrayJobId
         *        The job ID for an array job. Specifying an array job ID with this parameter lists all child jobs from
         *        within the specified array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayJobId(String arrayJobId);

        /**
         * <p>
         * The job ID for a multi-node parallel job. Specifying a multi-node parallel job ID with this parameter lists
         * all nodes that are associated with the specified job.
         * </p>
         * 
         * @param multiNodeJobId
         *        The job ID for a multi-node parallel job. Specifying a multi-node parallel job ID with this parameter
         *        lists all nodes that are associated with the specified job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiNodeJobId(String multiNodeJobId);

        /**
         * <p>
         * The job status used to filter jobs in the specified queue. If the <code>filters</code> parameter is
         * specified, the <code>jobStatus</code> parameter is ignored and jobs with any status are returned. If you
         * don't specify a status, only <code>RUNNING</code> jobs are returned.
         * </p>
         * 
         * @param jobStatus
         *        The job status used to filter jobs in the specified queue. If the <code>filters</code> parameter is
         *        specified, the <code>jobStatus</code> parameter is ignored and jobs with any status are returned. If
         *        you don't specify a status, only <code>RUNNING</code> jobs are returned.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The job status used to filter jobs in the specified queue. If the <code>filters</code> parameter is
         * specified, the <code>jobStatus</code> parameter is ignored and jobs with any status are returned. If you
         * don't specify a status, only <code>RUNNING</code> jobs are returned.
         * </p>
         * 
         * @param jobStatus
         *        The job status used to filter jobs in the specified queue. If the <code>filters</code> parameter is
         *        specified, the <code>jobStatus</code> parameter is ignored and jobs with any status are returned. If
         *        you don't specify a status, only <code>RUNNING</code> jobs are returned.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The maximum number of results returned by <code>ListJobs</code> in a paginated output. When this parameter is
         * used, <code>ListJobs</code> returns up to <code>maxResults</code> results in a single page and a
         * <code>nextToken</code> response element, if applicable. The remaining results of the initial request can be
         * seen by sending another <code>ListJobs</code> request with the returned <code>nextToken</code> value.
         * </p>
         * <p>
         * The following outlines key parameters and limitations:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The minimum value is 1.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>--job-status</code> is used, Batch returns up to 1000 values.
         * </p>
         * </li>
         * <li>
         * <p>
         * When <code>--filters</code> is used, Batch returns up to 100 values.
         * </p>
         * </li>
         * <li>
         * <p>
         * If neither parameter is used, then <code>ListJobs</code> returns up to 1000 results (jobs that are in the
         * <code>RUNNING</code> status) and a <code>nextToken</code> value, if applicable.
         * </p>
         * </li>
         * </ul>
         * 
         * @param maxResults
         *        The maximum number of results returned by <code>ListJobs</code> in a paginated output. When this
         *        parameter is used, <code>ListJobs</code> returns up to <code>maxResults</code> results in a single
         *        page and a <code>nextToken</code> response element, if applicable. The remaining results of the
         *        initial request can be seen by sending another <code>ListJobs</code> request with the returned
         *        <code>nextToken</code> value.</p>
         *        <p>
         *        The following outlines key parameters and limitations:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The minimum value is 1.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When <code>--job-status</code> is used, Batch returns up to 1000 values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When <code>--filters</code> is used, Batch returns up to 100 values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If neither parameter is used, then <code>ListJobs</code> returns up to 1000 results (jobs that are in
         *        the <code>RUNNING</code> status) and a <code>nextToken</code> value, if applicable.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request where
         * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
         * from the end of the previous results that returned the <code>nextToken</code> value. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not for
         * other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request
         *        where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return.</p> <note>
         *        <p>
         *        Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not
         *        for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The filter to apply to the query. Only one filter can be used at a time. When the filter is used,
         * <code>jobStatus</code> is ignored. The filter doesn't apply to child jobs in an array or multi-node parallel
         * (MNP) jobs. The results are sorted by the <code>createdAt</code> field, with the most recent jobs being
         * first.
         * </p>
         * <dl>
         * <dt>JOB_NAME</dt>
         * <dd>
         * <p>
         * The value of the filter is a case-insensitive match for the job name. If the value ends with an asterisk (*),
         * the filter matches any job name that begins with the string before the '*'. This corresponds to the
         * <code>jobName</code> value. For example, <code>test1</code> matches both <code>Test1</code> and
         * <code>test1</code>, and <code>test1*</code> matches both <code>test1</code> and <code>Test10</code>. When the
         * <code>JOB_NAME</code> filter is used, the results are grouped by the job name and version.
         * </p>
         * </dd>
         * <dt>JOB_DEFINITION</dt>
         * <dd>
         * <p>
         * The value for the filter is the name or Amazon Resource Name (ARN) of the job definition. This corresponds to
         * the <code>jobDefinition</code> value. The value is case sensitive. When the value for the filter is the job
         * definition name, the results include all the jobs that used any revision of that job definition name. If the
         * value ends with an asterisk (*), the filter matches any job definition name that begins with the string
         * before the '*'. For example, <code>jd1</code> matches only <code>jd1</code>, and <code>jd1*</code> matches
         * both <code>jd1</code> and <code>jd1A</code>. The version of the job definition that's used doesn't affect the
         * sort order. When the <code>JOB_DEFINITION</code> filter is used and the ARN is used (which is in the form
         * <code>arn:${Partition}:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code>),
         * the results include jobs that used the specified revision of the job definition. Asterisk (*) isn't supported
         * when the ARN is used.
         * </p>
         * </dd>
         * <dt>BEFORE_CREATED_AT</dt>
         * <dd>
         * <p>
         * The value for the filter is the time that's before the job was created. This corresponds to the
         * <code>createdAt</code> value. The value is a string representation of the number of milliseconds since
         * 00:00:00 UTC (midnight) on January 1, 1970.
         * </p>
         * </dd>
         * <dt>AFTER_CREATED_AT</dt>
         * <dd>
         * <p>
         * The value for the filter is the time that's after the job was created. This corresponds to the
         * <code>createdAt</code> value. The value is a string representation of the number of milliseconds since
         * 00:00:00 UTC (midnight) on January 1, 1970.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param filters
         *        The filter to apply to the query. Only one filter can be used at a time. When the filter is used,
         *        <code>jobStatus</code> is ignored. The filter doesn't apply to child jobs in an array or multi-node
         *        parallel (MNP) jobs. The results are sorted by the <code>createdAt</code> field, with the most recent
         *        jobs being first.</p>
         *        <dl>
         *        <dt>JOB_NAME</dt>
         *        <dd>
         *        <p>
         *        The value of the filter is a case-insensitive match for the job name. If the value ends with an
         *        asterisk (*), the filter matches any job name that begins with the string before the '*'. This
         *        corresponds to the <code>jobName</code> value. For example, <code>test1</code> matches both
         *        <code>Test1</code> and <code>test1</code>, and <code>test1*</code> matches both <code>test1</code> and
         *        <code>Test10</code>. When the <code>JOB_NAME</code> filter is used, the results are grouped by the job
         *        name and version.
         *        </p>
         *        </dd>
         *        <dt>JOB_DEFINITION</dt>
         *        <dd>
         *        <p>
         *        The value for the filter is the name or Amazon Resource Name (ARN) of the job definition. This
         *        corresponds to the <code>jobDefinition</code> value. The value is case sensitive. When the value for
         *        the filter is the job definition name, the results include all the jobs that used any revision of that
         *        job definition name. If the value ends with an asterisk (*), the filter matches any job definition
         *        name that begins with the string before the '*'. For example, <code>jd1</code> matches only
         *        <code>jd1</code>, and <code>jd1*</code> matches both <code>jd1</code> and <code>jd1A</code>. The
         *        version of the job definition that's used doesn't affect the sort order. When the
         *        <code>JOB_DEFINITION</code> filter is used and the ARN is used (which is in the form
         *        <code>arn:${Partition}:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code>
         *        ), the results include jobs that used the specified revision of the job definition. Asterisk (*) isn't
         *        supported when the ARN is used.
         *        </p>
         *        </dd>
         *        <dt>BEFORE_CREATED_AT</dt>
         *        <dd>
         *        <p>
         *        The value for the filter is the time that's before the job was created. This corresponds to the
         *        <code>createdAt</code> value. The value is a string representation of the number of milliseconds since
         *        00:00:00 UTC (midnight) on January 1, 1970.
         *        </p>
         *        </dd>
         *        <dt>AFTER_CREATED_AT</dt>
         *        <dd>
         *        <p>
         *        The value for the filter is the time that's after the job was created. This corresponds to the
         *        <code>createdAt</code> value. The value is a string representation of the number of milliseconds since
         *        00:00:00 UTC (midnight) on January 1, 1970.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<KeyValuesPair> filters);

        /**
         * <p>
         * The filter to apply to the query. Only one filter can be used at a time. When the filter is used,
         * <code>jobStatus</code> is ignored. The filter doesn't apply to child jobs in an array or multi-node parallel
         * (MNP) jobs. The results are sorted by the <code>createdAt</code> field, with the most recent jobs being
         * first.
         * </p>
         * <dl>
         * <dt>JOB_NAME</dt>
         * <dd>
         * <p>
         * The value of the filter is a case-insensitive match for the job name. If the value ends with an asterisk (*),
         * the filter matches any job name that begins with the string before the '*'. This corresponds to the
         * <code>jobName</code> value. For example, <code>test1</code> matches both <code>Test1</code> and
         * <code>test1</code>, and <code>test1*</code> matches both <code>test1</code> and <code>Test10</code>. When the
         * <code>JOB_NAME</code> filter is used, the results are grouped by the job name and version.
         * </p>
         * </dd>
         * <dt>JOB_DEFINITION</dt>
         * <dd>
         * <p>
         * The value for the filter is the name or Amazon Resource Name (ARN) of the job definition. This corresponds to
         * the <code>jobDefinition</code> value. The value is case sensitive. When the value for the filter is the job
         * definition name, the results include all the jobs that used any revision of that job definition name. If the
         * value ends with an asterisk (*), the filter matches any job definition name that begins with the string
         * before the '*'. For example, <code>jd1</code> matches only <code>jd1</code>, and <code>jd1*</code> matches
         * both <code>jd1</code> and <code>jd1A</code>. The version of the job definition that's used doesn't affect the
         * sort order. When the <code>JOB_DEFINITION</code> filter is used and the ARN is used (which is in the form
         * <code>arn:${Partition}:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code>),
         * the results include jobs that used the specified revision of the job definition. Asterisk (*) isn't supported
         * when the ARN is used.
         * </p>
         * </dd>
         * <dt>BEFORE_CREATED_AT</dt>
         * <dd>
         * <p>
         * The value for the filter is the time that's before the job was created. This corresponds to the
         * <code>createdAt</code> value. The value is a string representation of the number of milliseconds since
         * 00:00:00 UTC (midnight) on January 1, 1970.
         * </p>
         * </dd>
         * <dt>AFTER_CREATED_AT</dt>
         * <dd>
         * <p>
         * The value for the filter is the time that's after the job was created. This corresponds to the
         * <code>createdAt</code> value. The value is a string representation of the number of milliseconds since
         * 00:00:00 UTC (midnight) on January 1, 1970.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param filters
         *        The filter to apply to the query. Only one filter can be used at a time. When the filter is used,
         *        <code>jobStatus</code> is ignored. The filter doesn't apply to child jobs in an array or multi-node
         *        parallel (MNP) jobs. The results are sorted by the <code>createdAt</code> field, with the most recent
         *        jobs being first.</p>
         *        <dl>
         *        <dt>JOB_NAME</dt>
         *        <dd>
         *        <p>
         *        The value of the filter is a case-insensitive match for the job name. If the value ends with an
         *        asterisk (*), the filter matches any job name that begins with the string before the '*'. This
         *        corresponds to the <code>jobName</code> value. For example, <code>test1</code> matches both
         *        <code>Test1</code> and <code>test1</code>, and <code>test1*</code> matches both <code>test1</code> and
         *        <code>Test10</code>. When the <code>JOB_NAME</code> filter is used, the results are grouped by the job
         *        name and version.
         *        </p>
         *        </dd>
         *        <dt>JOB_DEFINITION</dt>
         *        <dd>
         *        <p>
         *        The value for the filter is the name or Amazon Resource Name (ARN) of the job definition. This
         *        corresponds to the <code>jobDefinition</code> value. The value is case sensitive. When the value for
         *        the filter is the job definition name, the results include all the jobs that used any revision of that
         *        job definition name. If the value ends with an asterisk (*), the filter matches any job definition
         *        name that begins with the string before the '*'. For example, <code>jd1</code> matches only
         *        <code>jd1</code>, and <code>jd1*</code> matches both <code>jd1</code> and <code>jd1A</code>. The
         *        version of the job definition that's used doesn't affect the sort order. When the
         *        <code>JOB_DEFINITION</code> filter is used and the ARN is used (which is in the form
         *        <code>arn:${Partition}:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code>
         *        ), the results include jobs that used the specified revision of the job definition. Asterisk (*) isn't
         *        supported when the ARN is used.
         *        </p>
         *        </dd>
         *        <dt>BEFORE_CREATED_AT</dt>
         *        <dd>
         *        <p>
         *        The value for the filter is the time that's before the job was created. This corresponds to the
         *        <code>createdAt</code> value. The value is a string representation of the number of milliseconds since
         *        00:00:00 UTC (midnight) on January 1, 1970.
         *        </p>
         *        </dd>
         *        <dt>AFTER_CREATED_AT</dt>
         *        <dd>
         *        <p>
         *        The value for the filter is the time that's after the job was created. This corresponds to the
         *        <code>createdAt</code> value. The value is a string representation of the number of milliseconds since
         *        00:00:00 UTC (midnight) on January 1, 1970.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(KeyValuesPair... filters);

        /**
         * <p>
         * The filter to apply to the query. Only one filter can be used at a time. When the filter is used,
         * <code>jobStatus</code> is ignored. The filter doesn't apply to child jobs in an array or multi-node parallel
         * (MNP) jobs. The results are sorted by the <code>createdAt</code> field, with the most recent jobs being
         * first.
         * </p>
         * <dl>
         * <dt>JOB_NAME</dt>
         * <dd>
         * <p>
         * The value of the filter is a case-insensitive match for the job name. If the value ends with an asterisk (*),
         * the filter matches any job name that begins with the string before the '*'. This corresponds to the
         * <code>jobName</code> value. For example, <code>test1</code> matches both <code>Test1</code> and
         * <code>test1</code>, and <code>test1*</code> matches both <code>test1</code> and <code>Test10</code>. When the
         * <code>JOB_NAME</code> filter is used, the results are grouped by the job name and version.
         * </p>
         * </dd>
         * <dt>JOB_DEFINITION</dt>
         * <dd>
         * <p>
         * The value for the filter is the name or Amazon Resource Name (ARN) of the job definition. This corresponds to
         * the <code>jobDefinition</code> value. The value is case sensitive. When the value for the filter is the job
         * definition name, the results include all the jobs that used any revision of that job definition name. If the
         * value ends with an asterisk (*), the filter matches any job definition name that begins with the string
         * before the '*'. For example, <code>jd1</code> matches only <code>jd1</code>, and <code>jd1*</code> matches
         * both <code>jd1</code> and <code>jd1A</code>. The version of the job definition that's used doesn't affect the
         * sort order. When the <code>JOB_DEFINITION</code> filter is used and the ARN is used (which is in the form
         * <code>arn:${Partition}:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code>),
         * the results include jobs that used the specified revision of the job definition. Asterisk (*) isn't supported
         * when the ARN is used.
         * </p>
         * </dd>
         * <dt>BEFORE_CREATED_AT</dt>
         * <dd>
         * <p>
         * The value for the filter is the time that's before the job was created. This corresponds to the
         * <code>createdAt</code> value. The value is a string representation of the number of milliseconds since
         * 00:00:00 UTC (midnight) on January 1, 1970.
         * </p>
         * </dd>
         * <dt>AFTER_CREATED_AT</dt>
         * <dd>
         * <p>
         * The value for the filter is the time that's after the job was created. This corresponds to the
         * <code>createdAt</code> value. The value is a string representation of the number of milliseconds since
         * 00:00:00 UTC (midnight) on January 1, 1970.
         * </p>
         * </dd>
         * </dl>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.KeyValuesPair.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.batch.model.KeyValuesPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.KeyValuesPair.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<KeyValuesPair>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.KeyValuesPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<KeyValuesPair>)
         */
        Builder filters(Consumer<KeyValuesPair.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobQueue;

        private String arrayJobId;

        private String multiNodeJobId;

        private String jobStatus;

        private Integer maxResults;

        private String nextToken;

        private List<KeyValuesPair> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsRequest model) {
            super(model);
            jobQueue(model.jobQueue);
            arrayJobId(model.arrayJobId);
            multiNodeJobId(model.multiNodeJobId);
            jobStatus(model.jobStatus);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final String getArrayJobId() {
            return arrayJobId;
        }

        public final void setArrayJobId(String arrayJobId) {
            this.arrayJobId = arrayJobId;
        }

        @Override
        public final Builder arrayJobId(String arrayJobId) {
            this.arrayJobId = arrayJobId;
            return this;
        }

        public final String getMultiNodeJobId() {
            return multiNodeJobId;
        }

        public final void setMultiNodeJobId(String multiNodeJobId) {
            this.multiNodeJobId = multiNodeJobId;
        }

        @Override
        public final Builder multiNodeJobId(String multiNodeJobId) {
            this.multiNodeJobId = multiNodeJobId;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<KeyValuesPair.Builder> getFilters() {
            List<KeyValuesPair.Builder> result = ListJobsFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<KeyValuesPair.BuilderImpl> filters) {
            this.filters = ListJobsFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<KeyValuesPair> filters) {
            this.filters = ListJobsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(KeyValuesPair... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<KeyValuesPair.Builder>... filters) {
            filters(Stream.of(filters).map(c -> KeyValuesPair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobsRequest build() {
            return new ListJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
