/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.DescribeServiceEnvironmentsRequest;
import software.amazon.awssdk.services.batch.model.DescribeServiceEnvironmentsResponse;
import software.amazon.awssdk.services.batch.model.ServiceEnvironmentDetail;

public class DescribeServiceEnvironmentsIterable
implements SdkIterable<DescribeServiceEnvironmentsResponse> {
    private final BatchClient client;
    private final DescribeServiceEnvironmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeServiceEnvironmentsIterable(BatchClient client, DescribeServiceEnvironmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeServiceEnvironmentsResponseFetcher();
    }

    public Iterator<DescribeServiceEnvironmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceEnvironmentDetail> serviceEnvironments() {
        Function<DescribeServiceEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceEnvironments() != null) {
                return response.serviceEnvironments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeServiceEnvironmentsResponseFetcher
    implements SyncPageFetcher<DescribeServiceEnvironmentsResponse> {
        private DescribeServiceEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServiceEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeServiceEnvironmentsResponse nextPage(DescribeServiceEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeServiceEnvironmentsIterable.this.client.describeServiceEnvironments(DescribeServiceEnvironmentsIterable.this.firstRequest);
            }
            return DescribeServiceEnvironmentsIterable.this.client.describeServiceEnvironments((DescribeServiceEnvironmentsRequest)((Object)DescribeServiceEnvironmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

