/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceEnvironmentResponse extends BatchResponse implements
        ToCopyableBuilder<UpdateServiceEnvironmentResponse.Builder, UpdateServiceEnvironmentResponse> {
    private static final SdkField<String> SERVICE_ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceEnvironmentName").getter(getter(UpdateServiceEnvironmentResponse::serviceEnvironmentName))
            .setter(setter(Builder::serviceEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceEnvironmentName").build())
            .build();

    private static final SdkField<String> SERVICE_ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceEnvironmentArn").getter(getter(UpdateServiceEnvironmentResponse::serviceEnvironmentArn))
            .setter(setter(Builder::serviceEnvironmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceEnvironmentArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SERVICE_ENVIRONMENT_NAME_FIELD, SERVICE_ENVIRONMENT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceEnvironmentName;

    private final String serviceEnvironmentArn;

    private UpdateServiceEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.serviceEnvironmentName = builder.serviceEnvironmentName;
        this.serviceEnvironmentArn = builder.serviceEnvironmentArn;
    }

    /**
     * <p>
     * The name of the service environment that was updated.
     * </p>
     * 
     * @return The name of the service environment that was updated.
     */
    public final String serviceEnvironmentName() {
        return serviceEnvironmentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service environment that was updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service environment that was updated.
     */
    public final String serviceEnvironmentArn() {
        return serviceEnvironmentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceEnvironmentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceEnvironmentResponse)) {
            return false;
        }
        UpdateServiceEnvironmentResponse other = (UpdateServiceEnvironmentResponse) obj;
        return Objects.equals(serviceEnvironmentName(), other.serviceEnvironmentName())
                && Objects.equals(serviceEnvironmentArn(), other.serviceEnvironmentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceEnvironmentResponse").add("ServiceEnvironmentName", serviceEnvironmentName())
                .add("ServiceEnvironmentArn", serviceEnvironmentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceEnvironmentName":
            return Optional.ofNullable(clazz.cast(serviceEnvironmentName()));
        case "serviceEnvironmentArn":
            return Optional.ofNullable(clazz.cast(serviceEnvironmentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceEnvironmentName", SERVICE_ENVIRONMENT_NAME_FIELD);
        map.put("serviceEnvironmentArn", SERVICE_ENVIRONMENT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceEnvironmentResponse, T> g) {
        return obj -> g.apply((UpdateServiceEnvironmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceEnvironmentResponse> {
        /**
         * <p>
         * The name of the service environment that was updated.
         * </p>
         * 
         * @param serviceEnvironmentName
         *        The name of the service environment that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceEnvironmentName(String serviceEnvironmentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service environment that was updated.
         * </p>
         * 
         * @param serviceEnvironmentArn
         *        The Amazon Resource Name (ARN) of the service environment that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceEnvironmentArn(String serviceEnvironmentArn);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private String serviceEnvironmentName;

        private String serviceEnvironmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceEnvironmentResponse model) {
            super(model);
            serviceEnvironmentName(model.serviceEnvironmentName);
            serviceEnvironmentArn(model.serviceEnvironmentArn);
        }

        public final String getServiceEnvironmentName() {
            return serviceEnvironmentName;
        }

        public final void setServiceEnvironmentName(String serviceEnvironmentName) {
            this.serviceEnvironmentName = serviceEnvironmentName;
        }

        @Override
        public final Builder serviceEnvironmentName(String serviceEnvironmentName) {
            this.serviceEnvironmentName = serviceEnvironmentName;
            return this;
        }

        public final String getServiceEnvironmentArn() {
            return serviceEnvironmentArn;
        }

        public final void setServiceEnvironmentArn(String serviceEnvironmentArn) {
            this.serviceEnvironmentArn = serviceEnvironmentArn;
        }

        @Override
        public final Builder serviceEnvironmentArn(String serviceEnvironmentArn) {
            this.serviceEnvironmentArn = serviceEnvironmentArn;
            return this;
        }

        @Override
        public UpdateServiceEnvironmentResponse build() {
            return new UpdateServiceEnvironmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
