/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a service job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceJobSummary.Builder, ServiceJobSummary> {
    private static final SdkField<LatestServiceJobAttempt> LATEST_ATTEMPT_FIELD = SdkField
            .<LatestServiceJobAttempt> builder(MarshallingType.SDK_POJO).memberName("latestAttempt")
            .getter(getter(ServiceJobSummary::latestAttempt)).setter(setter(Builder::latestAttempt))
            .constructor(LatestServiceJobAttempt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAttempt").build()).build();

    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("createdAt")
            .getter(getter(ServiceJobSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(ServiceJobSummary::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(ServiceJobSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(ServiceJobSummary::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> SERVICE_JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceJobType").getter(getter(ServiceJobSummary::serviceJobTypeAsString))
            .setter(setter(Builder::serviceJobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceJobType").build()).build();

    private static final SdkField<String> SHARE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shareIdentifier").getter(getter(ServiceJobSummary::shareIdentifier))
            .setter(setter(Builder::shareIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareIdentifier").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ServiceJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(ServiceJobSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("startedAt")
            .getter(getter(ServiceJobSummary::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("stoppedAt")
            .getter(getter(ServiceJobSummary::stoppedAt)).setter(setter(Builder::stoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_ATTEMPT_FIELD,
            CREATED_AT_FIELD, JOB_ARN_FIELD, JOB_ID_FIELD, JOB_NAME_FIELD, SERVICE_JOB_TYPE_FIELD, SHARE_IDENTIFIER_FIELD,
            STATUS_FIELD, STATUS_REASON_FIELD, STARTED_AT_FIELD, STOPPED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LatestServiceJobAttempt latestAttempt;

    private final Long createdAt;

    private final String jobArn;

    private final String jobId;

    private final String jobName;

    private final String serviceJobType;

    private final String shareIdentifier;

    private final String status;

    private final String statusReason;

    private final Long startedAt;

    private final Long stoppedAt;

    private ServiceJobSummary(BuilderImpl builder) {
        this.latestAttempt = builder.latestAttempt;
        this.createdAt = builder.createdAt;
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.serviceJobType = builder.serviceJobType;
        this.shareIdentifier = builder.shareIdentifier;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
    }

    /**
     * <p>
     * Information about the latest attempt for the service job.
     * </p>
     * 
     * @return Information about the latest attempt for the service job.
     */
    public final LatestServiceJobAttempt latestAttempt() {
        return latestAttempt;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the service job was created.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the service job was created.
     */
    public final Long createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The job ID for the service job.
     * </p>
     * 
     * @return The job ID for the service job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name of the service job.
     * </p>
     * 
     * @return The name of the service job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceJobType}
     * will return {@link ServiceJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceJobTypeAsString}.
     * </p>
     * 
     * @return The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
     * @see ServiceJobType
     */
    public final ServiceJobType serviceJobType() {
        return ServiceJobType.fromValue(serviceJobType);
    }

    /**
     * <p>
     * The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceJobType}
     * will return {@link ServiceJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceJobTypeAsString}.
     * </p>
     * 
     * @return The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
     * @see ServiceJobType
     */
    public final String serviceJobTypeAsString() {
        return serviceJobType;
    }

    /**
     * <p>
     * The share identifier for the job.
     * </p>
     * 
     * @return The share identifier for the job.
     */
    public final String shareIdentifier() {
        return shareIdentifier;
    }

    /**
     * <p>
     * The current status of the service job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the service job.
     * @see ServiceJobStatus
     */
    public final ServiceJobStatus status() {
        return ServiceJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the service job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the service job.
     * @see ServiceJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A short string to provide more details on the current status of the service job.
     * </p>
     * 
     * @return A short string to provide more details on the current status of the service job.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the service job was started.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the service job was started.
     */
    public final Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the service job stopped running.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the service job stopped running.
     */
    public final Long stoppedAt() {
        return stoppedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(latestAttempt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceJobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceJobSummary)) {
            return false;
        }
        ServiceJobSummary other = (ServiceJobSummary) obj;
        return Objects.equals(latestAttempt(), other.latestAttempt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobName(), other.jobName())
                && Objects.equals(serviceJobTypeAsString(), other.serviceJobTypeAsString())
                && Objects.equals(shareIdentifier(), other.shareIdentifier())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(stoppedAt(), other.stoppedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceJobSummary").add("LatestAttempt", latestAttempt()).add("CreatedAt", createdAt())
                .add("JobArn", jobArn()).add("JobId", jobId()).add("JobName", jobName())
                .add("ServiceJobType", serviceJobTypeAsString()).add("ShareIdentifier", shareIdentifier())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("StartedAt", startedAt())
                .add("StoppedAt", stoppedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "latestAttempt":
            return Optional.ofNullable(clazz.cast(latestAttempt()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "serviceJobType":
            return Optional.ofNullable(clazz.cast(serviceJobTypeAsString()));
        case "shareIdentifier":
            return Optional.ofNullable(clazz.cast(shareIdentifier()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "stoppedAt":
            return Optional.ofNullable(clazz.cast(stoppedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("latestAttempt", LATEST_ATTEMPT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("serviceJobType", SERVICE_JOB_TYPE_FIELD);
        map.put("shareIdentifier", SHARE_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("stoppedAt", STOPPED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceJobSummary, T> g) {
        return obj -> g.apply((ServiceJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceJobSummary> {
        /**
         * <p>
         * Information about the latest attempt for the service job.
         * </p>
         * 
         * @param latestAttempt
         *        Information about the latest attempt for the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestAttempt(LatestServiceJobAttempt latestAttempt);

        /**
         * <p>
         * Information about the latest attempt for the service job.
         * </p>
         * This is a convenience method that creates an instance of the {@link LatestServiceJobAttempt.Builder} avoiding
         * the need to create one manually via {@link LatestServiceJobAttempt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LatestServiceJobAttempt.Builder#build()} is called immediately
         * and its result is passed to {@link #latestAttempt(LatestServiceJobAttempt)}.
         * 
         * @param latestAttempt
         *        a consumer that will call methods on {@link LatestServiceJobAttempt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestAttempt(LatestServiceJobAttempt)
         */
        default Builder latestAttempt(Consumer<LatestServiceJobAttempt.Builder> latestAttempt) {
            return latestAttempt(LatestServiceJobAttempt.builder().applyMutation(latestAttempt).build());
        }

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the service job was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp (in milliseconds) for when the service job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Long createdAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The job ID for the service job.
         * </p>
         * 
         * @param jobId
         *        The job ID for the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name of the service job.
         * </p>
         * 
         * @param jobName
         *        The name of the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
         * </p>
         * 
         * @param serviceJobType
         *        The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
         * @see ServiceJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobType
         */
        Builder serviceJobType(String serviceJobType);

        /**
         * <p>
         * The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
         * </p>
         * 
         * @param serviceJobType
         *        The type of service job. For SageMaker Training jobs, this value is <code>SAGEMAKER_TRAINING</code>.
         * @see ServiceJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobType
         */
        Builder serviceJobType(ServiceJobType serviceJobType);

        /**
         * <p>
         * The share identifier for the job.
         * </p>
         * 
         * @param shareIdentifier
         *        The share identifier for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareIdentifier(String shareIdentifier);

        /**
         * <p>
         * The current status of the service job.
         * </p>
         * 
         * @param status
         *        The current status of the service job.
         * @see ServiceJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the service job.
         * </p>
         * 
         * @param status
         *        The current status of the service job.
         * @see ServiceJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobStatus
         */
        Builder status(ServiceJobStatus status);

        /**
         * <p>
         * A short string to provide more details on the current status of the service job.
         * </p>
         * 
         * @param statusReason
         *        A short string to provide more details on the current status of the service job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the service job was started.
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp (in milliseconds) for when the service job was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the service job stopped running.
         * </p>
         * 
         * @param stoppedAt
         *        The Unix timestamp (in milliseconds) for when the service job stopped running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Long stoppedAt);
    }

    static final class BuilderImpl implements Builder {
        private LatestServiceJobAttempt latestAttempt;

        private Long createdAt;

        private String jobArn;

        private String jobId;

        private String jobName;

        private String serviceJobType;

        private String shareIdentifier;

        private String status;

        private String statusReason;

        private Long startedAt;

        private Long stoppedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceJobSummary model) {
            latestAttempt(model.latestAttempt);
            createdAt(model.createdAt);
            jobArn(model.jobArn);
            jobId(model.jobId);
            jobName(model.jobName);
            serviceJobType(model.serviceJobType);
            shareIdentifier(model.shareIdentifier);
            status(model.status);
            statusReason(model.statusReason);
            startedAt(model.startedAt);
            stoppedAt(model.stoppedAt);
        }

        public final LatestServiceJobAttempt.Builder getLatestAttempt() {
            return latestAttempt != null ? latestAttempt.toBuilder() : null;
        }

        public final void setLatestAttempt(LatestServiceJobAttempt.BuilderImpl latestAttempt) {
            this.latestAttempt = latestAttempt != null ? latestAttempt.build() : null;
        }

        @Override
        public final Builder latestAttempt(LatestServiceJobAttempt latestAttempt) {
            this.latestAttempt = latestAttempt;
            return this;
        }

        public final Long getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getServiceJobType() {
            return serviceJobType;
        }

        public final void setServiceJobType(String serviceJobType) {
            this.serviceJobType = serviceJobType;
        }

        @Override
        public final Builder serviceJobType(String serviceJobType) {
            this.serviceJobType = serviceJobType;
            return this;
        }

        @Override
        public final Builder serviceJobType(ServiceJobType serviceJobType) {
            this.serviceJobType(serviceJobType == null ? null : serviceJobType.toString());
            return this;
        }

        public final String getShareIdentifier() {
            return shareIdentifier;
        }

        public final void setShareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
        }

        @Override
        public final Builder shareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Long getStoppedAt() {
            return stoppedAt;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        @Override
        public ServiceJobSummary build() {
            return new ServiceJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
