/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes and uniquely identifies Kubernetes resources. For example, the compute environment that a pod runs in or
 * the <code>jobID</code> for a job running in the pod. For more information, see <a
 * href="https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/"> Understanding
 * Kubernetes Objects</a> in the <i>Kubernetes documentation</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksMetadata implements SdkPojo, Serializable, ToCopyableBuilder<EksMetadata.Builder, EksMetadata> {
    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("labels")
            .getter(getter(EksMetadata::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ANNOTATIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("annotations")
            .getter(getter(EksMetadata::annotations))
            .setter(setter(Builder::annotations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(EksMetadata::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELS_FIELD,
            ANNOTATIONS_FIELD, NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> labels;

    private final Map<String, String> annotations;

    private final String namespace;

    private EksMetadata(BuilderImpl builder) {
        this.labels = builder.labels;
        this.annotations = builder.annotations;
        this.namespace = builder.namespace;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key-value pairs used to identify, sort, and organize cube resources. Can contain up to 63 uppercase letters,
     * lowercase letters, numbers, hyphens (-), and underscores (_). Labels can be added or modified at any time. Each
     * resource can have multiple labels, but each key must be unique for a given object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return Key-value pairs used to identify, sort, and organize cube resources. Can contain up to 63 uppercase
     *         letters, lowercase letters, numbers, hyphens (-), and underscores (_). Labels can be added or modified at
     *         any time. Each resource can have multiple labels, but each key must be unique for a given object.
     */
    public final Map<String, String> labels() {
        return labels;
    }

    /**
     * For responses, this returns true if the service returned a value for the Annotations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnnotations() {
        return annotations != null && !(annotations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key-value pairs used to attach arbitrary, non-identifying metadata to Kubernetes objects. Valid annotation keys
     * have two segments: an optional prefix and a name, separated by a slash (/).
     * </p>
     * <ul>
     * <li>
     * <p>
     * The prefix is optional and must be 253 characters or less. If specified, the prefix must be a DNS subdomain− a
     * series of DNS labels separated by dots (.), and it must end with a slash (/).
     * </p>
     * </li>
     * <li>
     * <p>
     * The name segment is required and must be 63 characters or less. It can include alphanumeric characters
     * ([a-z0-9A-Z]), dashes (-), underscores (_), and dots (.), but must begin and end with an alphanumeric character.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Annotation values must be 255 characters or less.
     * </p>
     * </note>
     * <p>
     * Annotations can be added or modified at any time. Each resource can have multiple annotations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnnotations} method.
     * </p>
     * 
     * @return Key-value pairs used to attach arbitrary, non-identifying metadata to Kubernetes objects. Valid
     *         annotation keys have two segments: an optional prefix and a name, separated by a slash (/). </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The prefix is optional and must be 253 characters or less. If specified, the prefix must be a DNS
     *         subdomain− a series of DNS labels separated by dots (.), and it must end with a slash (/).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The name segment is required and must be 63 characters or less. It can include alphanumeric characters
     *         ([a-z0-9A-Z]), dashes (-), underscores (_), and dots (.), but must begin and end with an alphanumeric
     *         character.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Annotation values must be 255 characters or less.
     *         </p>
     *         </note>
     *         <p>
     *         Annotations can be added or modified at any time. Each resource can have multiple annotations.
     */
    public final Map<String, String> annotations() {
        return annotations;
    }

    /**
     * <p>
     * The namespace of the Amazon EKS cluster. In Kubernetes, namespaces provide a mechanism for isolating groups of
     * resources within a single cluster. Names of resources need to be unique within a namespace, but not across
     * namespaces. Batch places Batch Job pods in this namespace. If this field is provided, the value can't be empty or
     * null. It must meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * 1-63 characters long
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be set to default
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't start with <code>kube</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Must match the following regular expression: <code>^[a-z0-9]([-a-z0-9]*[a-z0-9])?$</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/">Namespaces</a> in the
     * <i>Kubernetes documentation</i>. This namespace can be different from the <code>kubernetesNamespace</code> set in
     * the compute environment's <code>EksConfiguration</code>, but must have identical role-based access control (RBAC)
     * roles as the compute environment's <code>kubernetesNamespace</code>. For multi-node parallel jobs, the same value
     * must be provided across all the node ranges.
     * </p>
     * 
     * @return The namespace of the Amazon EKS cluster. In Kubernetes, namespaces provide a mechanism for isolating
     *         groups of resources within a single cluster. Names of resources need to be unique within a namespace, but
     *         not across namespaces. Batch places Batch Job pods in this namespace. If this field is provided, the
     *         value can't be empty or null. It must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         1-63 characters long
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be set to default
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't start with <code>kube</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must match the following regular expression: <code>^[a-z0-9]([-a-z0-9]*[a-z0-9])?$</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/">Namespaces</a> in
     *         the <i>Kubernetes documentation</i>. This namespace can be different from the
     *         <code>kubernetesNamespace</code> set in the compute environment's <code>EksConfiguration</code>, but must
     *         have identical role-based access control (RBAC) roles as the compute environment's
     *         <code>kubernetesNamespace</code>. For multi-node parallel jobs, the same value must be provided across
     *         all the node ranges.
     */
    public final String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAnnotations() ? annotations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksMetadata)) {
            return false;
        }
        EksMetadata other = (EksMetadata) obj;
        return hasLabels() == other.hasLabels() && Objects.equals(labels(), other.labels())
                && hasAnnotations() == other.hasAnnotations() && Objects.equals(annotations(), other.annotations())
                && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksMetadata").add("Labels", hasLabels() ? labels() : null)
                .add("Annotations", hasAnnotations() ? annotations() : null).add("Namespace", namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "annotations":
            return Optional.ofNullable(clazz.cast(annotations()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("labels", LABELS_FIELD);
        map.put("annotations", ANNOTATIONS_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksMetadata, T> g) {
        return obj -> g.apply((EksMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksMetadata> {
        /**
         * <p>
         * Key-value pairs used to identify, sort, and organize cube resources. Can contain up to 63 uppercase letters,
         * lowercase letters, numbers, hyphens (-), and underscores (_). Labels can be added or modified at any time.
         * Each resource can have multiple labels, but each key must be unique for a given object.
         * </p>
         * 
         * @param labels
         *        Key-value pairs used to identify, sort, and organize cube resources. Can contain up to 63 uppercase
         *        letters, lowercase letters, numbers, hyphens (-), and underscores (_). Labels can be added or modified
         *        at any time. Each resource can have multiple labels, but each key must be unique for a given object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Map<String, String> labels);

        /**
         * <p>
         * Key-value pairs used to attach arbitrary, non-identifying metadata to Kubernetes objects. Valid annotation
         * keys have two segments: an optional prefix and a name, separated by a slash (/).
         * </p>
         * <ul>
         * <li>
         * <p>
         * The prefix is optional and must be 253 characters or less. If specified, the prefix must be a DNS subdomain−
         * a series of DNS labels separated by dots (.), and it must end with a slash (/).
         * </p>
         * </li>
         * <li>
         * <p>
         * The name segment is required and must be 63 characters or less. It can include alphanumeric characters
         * ([a-z0-9A-Z]), dashes (-), underscores (_), and dots (.), but must begin and end with an alphanumeric
         * character.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Annotation values must be 255 characters or less.
         * </p>
         * </note>
         * <p>
         * Annotations can be added or modified at any time. Each resource can have multiple annotations.
         * </p>
         * 
         * @param annotations
         *        Key-value pairs used to attach arbitrary, non-identifying metadata to Kubernetes objects. Valid
         *        annotation keys have two segments: an optional prefix and a name, separated by a slash (/). </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The prefix is optional and must be 253 characters or less. If specified, the prefix must be a DNS
         *        subdomain− a series of DNS labels separated by dots (.), and it must end with a slash (/).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name segment is required and must be 63 characters or less. It can include alphanumeric characters
         *        ([a-z0-9A-Z]), dashes (-), underscores (_), and dots (.), but must begin and end with an alphanumeric
         *        character.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Annotation values must be 255 characters or less.
         *        </p>
         *        </note>
         *        <p>
         *        Annotations can be added or modified at any time. Each resource can have multiple annotations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(Map<String, String> annotations);

        /**
         * <p>
         * The namespace of the Amazon EKS cluster. In Kubernetes, namespaces provide a mechanism for isolating groups
         * of resources within a single cluster. Names of resources need to be unique within a namespace, but not across
         * namespaces. Batch places Batch Job pods in this namespace. If this field is provided, the value can't be
         * empty or null. It must meet the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * 1-63 characters long
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be set to default
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't start with <code>kube</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Must match the following regular expression: <code>^[a-z0-9]([-a-z0-9]*[a-z0-9])?$</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/">Namespaces</a> in the
         * <i>Kubernetes documentation</i>. This namespace can be different from the <code>kubernetesNamespace</code>
         * set in the compute environment's <code>EksConfiguration</code>, but must have identical role-based access
         * control (RBAC) roles as the compute environment's <code>kubernetesNamespace</code>. For multi-node parallel
         * jobs, the same value must be provided across all the node ranges.
         * </p>
         * 
         * @param namespace
         *        The namespace of the Amazon EKS cluster. In Kubernetes, namespaces provide a mechanism for isolating
         *        groups of resources within a single cluster. Names of resources need to be unique within a namespace,
         *        but not across namespaces. Batch places Batch Job pods in this namespace. If this field is provided,
         *        the value can't be empty or null. It must meet the following requirements:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        1-63 characters long
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be set to default
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't start with <code>kube</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must match the following regular expression: <code>^[a-z0-9]([-a-z0-9]*[a-z0-9])?$</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/">Namespaces</a> in
         *        the <i>Kubernetes documentation</i>. This namespace can be different from the
         *        <code>kubernetesNamespace</code> set in the compute environment's <code>EksConfiguration</code>, but
         *        must have identical role-based access control (RBAC) roles as the compute environment's
         *        <code>kubernetesNamespace</code>. For multi-node parallel jobs, the same value must be provided across
         *        all the node ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> annotations = DefaultSdkAutoConstructMap.getInstance();

        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(EksMetadata model) {
            labels(model.labels);
            annotations(model.annotations);
            namespace(model.namespace);
        }

        public final Map<String, String> getLabels() {
            if (labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return labels;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = EksLabelsMapCopier.copy(labels);
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = EksLabelsMapCopier.copy(labels);
            return this;
        }

        public final Map<String, String> getAnnotations() {
            if (annotations instanceof SdkAutoConstructMap) {
                return null;
            }
            return annotations;
        }

        public final void setAnnotations(Map<String, String> annotations) {
            this.annotations = EksAnnotationsMapCopier.copy(annotations);
        }

        @Override
        public final Builder annotations(Map<String, String> annotations) {
            this.annotations = EksAnnotationsMapCopier.copy(annotations);
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public EksMetadata build() {
            return new EksMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
