/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the details of a task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttemptEcsTaskDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AttemptEcsTaskDetails.Builder, AttemptEcsTaskDetails> {
    private static final SdkField<String> CONTAINER_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerInstanceArn").getter(getter(AttemptEcsTaskDetails::containerInstanceArn))
            .setter(setter(Builder::containerInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArn").build())
            .build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskArn").getter(getter(AttemptEcsTaskDetails::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()).build();

    private static final SdkField<List<AttemptTaskContainerDetails>> CONTAINERS_FIELD = SdkField
            .<List<AttemptTaskContainerDetails>> builder(MarshallingType.LIST)
            .memberName("containers")
            .getter(getter(AttemptEcsTaskDetails::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttemptTaskContainerDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttemptTaskContainerDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_INSTANCE_ARN_FIELD,
            TASK_ARN_FIELD, CONTAINERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String containerInstanceArn;

    private final String taskArn;

    private final List<AttemptTaskContainerDetails> containers;

    private AttemptEcsTaskDetails(BuilderImpl builder) {
        this.containerInstanceArn = builder.containerInstanceArn;
        this.taskArn = builder.taskArn;
        this.containers = builder.containers;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the container instance that hosts the task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the container instance that hosts the task.
     */
    public final String containerInstanceArn() {
        return containerInstanceArn;
    }

    /**
     * <p>
     * The ARN of the Amazon ECS task.
     * </p>
     * 
     * @return The ARN of the Amazon ECS task.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of containers that are included in the <code>taskProperties</code> list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return A list of containers that are included in the <code>taskProperties</code> list.
     */
    public final List<AttemptTaskContainerDetails> containers() {
        return containers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttemptEcsTaskDetails)) {
            return false;
        }
        AttemptEcsTaskDetails other = (AttemptEcsTaskDetails) obj;
        return Objects.equals(containerInstanceArn(), other.containerInstanceArn()) && Objects.equals(taskArn(), other.taskArn())
                && hasContainers() == other.hasContainers() && Objects.equals(containers(), other.containers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttemptEcsTaskDetails").add("ContainerInstanceArn", containerInstanceArn())
                .add("TaskArn", taskArn()).add("Containers", hasContainers() ? containers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerInstanceArn":
            return Optional.ofNullable(clazz.cast(containerInstanceArn()));
        case "taskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "containers":
            return Optional.ofNullable(clazz.cast(containers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("containerInstanceArn", CONTAINER_INSTANCE_ARN_FIELD);
        map.put("taskArn", TASK_ARN_FIELD);
        map.put("containers", CONTAINERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttemptEcsTaskDetails, T> g) {
        return obj -> g.apply((AttemptEcsTaskDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttemptEcsTaskDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the container instance that hosts the task.
         * </p>
         * 
         * @param containerInstanceArn
         *        The Amazon Resource Name (ARN) of the container instance that hosts the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstanceArn(String containerInstanceArn);

        /**
         * <p>
         * The ARN of the Amazon ECS task.
         * </p>
         * 
         * @param taskArn
         *        The ARN of the Amazon ECS task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * A list of containers that are included in the <code>taskProperties</code> list.
         * </p>
         * 
         * @param containers
         *        A list of containers that are included in the <code>taskProperties</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<AttemptTaskContainerDetails> containers);

        /**
         * <p>
         * A list of containers that are included in the <code>taskProperties</code> list.
         * </p>
         * 
         * @param containers
         *        A list of containers that are included in the <code>taskProperties</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(AttemptTaskContainerDetails... containers);

        /**
         * <p>
         * A list of containers that are included in the <code>taskProperties</code> list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.AttemptTaskContainerDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.batch.model.AttemptTaskContainerDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.AttemptTaskContainerDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #containers(List<AttemptTaskContainerDetails>)}.
         * 
         * @param containers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.AttemptTaskContainerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(java.util.Collection<AttemptTaskContainerDetails>)
         */
        Builder containers(Consumer<AttemptTaskContainerDetails.Builder>... containers);
    }

    static final class BuilderImpl implements Builder {
        private String containerInstanceArn;

        private String taskArn;

        private List<AttemptTaskContainerDetails> containers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttemptEcsTaskDetails model) {
            containerInstanceArn(model.containerInstanceArn);
            taskArn(model.taskArn);
            containers(model.containers);
        }

        public final String getContainerInstanceArn() {
            return containerInstanceArn;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final List<AttemptTaskContainerDetails.Builder> getContainers() {
            List<AttemptTaskContainerDetails.Builder> result = ListAttemptTaskContainerDetailsCopier
                    .copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<AttemptTaskContainerDetails.BuilderImpl> containers) {
            this.containers = ListAttemptTaskContainerDetailsCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<AttemptTaskContainerDetails> containers) {
            this.containers = ListAttemptTaskContainerDetailsCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(AttemptTaskContainerDetails... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<AttemptTaskContainerDetails.Builder>... containers) {
            containers(Stream.of(containers).map(c -> AttemptTaskContainerDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AttemptEcsTaskDetails build() {
            return new AttemptEcsTaskDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
