/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the array properties of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArrayPropertiesDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ArrayPropertiesDetail.Builder, ArrayPropertiesDetail> {
    private static final SdkField<Map<String, Integer>> STATUS_SUMMARY_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("statusSummary")
            .getter(getter(ArrayPropertiesDetail::statusSummary))
            .setter(setter(Builder::statusSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("size")
            .getter(getter(ArrayPropertiesDetail::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()).build();

    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("index")
            .getter(getter(ArrayPropertiesDetail::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_SUMMARY_FIELD,
            SIZE_FIELD, INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, Integer> statusSummary;

    private final Integer size;

    private final Integer index;

    private ArrayPropertiesDetail(BuilderImpl builder) {
        this.statusSummary = builder.statusSummary;
        this.size = builder.size;
        this.index = builder.index;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusSummary property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusSummary() {
        return statusSummary != null && !(statusSummary instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A summary of the number of array job children in each available job status. This parameter is returned for parent
     * array jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusSummary} method.
     * </p>
     * 
     * @return A summary of the number of array job children in each available job status. This parameter is returned
     *         for parent array jobs.
     */
    public final Map<String, Integer> statusSummary() {
        return statusSummary;
    }

    /**
     * <p>
     * The size of the array job. This parameter is returned for parent array jobs.
     * </p>
     * 
     * @return The size of the array job. This parameter is returned for parent array jobs.
     */
    public final Integer size() {
        return size;
    }

    /**
     * <p>
     * The job index within the array that's associated with this job. This parameter is returned for array job
     * children.
     * </p>
     * 
     * @return The job index within the array that's associated with this job. This parameter is returned for array job
     *         children.
     */
    public final Integer index() {
        return index;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusSummary() ? statusSummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayPropertiesDetail)) {
            return false;
        }
        ArrayPropertiesDetail other = (ArrayPropertiesDetail) obj;
        return hasStatusSummary() == other.hasStatusSummary() && Objects.equals(statusSummary(), other.statusSummary())
                && Objects.equals(size(), other.size()) && Objects.equals(index(), other.index());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArrayPropertiesDetail").add("StatusSummary", hasStatusSummary() ? statusSummary() : null)
                .add("Size", size()).add("Index", index()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statusSummary":
            return Optional.ofNullable(clazz.cast(statusSummary()));
        case "size":
            return Optional.ofNullable(clazz.cast(size()));
        case "index":
            return Optional.ofNullable(clazz.cast(index()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("statusSummary", STATUS_SUMMARY_FIELD);
        map.put("size", SIZE_FIELD);
        map.put("index", INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArrayPropertiesDetail, T> g) {
        return obj -> g.apply((ArrayPropertiesDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArrayPropertiesDetail> {
        /**
         * <p>
         * A summary of the number of array job children in each available job status. This parameter is returned for
         * parent array jobs.
         * </p>
         * 
         * @param statusSummary
         *        A summary of the number of array job children in each available job status. This parameter is returned
         *        for parent array jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummary(Map<String, Integer> statusSummary);

        /**
         * <p>
         * The size of the array job. This parameter is returned for parent array jobs.
         * </p>
         * 
         * @param size
         *        The size of the array job. This parameter is returned for parent array jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The job index within the array that's associated with this job. This parameter is returned for array job
         * children.
         * </p>
         * 
         * @param index
         *        The job index within the array that's associated with this job. This parameter is returned for array
         *        job children.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Integer> statusSummary = DefaultSdkAutoConstructMap.getInstance();

        private Integer size;

        private Integer index;

        private BuilderImpl() {
        }

        private BuilderImpl(ArrayPropertiesDetail model) {
            statusSummary(model.statusSummary);
            size(model.size);
            index(model.index);
        }

        public final Map<String, Integer> getStatusSummary() {
            if (statusSummary instanceof SdkAutoConstructMap) {
                return null;
            }
            return statusSummary;
        }

        public final void setStatusSummary(Map<String, Integer> statusSummary) {
            this.statusSummary = ArrayJobStatusSummaryCopier.copy(statusSummary);
        }

        @Override
        public final Builder statusSummary(Map<String, Integer> statusSummary) {
            this.statusSummary = ArrayJobStatusSummaryCopier.copy(statusSummary);
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final Integer getIndex() {
            return index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        @Override
        public ArrayPropertiesDetail build() {
            return new ArrayPropertiesDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
