/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConsumableResourceRequest extends BatchRequest implements
        ToCopyableBuilder<UpdateConsumableResourceRequest.Builder, UpdateConsumableResourceRequest> {
    private static final SdkField<String> CONSUMABLE_RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("consumableResource").getter(getter(UpdateConsumableResourceRequest::consumableResource))
            .setter(setter(Builder::consumableResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResource").build())
            .build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operation").getter(getter(UpdateConsumableResourceRequest::operation))
            .setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final SdkField<Long> QUANTITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("quantity")
            .getter(getter(UpdateConsumableResourceRequest::quantity)).setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantity").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateConsumableResourceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMABLE_RESOURCE_FIELD,
            OPERATION_FIELD, QUANTITY_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String consumableResource;

    private final String operation;

    private final Long quantity;

    private final String clientToken;

    private UpdateConsumableResourceRequest(BuilderImpl builder) {
        super(builder);
        this.consumableResource = builder.consumableResource;
        this.operation = builder.operation;
        this.quantity = builder.quantity;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name or ARN of the consumable resource to be updated.
     * </p>
     * 
     * @return The name or ARN of the consumable resource to be updated.
     */
    public final String consumableResource() {
        return consumableResource;
    }

    /**
     * <p>
     * Indicates how the quantity of the consumable resource will be updated. Must be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SET</code>
     * </p>
     * <p>
     * Sets the quantity of the resource to the value specified by the <code>quantity</code> parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADD</code>
     * </p>
     * <p>
     * Increases the quantity of the resource by the value specified by the <code>quantity</code> parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVE</code>
     * </p>
     * <p>
     * Reduces the quantity of the resource by the value specified by the <code>quantity</code> parameter.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates how the quantity of the consumable resource will be updated. Must be one of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SET</code>
     *         </p>
     *         <p>
     *         Sets the quantity of the resource to the value specified by the <code>quantity</code> parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADD</code>
     *         </p>
     *         <p>
     *         Increases the quantity of the resource by the value specified by the <code>quantity</code> parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVE</code>
     *         </p>
     *         <p>
     *         Reduces the quantity of the resource by the value specified by the <code>quantity</code> parameter.
     *         </p>
     *         </li>
     */
    public final String operation() {
        return operation;
    }

    /**
     * <p>
     * The change in the total quantity of the consumable resource. The <code>operation</code> parameter determines
     * whether the value specified here will be the new total quantity, or the amount by which the total quantity will
     * be increased or reduced. Must be a non-negative value.
     * </p>
     * 
     * @return The change in the total quantity of the consumable resource. The <code>operation</code> parameter
     *         determines whether the value specified here will be the new total quantity, or the amount by which the
     *         total quantity will be increased or reduced. Must be a non-negative value.
     */
    public final Long quantity() {
        return quantity;
    }

    /**
     * <p>
     * If this parameter is specified and two update requests with identical payloads and <code>clientToken</code>s are
     * received, these requests are considered the same request and the second request is rejected. A
     * <code>clientToken</code> is valid for 8 hours or until one hour after the consumable resource is deleted,
     * whichever is less.
     * </p>
     * 
     * @return If this parameter is specified and two update requests with identical payloads and
     *         <code>clientToken</code>s are received, these requests are considered the same request and the second
     *         request is rejected. A <code>clientToken</code> is valid for 8 hours or until one hour after the
     *         consumable resource is deleted, whichever is less.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(consumableResource());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConsumableResourceRequest)) {
            return false;
        }
        UpdateConsumableResourceRequest other = (UpdateConsumableResourceRequest) obj;
        return Objects.equals(consumableResource(), other.consumableResource()) && Objects.equals(operation(), other.operation())
                && Objects.equals(quantity(), other.quantity()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConsumableResourceRequest").add("ConsumableResource", consumableResource())
                .add("Operation", operation()).add("Quantity", quantity()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "consumableResource":
            return Optional.ofNullable(clazz.cast(consumableResource()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consumableResource", CONSUMABLE_RESOURCE_FIELD);
        map.put("operation", OPERATION_FIELD);
        map.put("quantity", QUANTITY_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConsumableResourceRequest, T> g) {
        return obj -> g.apply((UpdateConsumableResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConsumableResourceRequest> {
        /**
         * <p>
         * The name or ARN of the consumable resource to be updated.
         * </p>
         * 
         * @param consumableResource
         *        The name or ARN of the consumable resource to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResource(String consumableResource);

        /**
         * <p>
         * Indicates how the quantity of the consumable resource will be updated. Must be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SET</code>
         * </p>
         * <p>
         * Sets the quantity of the resource to the value specified by the <code>quantity</code> parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADD</code>
         * </p>
         * <p>
         * Increases the quantity of the resource by the value specified by the <code>quantity</code> parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVE</code>
         * </p>
         * <p>
         * Reduces the quantity of the resource by the value specified by the <code>quantity</code> parameter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operation
         *        Indicates how the quantity of the consumable resource will be updated. Must be one of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SET</code>
         *        </p>
         *        <p>
         *        Sets the quantity of the resource to the value specified by the <code>quantity</code> parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADD</code>
         *        </p>
         *        <p>
         *        Increases the quantity of the resource by the value specified by the <code>quantity</code> parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVE</code>
         *        </p>
         *        <p>
         *        Reduces the quantity of the resource by the value specified by the <code>quantity</code> parameter.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The change in the total quantity of the consumable resource. The <code>operation</code> parameter determines
         * whether the value specified here will be the new total quantity, or the amount by which the total quantity
         * will be increased or reduced. Must be a non-negative value.
         * </p>
         * 
         * @param quantity
         *        The change in the total quantity of the consumable resource. The <code>operation</code> parameter
         *        determines whether the value specified here will be the new total quantity, or the amount by which the
         *        total quantity will be increased or reduced. Must be a non-negative value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Long quantity);

        /**
         * <p>
         * If this parameter is specified and two update requests with identical payloads and <code>clientToken</code>s
         * are received, these requests are considered the same request and the second request is rejected. A
         * <code>clientToken</code> is valid for 8 hours or until one hour after the consumable resource is deleted,
         * whichever is less.
         * </p>
         * 
         * @param clientToken
         *        If this parameter is specified and two update requests with identical payloads and
         *        <code>clientToken</code>s are received, these requests are considered the same request and the second
         *        request is rejected. A <code>clientToken</code> is valid for 8 hours or until one hour after the
         *        consumable resource is deleted, whichever is less.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String consumableResource;

        private String operation;

        private Long quantity;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConsumableResourceRequest model) {
            super(model);
            consumableResource(model.consumableResource);
            operation(model.operation);
            quantity(model.quantity);
            clientToken(model.clientToken);
        }

        public final String getConsumableResource() {
            return consumableResource;
        }

        public final void setConsumableResource(String consumableResource) {
            this.consumableResource = consumableResource;
        }

        @Override
        public final Builder consumableResource(String consumableResource) {
            this.consumableResource = consumableResource;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final Long getQuantity() {
            return quantity;
        }

        public final void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Long quantity) {
            this.quantity = quantity;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConsumableResourceRequest build() {
            return new UpdateConsumableResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
