/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConsumableResourceResponse extends BatchResponse implements
        ToCopyableBuilder<DescribeConsumableResourceResponse.Builder, DescribeConsumableResourceResponse> {
    private static final SdkField<String> CONSUMABLE_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("consumableResourceName").getter(getter(DescribeConsumableResourceResponse::consumableResourceName))
            .setter(setter(Builder::consumableResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResourceName").build())
            .build();

    private static final SdkField<String> CONSUMABLE_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("consumableResourceArn").getter(getter(DescribeConsumableResourceResponse::consumableResourceArn))
            .setter(setter(Builder::consumableResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResourceArn").build())
            .build();

    private static final SdkField<Long> TOTAL_QUANTITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalQuantity").getter(getter(DescribeConsumableResourceResponse::totalQuantity))
            .setter(setter(Builder::totalQuantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalQuantity").build()).build();

    private static final SdkField<Long> IN_USE_QUANTITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("inUseQuantity").getter(getter(DescribeConsumableResourceResponse::inUseQuantity))
            .setter(setter(Builder::inUseQuantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inUseQuantity").build()).build();

    private static final SdkField<Long> AVAILABLE_QUANTITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("availableQuantity").getter(getter(DescribeConsumableResourceResponse::availableQuantity))
            .setter(setter(Builder::availableQuantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableQuantity").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(DescribeConsumableResourceResponse::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("createdAt")
            .getter(getter(DescribeConsumableResourceResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeConsumableResourceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONSUMABLE_RESOURCE_NAME_FIELD, CONSUMABLE_RESOURCE_ARN_FIELD, TOTAL_QUANTITY_FIELD, IN_USE_QUANTITY_FIELD,
            AVAILABLE_QUANTITY_FIELD, RESOURCE_TYPE_FIELD, CREATED_AT_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String consumableResourceName;

    private final String consumableResourceArn;

    private final Long totalQuantity;

    private final Long inUseQuantity;

    private final Long availableQuantity;

    private final String resourceType;

    private final Long createdAt;

    private final Map<String, String> tags;

    private DescribeConsumableResourceResponse(BuilderImpl builder) {
        super(builder);
        this.consumableResourceName = builder.consumableResourceName;
        this.consumableResourceArn = builder.consumableResourceArn;
        this.totalQuantity = builder.totalQuantity;
        this.inUseQuantity = builder.inUseQuantity;
        this.availableQuantity = builder.availableQuantity;
        this.resourceType = builder.resourceType;
        this.createdAt = builder.createdAt;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the consumable resource.
     * </p>
     * 
     * @return The name of the consumable resource.
     */
    public final String consumableResourceName() {
        return consumableResourceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the consumable resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the consumable resource.
     */
    public final String consumableResourceArn() {
        return consumableResourceArn;
    }

    /**
     * <p>
     * The total amount of the consumable resource that is available.
     * </p>
     * 
     * @return The total amount of the consumable resource that is available.
     */
    public final Long totalQuantity() {
        return totalQuantity;
    }

    /**
     * <p>
     * The amount of the consumable resource that is currently in use.
     * </p>
     * 
     * @return The amount of the consumable resource that is currently in use.
     */
    public final Long inUseQuantity() {
        return inUseQuantity;
    }

    /**
     * <p>
     * The amount of the consumable resource that is currently available to use.
     * </p>
     * 
     * @return The amount of the consumable resource that is currently available to use.
     */
    public final Long availableQuantity() {
        return availableQuantity;
    }

    /**
     * <p>
     * Indicates whether the resource is available to be re-used after a job completes. Can be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLENISHABLE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_REPLENISHABLE</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether the resource is available to be re-used after a job completes. Can be one of: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLENISHABLE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_REPLENISHABLE</code>
     *         </p>
     *         </li>
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the consumable resource was created.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the consumable resource was created.
     */
    public final Long createdAt() {
        return createdAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that you apply to the consumable resource to help you categorize and organize your resources. Each tag
     * consists of a key and an optional value. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that you apply to the consumable resource to help you categorize and organize your resources.
     *         Each tag consists of a key and an optional value. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch
     *         resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(consumableResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(consumableResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(totalQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(inUseQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(availableQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConsumableResourceResponse)) {
            return false;
        }
        DescribeConsumableResourceResponse other = (DescribeConsumableResourceResponse) obj;
        return Objects.equals(consumableResourceName(), other.consumableResourceName())
                && Objects.equals(consumableResourceArn(), other.consumableResourceArn())
                && Objects.equals(totalQuantity(), other.totalQuantity())
                && Objects.equals(inUseQuantity(), other.inUseQuantity())
                && Objects.equals(availableQuantity(), other.availableQuantity())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(createdAt(), other.createdAt())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConsumableResourceResponse").add("ConsumableResourceName", consumableResourceName())
                .add("ConsumableResourceArn", consumableResourceArn()).add("TotalQuantity", totalQuantity())
                .add("InUseQuantity", inUseQuantity()).add("AvailableQuantity", availableQuantity())
                .add("ResourceType", resourceType()).add("CreatedAt", createdAt()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "consumableResourceName":
            return Optional.ofNullable(clazz.cast(consumableResourceName()));
        case "consumableResourceArn":
            return Optional.ofNullable(clazz.cast(consumableResourceArn()));
        case "totalQuantity":
            return Optional.ofNullable(clazz.cast(totalQuantity()));
        case "inUseQuantity":
            return Optional.ofNullable(clazz.cast(inUseQuantity()));
        case "availableQuantity":
            return Optional.ofNullable(clazz.cast(availableQuantity()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consumableResourceName", CONSUMABLE_RESOURCE_NAME_FIELD);
        map.put("consumableResourceArn", CONSUMABLE_RESOURCE_ARN_FIELD);
        map.put("totalQuantity", TOTAL_QUANTITY_FIELD);
        map.put("inUseQuantity", IN_USE_QUANTITY_FIELD);
        map.put("availableQuantity", AVAILABLE_QUANTITY_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConsumableResourceResponse, T> g) {
        return obj -> g.apply((DescribeConsumableResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConsumableResourceResponse> {
        /**
         * <p>
         * The name of the consumable resource.
         * </p>
         * 
         * @param consumableResourceName
         *        The name of the consumable resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResourceName(String consumableResourceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the consumable resource.
         * </p>
         * 
         * @param consumableResourceArn
         *        The Amazon Resource Name (ARN) of the consumable resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResourceArn(String consumableResourceArn);

        /**
         * <p>
         * The total amount of the consumable resource that is available.
         * </p>
         * 
         * @param totalQuantity
         *        The total amount of the consumable resource that is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalQuantity(Long totalQuantity);

        /**
         * <p>
         * The amount of the consumable resource that is currently in use.
         * </p>
         * 
         * @param inUseQuantity
         *        The amount of the consumable resource that is currently in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inUseQuantity(Long inUseQuantity);

        /**
         * <p>
         * The amount of the consumable resource that is currently available to use.
         * </p>
         * 
         * @param availableQuantity
         *        The amount of the consumable resource that is currently available to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableQuantity(Long availableQuantity);

        /**
         * <p>
         * Indicates whether the resource is available to be re-used after a job completes. Can be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLENISHABLE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_REPLENISHABLE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        Indicates whether the resource is available to be re-used after a job completes. Can be one of: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLENISHABLE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_REPLENISHABLE</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the consumable resource was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp (in milliseconds) for when the consumable resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Long createdAt);

        /**
         * <p>
         * The tags that you apply to the consumable resource to help you categorize and organize your resources. Each
         * tag consists of a key and an optional value. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch resources</a>.
         * </p>
         * 
         * @param tags
         *        The tags that you apply to the consumable resource to help you categorize and organize your resources.
         *        Each tag consists of a key and an optional value. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private String consumableResourceName;

        private String consumableResourceArn;

        private Long totalQuantity;

        private Long inUseQuantity;

        private Long availableQuantity;

        private String resourceType;

        private Long createdAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConsumableResourceResponse model) {
            super(model);
            consumableResourceName(model.consumableResourceName);
            consumableResourceArn(model.consumableResourceArn);
            totalQuantity(model.totalQuantity);
            inUseQuantity(model.inUseQuantity);
            availableQuantity(model.availableQuantity);
            resourceType(model.resourceType);
            createdAt(model.createdAt);
            tags(model.tags);
        }

        public final String getConsumableResourceName() {
            return consumableResourceName;
        }

        public final void setConsumableResourceName(String consumableResourceName) {
            this.consumableResourceName = consumableResourceName;
        }

        @Override
        public final Builder consumableResourceName(String consumableResourceName) {
            this.consumableResourceName = consumableResourceName;
            return this;
        }

        public final String getConsumableResourceArn() {
            return consumableResourceArn;
        }

        public final void setConsumableResourceArn(String consumableResourceArn) {
            this.consumableResourceArn = consumableResourceArn;
        }

        @Override
        public final Builder consumableResourceArn(String consumableResourceArn) {
            this.consumableResourceArn = consumableResourceArn;
            return this;
        }

        public final Long getTotalQuantity() {
            return totalQuantity;
        }

        public final void setTotalQuantity(Long totalQuantity) {
            this.totalQuantity = totalQuantity;
        }

        @Override
        public final Builder totalQuantity(Long totalQuantity) {
            this.totalQuantity = totalQuantity;
            return this;
        }

        public final Long getInUseQuantity() {
            return inUseQuantity;
        }

        public final void setInUseQuantity(Long inUseQuantity) {
            this.inUseQuantity = inUseQuantity;
        }

        @Override
        public final Builder inUseQuantity(Long inUseQuantity) {
            this.inUseQuantity = inUseQuantity;
            return this;
        }

        public final Long getAvailableQuantity() {
            return availableQuantity;
        }

        public final void setAvailableQuantity(Long availableQuantity) {
            this.availableQuantity = availableQuantity;
        }

        @Override
        public final Builder availableQuantity(Long availableQuantity) {
            this.availableQuantity = availableQuantity;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Long getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeConsumableResourceResponse build() {
            return new DescribeConsumableResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
