/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubmitServiceJobRequest extends BatchRequest implements
        ToCopyableBuilder<SubmitServiceJobRequest.Builder, SubmitServiceJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(SubmitServiceJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobQueue").getter(getter(SubmitServiceJobRequest::jobQueue)).setter(setter(Builder::jobQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()).build();

    private static final SdkField<ServiceJobRetryStrategy> RETRY_STRATEGY_FIELD = SdkField
            .<ServiceJobRetryStrategy> builder(MarshallingType.SDK_POJO).memberName("retryStrategy")
            .getter(getter(SubmitServiceJobRequest::retryStrategy)).setter(setter(Builder::retryStrategy))
            .constructor(ServiceJobRetryStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStrategy").build()).build();

    private static final SdkField<Integer> SCHEDULING_PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("schedulingPriority").getter(getter(SubmitServiceJobRequest::schedulingPriority))
            .setter(setter(Builder::schedulingPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingPriority").build())
            .build();

    private static final SdkField<String> SERVICE_REQUEST_PAYLOAD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRequestPayload").getter(getter(SubmitServiceJobRequest::serviceRequestPayload))
            .setter(setter(Builder::serviceRequestPayload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRequestPayload").build())
            .build();

    private static final SdkField<String> SERVICE_JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceJobType").getter(getter(SubmitServiceJobRequest::serviceJobTypeAsString))
            .setter(setter(Builder::serviceJobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceJobType").build()).build();

    private static final SdkField<String> SHARE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shareIdentifier").getter(getter(SubmitServiceJobRequest::shareIdentifier))
            .setter(setter(Builder::shareIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareIdentifier").build()).build();

    private static final SdkField<ServiceJobTimeout> TIMEOUT_CONFIG_FIELD = SdkField
            .<ServiceJobTimeout> builder(MarshallingType.SDK_POJO).memberName("timeoutConfig")
            .getter(getter(SubmitServiceJobRequest::timeoutConfig)).setter(setter(Builder::timeoutConfig))
            .constructor(ServiceJobTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SubmitServiceJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(SubmitServiceJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            JOB_QUEUE_FIELD, RETRY_STRATEGY_FIELD, SCHEDULING_PRIORITY_FIELD, SERVICE_REQUEST_PAYLOAD_FIELD,
            SERVICE_JOB_TYPE_FIELD, SHARE_IDENTIFIER_FIELD, TIMEOUT_CONFIG_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobName;

    private final String jobQueue;

    private final ServiceJobRetryStrategy retryStrategy;

    private final Integer schedulingPriority;

    private final String serviceRequestPayload;

    private final String serviceJobType;

    private final String shareIdentifier;

    private final ServiceJobTimeout timeoutConfig;

    private final Map<String, String> tags;

    private final String clientToken;

    private SubmitServiceJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobQueue = builder.jobQueue;
        this.retryStrategy = builder.retryStrategy;
        this.schedulingPriority = builder.schedulingPriority;
        this.serviceRequestPayload = builder.serviceRequestPayload;
        this.serviceJobType = builder.serviceJobType;
        this.shareIdentifier = builder.shareIdentifier;
        this.timeoutConfig = builder.timeoutConfig;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the service job. It can be up to 128 characters long. It can contain uppercase and lowercase letters,
     * numbers, hyphens (-), and underscores (_).
     * </p>
     * 
     * @return The name of the service job. It can be up to 128 characters long. It can contain uppercase and lowercase
     *         letters, numbers, hyphens (-), and underscores (_).
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The job queue into which the service job is submitted. You can specify either the name or the ARN of the queue.
     * The job queue must have the type <code>SAGEMAKER_TRAINING</code>.
     * </p>
     * 
     * @return The job queue into which the service job is submitted. You can specify either the name or the ARN of the
     *         queue. The job queue must have the type <code>SAGEMAKER_TRAINING</code>.
     */
    public final String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * The retry strategy to use for failed service jobs that are submitted with this service job request.
     * </p>
     * 
     * @return The retry strategy to use for failed service jobs that are submitted with this service job request.
     */
    public final ServiceJobRetryStrategy retryStrategy() {
        return retryStrategy;
    }

    /**
     * <p>
     * The scheduling priority of the service job. Valid values are integers between 0 and 9999.
     * </p>
     * 
     * @return The scheduling priority of the service job. Valid values are integers between 0 and 9999.
     */
    public final Integer schedulingPriority() {
        return schedulingPriority;
    }

    /**
     * <p>
     * The request, in JSON, for the service that the SubmitServiceJob operation is queueing.
     * </p>
     * 
     * @return The request, in JSON, for the service that the SubmitServiceJob operation is queueing.
     */
    public final String serviceRequestPayload() {
        return serviceRequestPayload;
    }

    /**
     * <p>
     * The type of service job. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceJobType}
     * will return {@link ServiceJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceJobTypeAsString}.
     * </p>
     * 
     * @return The type of service job. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
     * @see ServiceJobType
     */
    public final ServiceJobType serviceJobType() {
        return ServiceJobType.fromValue(serviceJobType);
    }

    /**
     * <p>
     * The type of service job. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceJobType}
     * will return {@link ServiceJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceJobTypeAsString}.
     * </p>
     * 
     * @return The type of service job. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
     * @see ServiceJobType
     */
    public final String serviceJobTypeAsString() {
        return serviceJobType;
    }

    /**
     * <p>
     * The share identifier for the service job. Don't specify this parameter if the job queue doesn't have a fair-
     * share scheduling policy. If the job queue has a fair-share scheduling policy, then this parameter must be
     * specified.
     * </p>
     * 
     * @return The share identifier for the service job. Don't specify this parameter if the job queue doesn't have a
     *         fair- share scheduling policy. If the job queue has a fair-share scheduling policy, then this parameter
     *         must be specified.
     */
    public final String shareIdentifier() {
        return shareIdentifier;
    }

    /**
     * <p>
     * The timeout configuration for the service job. If none is specified, Batch defers to the default timeout of the
     * underlying service handling the job.
     * </p>
     * 
     * @return The timeout configuration for the service job. If none is specified, Batch defers to the default timeout
     *         of the underlying service handling the job.
     */
    public final ServiceJobTimeout timeoutConfig() {
        return timeoutConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that you apply to the service job request. Each tag consists of a key and an optional value. For more
     * information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch
     * resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that you apply to the service job request. Each tag consists of a key and an optional value. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch
     *         resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique identifier for the request. This token is used to ensure idempotency of requests. If this parameter is
     * specified and two submit requests with identical payloads and <code>clientToken</code>s are received, these
     * requests are considered the same request and the second request is rejected.
     * </p>
     * 
     * @return A unique identifier for the request. This token is used to ensure idempotency of requests. If this
     *         parameter is specified and two submit requests with identical payloads and <code>clientToken</code>s are
     *         received, these requests are considered the same request and the second request is rejected.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(schedulingPriority());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRequestPayload());
        hashCode = 31 * hashCode + Objects.hashCode(serviceJobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitServiceJobRequest)) {
            return false;
        }
        SubmitServiceJobRequest other = (SubmitServiceJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobQueue(), other.jobQueue())
                && Objects.equals(retryStrategy(), other.retryStrategy())
                && Objects.equals(schedulingPriority(), other.schedulingPriority())
                && Objects.equals(serviceRequestPayload(), other.serviceRequestPayload())
                && Objects.equals(serviceJobTypeAsString(), other.serviceJobTypeAsString())
                && Objects.equals(shareIdentifier(), other.shareIdentifier())
                && Objects.equals(timeoutConfig(), other.timeoutConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubmitServiceJobRequest").add("JobName", jobName()).add("JobQueue", jobQueue())
                .add("RetryStrategy", retryStrategy()).add("SchedulingPriority", schedulingPriority())
                .add("ServiceRequestPayload", serviceRequestPayload()).add("ServiceJobType", serviceJobTypeAsString())
                .add("ShareIdentifier", shareIdentifier()).add("TimeoutConfig", timeoutConfig())
                .add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobQueue":
            return Optional.ofNullable(clazz.cast(jobQueue()));
        case "retryStrategy":
            return Optional.ofNullable(clazz.cast(retryStrategy()));
        case "schedulingPriority":
            return Optional.ofNullable(clazz.cast(schedulingPriority()));
        case "serviceRequestPayload":
            return Optional.ofNullable(clazz.cast(serviceRequestPayload()));
        case "serviceJobType":
            return Optional.ofNullable(clazz.cast(serviceJobTypeAsString()));
        case "shareIdentifier":
            return Optional.ofNullable(clazz.cast(shareIdentifier()));
        case "timeoutConfig":
            return Optional.ofNullable(clazz.cast(timeoutConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobName", JOB_NAME_FIELD);
        map.put("jobQueue", JOB_QUEUE_FIELD);
        map.put("retryStrategy", RETRY_STRATEGY_FIELD);
        map.put("schedulingPriority", SCHEDULING_PRIORITY_FIELD);
        map.put("serviceRequestPayload", SERVICE_REQUEST_PAYLOAD_FIELD);
        map.put("serviceJobType", SERVICE_JOB_TYPE_FIELD);
        map.put("shareIdentifier", SHARE_IDENTIFIER_FIELD);
        map.put("timeoutConfig", TIMEOUT_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubmitServiceJobRequest, T> g) {
        return obj -> g.apply((SubmitServiceJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, SubmitServiceJobRequest> {
        /**
         * <p>
         * The name of the service job. It can be up to 128 characters long. It can contain uppercase and lowercase
         * letters, numbers, hyphens (-), and underscores (_).
         * </p>
         * 
         * @param jobName
         *        The name of the service job. It can be up to 128 characters long. It can contain uppercase and
         *        lowercase letters, numbers, hyphens (-), and underscores (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The job queue into which the service job is submitted. You can specify either the name or the ARN of the
         * queue. The job queue must have the type <code>SAGEMAKER_TRAINING</code>.
         * </p>
         * 
         * @param jobQueue
         *        The job queue into which the service job is submitted. You can specify either the name or the ARN of
         *        the queue. The job queue must have the type <code>SAGEMAKER_TRAINING</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * The retry strategy to use for failed service jobs that are submitted with this service job request.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for failed service jobs that are submitted with this service job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(ServiceJobRetryStrategy retryStrategy);

        /**
         * <p>
         * The retry strategy to use for failed service jobs that are submitted with this service job request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceJobRetryStrategy.Builder} avoiding
         * the need to create one manually via {@link ServiceJobRetryStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceJobRetryStrategy.Builder#build()} is called immediately
         * and its result is passed to {@link #retryStrategy(ServiceJobRetryStrategy)}.
         * 
         * @param retryStrategy
         *        a consumer that will call methods on {@link ServiceJobRetryStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryStrategy(ServiceJobRetryStrategy)
         */
        default Builder retryStrategy(Consumer<ServiceJobRetryStrategy.Builder> retryStrategy) {
            return retryStrategy(ServiceJobRetryStrategy.builder().applyMutation(retryStrategy).build());
        }

        /**
         * <p>
         * The scheduling priority of the service job. Valid values are integers between 0 and 9999.
         * </p>
         * 
         * @param schedulingPriority
         *        The scheduling priority of the service job. Valid values are integers between 0 and 9999.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedulingPriority(Integer schedulingPriority);

        /**
         * <p>
         * The request, in JSON, for the service that the SubmitServiceJob operation is queueing.
         * </p>
         * 
         * @param serviceRequestPayload
         *        The request, in JSON, for the service that the SubmitServiceJob operation is queueing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRequestPayload(String serviceRequestPayload);

        /**
         * <p>
         * The type of service job. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
         * </p>
         * 
         * @param serviceJobType
         *        The type of service job. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
         * @see ServiceJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobType
         */
        Builder serviceJobType(String serviceJobType);

        /**
         * <p>
         * The type of service job. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
         * </p>
         * 
         * @param serviceJobType
         *        The type of service job. For SageMaker Training jobs, specify <code>SAGEMAKER_TRAINING</code>.
         * @see ServiceJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobType
         */
        Builder serviceJobType(ServiceJobType serviceJobType);

        /**
         * <p>
         * The share identifier for the service job. Don't specify this parameter if the job queue doesn't have a fair-
         * share scheduling policy. If the job queue has a fair-share scheduling policy, then this parameter must be
         * specified.
         * </p>
         * 
         * @param shareIdentifier
         *        The share identifier for the service job. Don't specify this parameter if the job queue doesn't have a
         *        fair- share scheduling policy. If the job queue has a fair-share scheduling policy, then this
         *        parameter must be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareIdentifier(String shareIdentifier);

        /**
         * <p>
         * The timeout configuration for the service job. If none is specified, Batch defers to the default timeout of
         * the underlying service handling the job.
         * </p>
         * 
         * @param timeoutConfig
         *        The timeout configuration for the service job. If none is specified, Batch defers to the default
         *        timeout of the underlying service handling the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutConfig(ServiceJobTimeout timeoutConfig);

        /**
         * <p>
         * The timeout configuration for the service job. If none is specified, Batch defers to the default timeout of
         * the underlying service handling the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceJobTimeout.Builder} avoiding the
         * need to create one manually via {@link ServiceJobTimeout#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceJobTimeout.Builder#build()} is called immediately and its
         * result is passed to {@link #timeoutConfig(ServiceJobTimeout)}.
         * 
         * @param timeoutConfig
         *        a consumer that will call methods on {@link ServiceJobTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutConfig(ServiceJobTimeout)
         */
        default Builder timeoutConfig(Consumer<ServiceJobTimeout.Builder> timeoutConfig) {
            return timeoutConfig(ServiceJobTimeout.builder().applyMutation(timeoutConfig).build());
        }

        /**
         * <p>
         * The tags that you apply to the service job request. Each tag consists of a key and an optional value. For
         * more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging
         * your Batch resources</a>.
         * </p>
         * 
         * @param tags
         *        The tags that you apply to the service job request. Each tag consists of a key and an optional value.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A unique identifier for the request. This token is used to ensure idempotency of requests. If this parameter
         * is specified and two submit requests with identical payloads and <code>clientToken</code>s are received,
         * these requests are considered the same request and the second request is rejected.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for the request. This token is used to ensure idempotency of requests. If this
         *        parameter is specified and two submit requests with identical payloads and <code>clientToken</code>s
         *        are received, these requests are considered the same request and the second request is rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobName;

        private String jobQueue;

        private ServiceJobRetryStrategy retryStrategy;

        private Integer schedulingPriority;

        private String serviceRequestPayload;

        private String serviceJobType;

        private String shareIdentifier;

        private ServiceJobTimeout timeoutConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitServiceJobRequest model) {
            super(model);
            jobName(model.jobName);
            jobQueue(model.jobQueue);
            retryStrategy(model.retryStrategy);
            schedulingPriority(model.schedulingPriority);
            serviceRequestPayload(model.serviceRequestPayload);
            serviceJobType(model.serviceJobType);
            shareIdentifier(model.shareIdentifier);
            timeoutConfig(model.timeoutConfig);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final ServiceJobRetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(ServiceJobRetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public final Builder retryStrategy(ServiceJobRetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final Integer getSchedulingPriority() {
            return schedulingPriority;
        }

        public final void setSchedulingPriority(Integer schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
        }

        @Override
        public final Builder schedulingPriority(Integer schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
            return this;
        }

        public final String getServiceRequestPayload() {
            return serviceRequestPayload;
        }

        public final void setServiceRequestPayload(String serviceRequestPayload) {
            this.serviceRequestPayload = serviceRequestPayload;
        }

        @Override
        public final Builder serviceRequestPayload(String serviceRequestPayload) {
            this.serviceRequestPayload = serviceRequestPayload;
            return this;
        }

        public final String getServiceJobType() {
            return serviceJobType;
        }

        public final void setServiceJobType(String serviceJobType) {
            this.serviceJobType = serviceJobType;
        }

        @Override
        public final Builder serviceJobType(String serviceJobType) {
            this.serviceJobType = serviceJobType;
            return this;
        }

        @Override
        public final Builder serviceJobType(ServiceJobType serviceJobType) {
            this.serviceJobType(serviceJobType == null ? null : serviceJobType.toString());
            return this;
        }

        public final String getShareIdentifier() {
            return shareIdentifier;
        }

        public final void setShareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
        }

        @Override
        public final Builder shareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        public final ServiceJobTimeout.Builder getTimeoutConfig() {
            return timeoutConfig != null ? timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(ServiceJobTimeout.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(ServiceJobTimeout timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitServiceJobRequest build() {
            return new SubmitServiceJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
