/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShareAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShareAttributes> {
    private static final SdkField<String> SHARE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareIdentifier").getter(ShareAttributes.getter(ShareAttributes::shareIdentifier)).setter(ShareAttributes.setter(Builder::shareIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareIdentifier").build()}).build();
    private static final SdkField<Float> WEIGHT_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("weightFactor").getter(ShareAttributes.getter(ShareAttributes::weightFactor)).setter(ShareAttributes.setter(Builder::weightFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weightFactor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_IDENTIFIER_FIELD, WEIGHT_FACTOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ShareAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String shareIdentifier;
    private final Float weightFactor;

    private ShareAttributes(BuilderImpl builder) {
        this.shareIdentifier = builder.shareIdentifier;
        this.weightFactor = builder.weightFactor;
    }

    public final String shareIdentifier() {
        return this.shareIdentifier;
    }

    public final Float weightFactor() {
        return this.weightFactor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shareIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightFactor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareAttributes)) {
            return false;
        }
        ShareAttributes other = (ShareAttributes)obj;
        return Objects.equals(this.shareIdentifier(), other.shareIdentifier()) && Objects.equals(this.weightFactor(), other.weightFactor());
    }

    public final String toString() {
        return ToString.builder((String)"ShareAttributes").add("ShareIdentifier", (Object)this.shareIdentifier()).add("WeightFactor", (Object)this.weightFactor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "shareIdentifier": {
                return Optional.ofNullable(clazz.cast(this.shareIdentifier()));
            }
            case "weightFactor": {
                return Optional.ofNullable(clazz.cast(this.weightFactor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shareIdentifier", SHARE_IDENTIFIER_FIELD);
        map.put("weightFactor", WEIGHT_FACTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShareAttributes, T> g) {
        return obj -> g.apply((ShareAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shareIdentifier;
        private Float weightFactor;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareAttributes model) {
            this.shareIdentifier(model.shareIdentifier);
            this.weightFactor(model.weightFactor);
        }

        public final String getShareIdentifier() {
            return this.shareIdentifier;
        }

        public final void setShareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
        }

        @Override
        public final Builder shareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        public final Float getWeightFactor() {
            return this.weightFactor;
        }

        public final void setWeightFactor(Float weightFactor) {
            this.weightFactor = weightFactor;
        }

        @Override
        public final Builder weightFactor(Float weightFactor) {
            this.weightFactor = weightFactor;
            return this;
        }

        public ShareAttributes build() {
            return new ShareAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShareAttributes> {
        public Builder shareIdentifier(String var1);

        public Builder weightFactor(Float var1);
    }
}

