/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.ConsumableResourceSummary;
import software.amazon.awssdk.services.batch.model.ConsumableResourceSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConsumableResourcesResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, ListConsumableResourcesResponse> {
    private static final SdkField<List<ConsumableResourceSummary>> CONSUMABLE_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("consumableResources").getter(ListConsumableResourcesResponse.getter(ListConsumableResourcesResponse::consumableResources)).setter(ListConsumableResourcesResponse.setter(Builder::consumableResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConsumableResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListConsumableResourcesResponse.getter(ListConsumableResourcesResponse::nextToken)).setter(ListConsumableResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMABLE_RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConsumableResourcesResponse.memberNameToFieldInitializer();
    private final List<ConsumableResourceSummary> consumableResources;
    private final String nextToken;

    private ListConsumableResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.consumableResources = builder.consumableResources;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConsumableResources() {
        return this.consumableResources != null && !(this.consumableResources instanceof SdkAutoConstructList);
    }

    public final List<ConsumableResourceSummary> consumableResources() {
        return this.consumableResources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumableResources() ? this.consumableResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConsumableResourcesResponse)) {
            return false;
        }
        ListConsumableResourcesResponse other = (ListConsumableResourcesResponse)((Object)obj);
        return this.hasConsumableResources() == other.hasConsumableResources() && Objects.equals(this.consumableResources(), other.consumableResources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConsumableResourcesResponse").add("ConsumableResources", this.hasConsumableResources() ? this.consumableResources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "consumableResources": {
                return Optional.ofNullable(clazz.cast(this.consumableResources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("consumableResources", CONSUMABLE_RESOURCES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConsumableResourcesResponse, T> g) {
        return obj -> g.apply((ListConsumableResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private List<ConsumableResourceSummary> consumableResources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConsumableResourcesResponse model) {
            super(model);
            this.consumableResources(model.consumableResources);
            this.nextToken(model.nextToken);
        }

        public final List<ConsumableResourceSummary.Builder> getConsumableResources() {
            List<ConsumableResourceSummary.Builder> result = ConsumableResourceSummaryListCopier.copyToBuilder(this.consumableResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConsumableResources(Collection<ConsumableResourceSummary.BuilderImpl> consumableResources) {
            this.consumableResources = ConsumableResourceSummaryListCopier.copyFromBuilder(consumableResources);
        }

        @Override
        public final Builder consumableResources(Collection<ConsumableResourceSummary> consumableResources) {
            this.consumableResources = ConsumableResourceSummaryListCopier.copy(consumableResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumableResources(ConsumableResourceSummary ... consumableResources) {
            this.consumableResources(Arrays.asList(consumableResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumableResources(Consumer<ConsumableResourceSummary.Builder> ... consumableResources) {
            this.consumableResources(Stream.of(consumableResources).map(c -> (ConsumableResourceSummary)((ConsumableResourceSummary.Builder)ConsumableResourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConsumableResourcesResponse build() {
            return new ListConsumableResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConsumableResourcesResponse> {
        public Builder consumableResources(Collection<ConsumableResourceSummary> var1);

        public Builder consumableResources(ConsumableResourceSummary ... var1);

        public Builder consumableResources(Consumer<ConsumableResourceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

