/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.TagrisTagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConsumableResourceResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, DescribeConsumableResourceResponse> {
    private static final SdkField<String> CONSUMABLE_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("consumableResourceName").getter(DescribeConsumableResourceResponse.getter(DescribeConsumableResourceResponse::consumableResourceName)).setter(DescribeConsumableResourceResponse.setter(Builder::consumableResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResourceName").build()}).build();
    private static final SdkField<String> CONSUMABLE_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("consumableResourceArn").getter(DescribeConsumableResourceResponse.getter(DescribeConsumableResourceResponse::consumableResourceArn)).setter(DescribeConsumableResourceResponse.setter(Builder::consumableResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResourceArn").build()}).build();
    private static final SdkField<Long> TOTAL_QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalQuantity").getter(DescribeConsumableResourceResponse.getter(DescribeConsumableResourceResponse::totalQuantity)).setter(DescribeConsumableResourceResponse.setter(Builder::totalQuantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalQuantity").build()}).build();
    private static final SdkField<Long> IN_USE_QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("inUseQuantity").getter(DescribeConsumableResourceResponse.getter(DescribeConsumableResourceResponse::inUseQuantity)).setter(DescribeConsumableResourceResponse.setter(Builder::inUseQuantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inUseQuantity").build()}).build();
    private static final SdkField<Long> AVAILABLE_QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("availableQuantity").getter(DescribeConsumableResourceResponse.getter(DescribeConsumableResourceResponse::availableQuantity)).setter(DescribeConsumableResourceResponse.setter(Builder::availableQuantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableQuantity").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(DescribeConsumableResourceResponse.getter(DescribeConsumableResourceResponse::resourceType)).setter(DescribeConsumableResourceResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createdAt").getter(DescribeConsumableResourceResponse.getter(DescribeConsumableResourceResponse::createdAt)).setter(DescribeConsumableResourceResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeConsumableResourceResponse.getter(DescribeConsumableResourceResponse::tags)).setter(DescribeConsumableResourceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMABLE_RESOURCE_NAME_FIELD, CONSUMABLE_RESOURCE_ARN_FIELD, TOTAL_QUANTITY_FIELD, IN_USE_QUANTITY_FIELD, AVAILABLE_QUANTITY_FIELD, RESOURCE_TYPE_FIELD, CREATED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConsumableResourceResponse.memberNameToFieldInitializer();
    private final String consumableResourceName;
    private final String consumableResourceArn;
    private final Long totalQuantity;
    private final Long inUseQuantity;
    private final Long availableQuantity;
    private final String resourceType;
    private final Long createdAt;
    private final Map<String, String> tags;

    private DescribeConsumableResourceResponse(BuilderImpl builder) {
        super(builder);
        this.consumableResourceName = builder.consumableResourceName;
        this.consumableResourceArn = builder.consumableResourceArn;
        this.totalQuantity = builder.totalQuantity;
        this.inUseQuantity = builder.inUseQuantity;
        this.availableQuantity = builder.availableQuantity;
        this.resourceType = builder.resourceType;
        this.createdAt = builder.createdAt;
        this.tags = builder.tags;
    }

    public final String consumableResourceName() {
        return this.consumableResourceName;
    }

    public final String consumableResourceArn() {
        return this.consumableResourceArn;
    }

    public final Long totalQuantity() {
        return this.totalQuantity;
    }

    public final Long inUseQuantity() {
        return this.inUseQuantity;
    }

    public final Long availableQuantity() {
        return this.availableQuantity;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Long createdAt() {
        return this.createdAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.consumableResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumableResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.inUseQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConsumableResourceResponse)) {
            return false;
        }
        DescribeConsumableResourceResponse other = (DescribeConsumableResourceResponse)((Object)obj);
        return Objects.equals(this.consumableResourceName(), other.consumableResourceName()) && Objects.equals(this.consumableResourceArn(), other.consumableResourceArn()) && Objects.equals(this.totalQuantity(), other.totalQuantity()) && Objects.equals(this.inUseQuantity(), other.inUseQuantity()) && Objects.equals(this.availableQuantity(), other.availableQuantity()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.createdAt(), other.createdAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConsumableResourceResponse").add("ConsumableResourceName", (Object)this.consumableResourceName()).add("ConsumableResourceArn", (Object)this.consumableResourceArn()).add("TotalQuantity", (Object)this.totalQuantity()).add("InUseQuantity", (Object)this.inUseQuantity()).add("AvailableQuantity", (Object)this.availableQuantity()).add("ResourceType", (Object)this.resourceType()).add("CreatedAt", (Object)this.createdAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "consumableResourceName": {
                return Optional.ofNullable(clazz.cast(this.consumableResourceName()));
            }
            case "consumableResourceArn": {
                return Optional.ofNullable(clazz.cast(this.consumableResourceArn()));
            }
            case "totalQuantity": {
                return Optional.ofNullable(clazz.cast(this.totalQuantity()));
            }
            case "inUseQuantity": {
                return Optional.ofNullable(clazz.cast(this.inUseQuantity()));
            }
            case "availableQuantity": {
                return Optional.ofNullable(clazz.cast(this.availableQuantity()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("consumableResourceName", CONSUMABLE_RESOURCE_NAME_FIELD);
        map.put("consumableResourceArn", CONSUMABLE_RESOURCE_ARN_FIELD);
        map.put("totalQuantity", TOTAL_QUANTITY_FIELD);
        map.put("inUseQuantity", IN_USE_QUANTITY_FIELD);
        map.put("availableQuantity", AVAILABLE_QUANTITY_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConsumableResourceResponse, T> g) {
        return obj -> g.apply((DescribeConsumableResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private String consumableResourceName;
        private String consumableResourceArn;
        private Long totalQuantity;
        private Long inUseQuantity;
        private Long availableQuantity;
        private String resourceType;
        private Long createdAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConsumableResourceResponse model) {
            super(model);
            this.consumableResourceName(model.consumableResourceName);
            this.consumableResourceArn(model.consumableResourceArn);
            this.totalQuantity(model.totalQuantity);
            this.inUseQuantity(model.inUseQuantity);
            this.availableQuantity(model.availableQuantity);
            this.resourceType(model.resourceType);
            this.createdAt(model.createdAt);
            this.tags(model.tags);
        }

        public final String getConsumableResourceName() {
            return this.consumableResourceName;
        }

        public final void setConsumableResourceName(String consumableResourceName) {
            this.consumableResourceName = consumableResourceName;
        }

        @Override
        public final Builder consumableResourceName(String consumableResourceName) {
            this.consumableResourceName = consumableResourceName;
            return this;
        }

        public final String getConsumableResourceArn() {
            return this.consumableResourceArn;
        }

        public final void setConsumableResourceArn(String consumableResourceArn) {
            this.consumableResourceArn = consumableResourceArn;
        }

        @Override
        public final Builder consumableResourceArn(String consumableResourceArn) {
            this.consumableResourceArn = consumableResourceArn;
            return this;
        }

        public final Long getTotalQuantity() {
            return this.totalQuantity;
        }

        public final void setTotalQuantity(Long totalQuantity) {
            this.totalQuantity = totalQuantity;
        }

        @Override
        public final Builder totalQuantity(Long totalQuantity) {
            this.totalQuantity = totalQuantity;
            return this;
        }

        public final Long getInUseQuantity() {
            return this.inUseQuantity;
        }

        public final void setInUseQuantity(Long inUseQuantity) {
            this.inUseQuantity = inUseQuantity;
        }

        @Override
        public final Builder inUseQuantity(Long inUseQuantity) {
            this.inUseQuantity = inUseQuantity;
            return this;
        }

        public final Long getAvailableQuantity() {
            return this.availableQuantity;
        }

        public final void setAvailableQuantity(Long availableQuantity) {
            this.availableQuantity = availableQuantity;
        }

        @Override
        public final Builder availableQuantity(Long availableQuantity) {
            this.availableQuantity = availableQuantity;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Long getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeConsumableResourceResponse build() {
            return new DescribeConsumableResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConsumableResourceResponse> {
        public Builder consumableResourceName(String var1);

        public Builder consumableResourceArn(String var1);

        public Builder totalQuantity(Long var1);

        public Builder inUseQuantity(Long var1);

        public Builder availableQuantity(Long var1);

        public Builder resourceType(String var1);

        public Builder createdAt(Long var1);

        public Builder tags(Map<String, String> var1);
    }
}

