/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a scheduling policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchedulingPolicyDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<SchedulingPolicyDetail.Builder, SchedulingPolicyDetail> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SchedulingPolicyDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SchedulingPolicyDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<FairsharePolicy> FAIRSHARE_POLICY_FIELD = SdkField
            .<FairsharePolicy> builder(MarshallingType.SDK_POJO).memberName("fairsharePolicy")
            .getter(getter(SchedulingPolicyDetail::fairsharePolicy)).setter(setter(Builder::fairsharePolicy))
            .constructor(FairsharePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fairsharePolicy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SchedulingPolicyDetail::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            FAIRSHARE_POLICY_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final FairsharePolicy fairsharePolicy;

    private final Map<String, String> tags;

    private SchedulingPolicyDetail(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.fairsharePolicy = builder.fairsharePolicy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the scheduling policy.
     * </p>
     * 
     * @return The name of the scheduling policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scheduling policy. An example is
     * <code>arn:<i>aws</i>:batch:<i>us-east-1</i>:<i>123456789012</i>:scheduling-policy/<i>HighPriority</i> </code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scheduling policy. An example is
     *         <code>arn:<i>aws</i>:batch:<i>us-east-1</i>:<i>123456789012</i>:scheduling-policy/<i>HighPriority</i> </code>
     *         .
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The fair share policy for the scheduling policy.
     * </p>
     * 
     * @return The fair share policy for the scheduling policy.
     */
    public final FairsharePolicy fairsharePolicy() {
        return fairsharePolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that you apply to the scheduling policy to categorize and organize your resources. Each tag consists of
     * a key and an optional value. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that you apply to the scheduling policy to categorize and organize your resources. Each tag
     *         consists of a key and an optional value. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a> in <i>Amazon Web Services General Reference</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(fairsharePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchedulingPolicyDetail)) {
            return false;
        }
        SchedulingPolicyDetail other = (SchedulingPolicyDetail) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(fairsharePolicy(), other.fairsharePolicy()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchedulingPolicyDetail").add("Name", name()).add("Arn", arn())
                .add("FairsharePolicy", fairsharePolicy()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "fairsharePolicy":
            return Optional.ofNullable(clazz.cast(fairsharePolicy()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("fairsharePolicy", FAIRSHARE_POLICY_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchedulingPolicyDetail, T> g) {
        return obj -> g.apply((SchedulingPolicyDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchedulingPolicyDetail> {
        /**
         * <p>
         * The name of the scheduling policy.
         * </p>
         * 
         * @param name
         *        The name of the scheduling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scheduling policy. An example is
         * <code>arn:<i>aws</i>:batch:<i>us-east-1</i>:<i>123456789012</i>:scheduling-policy/<i>HighPriority</i> </code>
         * .
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the scheduling policy. An example is
         *        <code>arn:<i>aws</i>:batch:<i>us-east-1</i>:<i>123456789012</i>:scheduling-policy/<i>HighPriority</i> </code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The fair share policy for the scheduling policy.
         * </p>
         * 
         * @param fairsharePolicy
         *        The fair share policy for the scheduling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fairsharePolicy(FairsharePolicy fairsharePolicy);

        /**
         * <p>
         * The fair share policy for the scheduling policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link FairsharePolicy.Builder} avoiding the
         * need to create one manually via {@link FairsharePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FairsharePolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #fairsharePolicy(FairsharePolicy)}.
         * 
         * @param fairsharePolicy
         *        a consumer that will call methods on {@link FairsharePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fairsharePolicy(FairsharePolicy)
         */
        default Builder fairsharePolicy(Consumer<FairsharePolicy.Builder> fairsharePolicy) {
            return fairsharePolicy(FairsharePolicy.builder().applyMutation(fairsharePolicy).build());
        }

        /**
         * <p>
         * The tags that you apply to the scheduling policy to categorize and organize your resources. Each tag consists
         * of a key and an optional value. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        The tags that you apply to the scheduling policy to categorize and organize your resources. Each tag
         *        consists of a key and an optional value. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private FairsharePolicy fairsharePolicy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SchedulingPolicyDetail model) {
            name(model.name);
            arn(model.arn);
            fairsharePolicy(model.fairsharePolicy);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final FairsharePolicy.Builder getFairsharePolicy() {
            return fairsharePolicy != null ? fairsharePolicy.toBuilder() : null;
        }

        public final void setFairsharePolicy(FairsharePolicy.BuilderImpl fairsharePolicy) {
            this.fairsharePolicy = fairsharePolicy != null ? fairsharePolicy.build() : null;
        }

        @Override
        public final Builder fairsharePolicy(FairsharePolicy fairsharePolicy) {
            this.fairsharePolicy = fairsharePolicy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public SchedulingPolicyDetail build() {
            return new SchedulingPolicyDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
