/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is an object that represents the properties of the node range for a multi-node parallel job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeRangeProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeRangeProperty.Builder, NodeRangeProperty> {
    private static final SdkField<String> TARGET_NODES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetNodes").getter(getter(NodeRangeProperty::targetNodes)).setter(setter(Builder::targetNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetNodes").build()).build();

    private static final SdkField<ContainerProperties> CONTAINER_FIELD = SdkField
            .<ContainerProperties> builder(MarshallingType.SDK_POJO).memberName("container")
            .getter(getter(NodeRangeProperty::container)).setter(setter(Builder::container))
            .constructor(ContainerProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()).build();

    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("instanceTypes")
            .getter(getter(NodeRangeProperty::instanceTypes))
            .setter(setter(Builder::instanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EcsProperties> ECS_PROPERTIES_FIELD = SdkField
            .<EcsProperties> builder(MarshallingType.SDK_POJO).memberName("ecsProperties")
            .getter(getter(NodeRangeProperty::ecsProperties)).setter(setter(Builder::ecsProperties))
            .constructor(EcsProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsProperties").build()).build();

    private static final SdkField<EksProperties> EKS_PROPERTIES_FIELD = SdkField
            .<EksProperties> builder(MarshallingType.SDK_POJO).memberName("eksProperties")
            .getter(getter(NodeRangeProperty::eksProperties)).setter(setter(Builder::eksProperties))
            .constructor(EksProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksProperties").build()).build();

    private static final SdkField<ConsumableResourceProperties> CONSUMABLE_RESOURCE_PROPERTIES_FIELD = SdkField
            .<ConsumableResourceProperties> builder(MarshallingType.SDK_POJO)
            .memberName("consumableResourceProperties")
            .getter(getter(NodeRangeProperty::consumableResourceProperties))
            .setter(setter(Builder::consumableResourceProperties))
            .constructor(ConsumableResourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResourceProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_NODES_FIELD,
            CONTAINER_FIELD, INSTANCE_TYPES_FIELD, ECS_PROPERTIES_FIELD, EKS_PROPERTIES_FIELD,
            CONSUMABLE_RESOURCE_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetNodes;

    private final ContainerProperties container;

    private final List<String> instanceTypes;

    private final EcsProperties ecsProperties;

    private final EksProperties eksProperties;

    private final ConsumableResourceProperties consumableResourceProperties;

    private NodeRangeProperty(BuilderImpl builder) {
        this.targetNodes = builder.targetNodes;
        this.container = builder.container;
        this.instanceTypes = builder.instanceTypes;
        this.ecsProperties = builder.ecsProperties;
        this.eksProperties = builder.eksProperties;
        this.consumableResourceProperties = builder.consumableResourceProperties;
    }

    /**
     * <p>
     * The range of nodes, using node index values. A range of <code>0:3</code> indicates nodes with index values of
     * <code>0</code> through <code>3</code>. If the starting range value is omitted (<code>:n</code>), then
     * <code>0</code> is used to start the range. If the ending range value is omitted (<code>n:</code>), then the
     * highest possible node index is used to end the range. Your accumulative node ranges must account for all nodes (
     * <code>0:n</code>). You can nest node ranges (for example, <code>0:10</code> and <code>4:5</code>). In this case,
     * the <code>4:5</code> range properties override the <code>0:10</code> properties.
     * </p>
     * 
     * @return The range of nodes, using node index values. A range of <code>0:3</code> indicates nodes with index
     *         values of <code>0</code> through <code>3</code>. If the starting range value is omitted (<code>:n</code>
     *         ), then <code>0</code> is used to start the range. If the ending range value is omitted (<code>n:</code>
     *         ), then the highest possible node index is used to end the range. Your accumulative node ranges must
     *         account for all nodes (<code>0:n</code>). You can nest node ranges (for example, <code>0:10</code> and
     *         <code>4:5</code>). In this case, the <code>4:5</code> range properties override the <code>0:10</code>
     *         properties.
     */
    public final String targetNodes() {
        return targetNodes;
    }

    /**
     * <p>
     * The container details for the node range.
     * </p>
     * 
     * @return The container details for the node range.
     */
    public final ContainerProperties container() {
        return container;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceTypes() {
        return instanceTypes != null && !(instanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance types of the underlying host infrastructure of a multi-node parallel job.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources.
     * </p>
     * <p>
     * In addition, this list object is currently limited to one element.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceTypes} method.
     * </p>
     * 
     * @return The instance types of the underlying host infrastructure of a multi-node parallel job.</p> <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources.
     *         </p>
     *         <p>
     *         In addition, this list object is currently limited to one element.
     *         </p>
     */
    public final List<String> instanceTypes() {
        return instanceTypes;
    }

    /**
     * <p>
     * This is an object that represents the properties of the node range for a multi-node parallel job.
     * </p>
     * 
     * @return This is an object that represents the properties of the node range for a multi-node parallel job.
     */
    public final EcsProperties ecsProperties() {
        return ecsProperties;
    }

    /**
     * <p>
     * This is an object that represents the properties of the node range for a multi-node parallel job.
     * </p>
     * 
     * @return This is an object that represents the properties of the node range for a multi-node parallel job.
     */
    public final EksProperties eksProperties() {
        return eksProperties;
    }

    /**
     * <p>
     * Contains a list of consumable resources required by a job.
     * </p>
     * 
     * @return Contains a list of consumable resources required by a job.
     */
    public final ConsumableResourceProperties consumableResourceProperties() {
        return consumableResourceProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetNodes());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTypes() ? instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ecsProperties());
        hashCode = 31 * hashCode + Objects.hashCode(eksProperties());
        hashCode = 31 * hashCode + Objects.hashCode(consumableResourceProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeRangeProperty)) {
            return false;
        }
        NodeRangeProperty other = (NodeRangeProperty) obj;
        return Objects.equals(targetNodes(), other.targetNodes()) && Objects.equals(container(), other.container())
                && hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(instanceTypes(), other.instanceTypes())
                && Objects.equals(ecsProperties(), other.ecsProperties())
                && Objects.equals(eksProperties(), other.eksProperties())
                && Objects.equals(consumableResourceProperties(), other.consumableResourceProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeRangeProperty").add("TargetNodes", targetNodes()).add("Container", container())
                .add("InstanceTypes", hasInstanceTypes() ? instanceTypes() : null).add("EcsProperties", ecsProperties())
                .add("EksProperties", eksProperties()).add("ConsumableResourceProperties", consumableResourceProperties())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetNodes":
            return Optional.ofNullable(clazz.cast(targetNodes()));
        case "container":
            return Optional.ofNullable(clazz.cast(container()));
        case "instanceTypes":
            return Optional.ofNullable(clazz.cast(instanceTypes()));
        case "ecsProperties":
            return Optional.ofNullable(clazz.cast(ecsProperties()));
        case "eksProperties":
            return Optional.ofNullable(clazz.cast(eksProperties()));
        case "consumableResourceProperties":
            return Optional.ofNullable(clazz.cast(consumableResourceProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetNodes", TARGET_NODES_FIELD);
        map.put("container", CONTAINER_FIELD);
        map.put("instanceTypes", INSTANCE_TYPES_FIELD);
        map.put("ecsProperties", ECS_PROPERTIES_FIELD);
        map.put("eksProperties", EKS_PROPERTIES_FIELD);
        map.put("consumableResourceProperties", CONSUMABLE_RESOURCE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeRangeProperty, T> g) {
        return obj -> g.apply((NodeRangeProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeRangeProperty> {
        /**
         * <p>
         * The range of nodes, using node index values. A range of <code>0:3</code> indicates nodes with index values of
         * <code>0</code> through <code>3</code>. If the starting range value is omitted (<code>:n</code>), then
         * <code>0</code> is used to start the range. If the ending range value is omitted (<code>n:</code>), then the
         * highest possible node index is used to end the range. Your accumulative node ranges must account for all
         * nodes (<code>0:n</code>). You can nest node ranges (for example, <code>0:10</code> and <code>4:5</code>). In
         * this case, the <code>4:5</code> range properties override the <code>0:10</code> properties.
         * </p>
         * 
         * @param targetNodes
         *        The range of nodes, using node index values. A range of <code>0:3</code> indicates nodes with index
         *        values of <code>0</code> through <code>3</code>. If the starting range value is omitted (
         *        <code>:n</code>), then <code>0</code> is used to start the range. If the ending range value is omitted
         *        (<code>n:</code>), then the highest possible node index is used to end the range. Your accumulative
         *        node ranges must account for all nodes (<code>0:n</code>). You can nest node ranges (for example,
         *        <code>0:10</code> and <code>4:5</code>). In this case, the <code>4:5</code> range properties override
         *        the <code>0:10</code> properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetNodes(String targetNodes);

        /**
         * <p>
         * The container details for the node range.
         * </p>
         * 
         * @param container
         *        The container details for the node range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(ContainerProperties container);

        /**
         * <p>
         * The container details for the node range.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerProperties.Builder} avoiding the
         * need to create one manually via {@link ContainerProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #container(ContainerProperties)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link ContainerProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(ContainerProperties)
         */
        default Builder container(Consumer<ContainerProperties.Builder> container) {
            return container(ContainerProperties.builder().applyMutation(container).build());
        }

        /**
         * <p>
         * The instance types of the underlying host infrastructure of a multi-node parallel job.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources.
         * </p>
         * <p>
         * In addition, this list object is currently limited to one element.
         * </p>
         * </note>
         * 
         * @param instanceTypes
         *        The instance types of the underlying host infrastructure of a multi-node parallel job.</p> <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources.
         *        </p>
         *        <p>
         *        In addition, this list object is currently limited to one element.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(Collection<String> instanceTypes);

        /**
         * <p>
         * The instance types of the underlying host infrastructure of a multi-node parallel job.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources.
         * </p>
         * <p>
         * In addition, this list object is currently limited to one element.
         * </p>
         * </note>
         * 
         * @param instanceTypes
         *        The instance types of the underlying host infrastructure of a multi-node parallel job.</p> <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources.
         *        </p>
         *        <p>
         *        In addition, this list object is currently limited to one element.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(String... instanceTypes);

        /**
         * <p>
         * This is an object that represents the properties of the node range for a multi-node parallel job.
         * </p>
         * 
         * @param ecsProperties
         *        This is an object that represents the properties of the node range for a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsProperties(EcsProperties ecsProperties);

        /**
         * <p>
         * This is an object that represents the properties of the node range for a multi-node parallel job.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcsProperties.Builder} avoiding the need
         * to create one manually via {@link EcsProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EcsProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #ecsProperties(EcsProperties)}.
         * 
         * @param ecsProperties
         *        a consumer that will call methods on {@link EcsProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsProperties(EcsProperties)
         */
        default Builder ecsProperties(Consumer<EcsProperties.Builder> ecsProperties) {
            return ecsProperties(EcsProperties.builder().applyMutation(ecsProperties).build());
        }

        /**
         * <p>
         * This is an object that represents the properties of the node range for a multi-node parallel job.
         * </p>
         * 
         * @param eksProperties
         *        This is an object that represents the properties of the node range for a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksProperties(EksProperties eksProperties);

        /**
         * <p>
         * This is an object that represents the properties of the node range for a multi-node parallel job.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksProperties.Builder} avoiding the need
         * to create one manually via {@link EksProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #eksProperties(EksProperties)}.
         * 
         * @param eksProperties
         *        a consumer that will call methods on {@link EksProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eksProperties(EksProperties)
         */
        default Builder eksProperties(Consumer<EksProperties.Builder> eksProperties) {
            return eksProperties(EksProperties.builder().applyMutation(eksProperties).build());
        }

        /**
         * <p>
         * Contains a list of consumable resources required by a job.
         * </p>
         * 
         * @param consumableResourceProperties
         *        Contains a list of consumable resources required by a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResourceProperties(ConsumableResourceProperties consumableResourceProperties);

        /**
         * <p>
         * Contains a list of consumable resources required by a job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumableResourceProperties.Builder}
         * avoiding the need to create one manually via {@link ConsumableResourceProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsumableResourceProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #consumableResourceProperties(ConsumableResourceProperties)}.
         * 
         * @param consumableResourceProperties
         *        a consumer that will call methods on {@link ConsumableResourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumableResourceProperties(ConsumableResourceProperties)
         */
        default Builder consumableResourceProperties(Consumer<ConsumableResourceProperties.Builder> consumableResourceProperties) {
            return consumableResourceProperties(ConsumableResourceProperties.builder()
                    .applyMutation(consumableResourceProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String targetNodes;

        private ContainerProperties container;

        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();

        private EcsProperties ecsProperties;

        private EksProperties eksProperties;

        private ConsumableResourceProperties consumableResourceProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeRangeProperty model) {
            targetNodes(model.targetNodes);
            container(model.container);
            instanceTypes(model.instanceTypes);
            ecsProperties(model.ecsProperties);
            eksProperties(model.eksProperties);
            consumableResourceProperties(model.consumableResourceProperties);
        }

        public final String getTargetNodes() {
            return targetNodes;
        }

        public final void setTargetNodes(String targetNodes) {
            this.targetNodes = targetNodes;
        }

        @Override
        public final Builder targetNodes(String targetNodes) {
            this.targetNodes = targetNodes;
            return this;
        }

        public final ContainerProperties.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        public final void setContainer(ContainerProperties.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(ContainerProperties container) {
            this.container = container;
            return this;
        }

        public final Collection<String> getInstanceTypes() {
            if (instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceTypes;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String... instanceTypes) {
            instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final EcsProperties.Builder getEcsProperties() {
            return ecsProperties != null ? ecsProperties.toBuilder() : null;
        }

        public final void setEcsProperties(EcsProperties.BuilderImpl ecsProperties) {
            this.ecsProperties = ecsProperties != null ? ecsProperties.build() : null;
        }

        @Override
        public final Builder ecsProperties(EcsProperties ecsProperties) {
            this.ecsProperties = ecsProperties;
            return this;
        }

        public final EksProperties.Builder getEksProperties() {
            return eksProperties != null ? eksProperties.toBuilder() : null;
        }

        public final void setEksProperties(EksProperties.BuilderImpl eksProperties) {
            this.eksProperties = eksProperties != null ? eksProperties.build() : null;
        }

        @Override
        public final Builder eksProperties(EksProperties eksProperties) {
            this.eksProperties = eksProperties;
            return this;
        }

        public final ConsumableResourceProperties.Builder getConsumableResourceProperties() {
            return consumableResourceProperties != null ? consumableResourceProperties.toBuilder() : null;
        }

        public final void setConsumableResourceProperties(ConsumableResourceProperties.BuilderImpl consumableResourceProperties) {
            this.consumableResourceProperties = consumableResourceProperties != null ? consumableResourceProperties.build()
                    : null;
        }

        @Override
        public final Builder consumableResourceProperties(ConsumableResourceProperties consumableResourceProperties) {
            this.consumableResourceProperties = consumableResourceProperties;
            return this;
        }

        @Override
        public NodeRangeProperty build() {
            return new NodeRangeProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
