/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a job timeout configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobTimeout implements SdkPojo, Serializable, ToCopyableBuilder<JobTimeout.Builder, JobTimeout> {
    private static final SdkField<Integer> ATTEMPT_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("attemptDurationSeconds").getter(getter(JobTimeout::attemptDurationSeconds))
            .setter(setter(Builder::attemptDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attemptDurationSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ATTEMPT_DURATION_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer attemptDurationSeconds;

    private JobTimeout(BuilderImpl builder) {
        this.attemptDurationSeconds = builder.attemptDurationSeconds;
    }

    /**
     * <p>
     * The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code> timestamp. After
     * this time passes, Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60
     * seconds.
     * </p>
     * <p>
     * For array jobs, the timeout applies to the child jobs, not to the parent array job.
     * </p>
     * <p>
     * For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
     * </p>
     * 
     * @return The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code>
     *         timestamp. After this time passes, Batch terminates your jobs if they aren't finished. The minimum value
     *         for the timeout is 60 seconds.</p>
     *         <p>
     *         For array jobs, the timeout applies to the child jobs, not to the parent array job.
     *         </p>
     *         <p>
     *         For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
     */
    public final Integer attemptDurationSeconds() {
        return attemptDurationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attemptDurationSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTimeout)) {
            return false;
        }
        JobTimeout other = (JobTimeout) obj;
        return Objects.equals(attemptDurationSeconds(), other.attemptDurationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobTimeout").add("AttemptDurationSeconds", attemptDurationSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attemptDurationSeconds":
            return Optional.ofNullable(clazz.cast(attemptDurationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attemptDurationSeconds", ATTEMPT_DURATION_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobTimeout, T> g) {
        return obj -> g.apply((JobTimeout) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobTimeout> {
        /**
         * <p>
         * The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code> timestamp.
         * After this time passes, Batch terminates your jobs if they aren't finished. The minimum value for the timeout
         * is 60 seconds.
         * </p>
         * <p>
         * For array jobs, the timeout applies to the child jobs, not to the parent array job.
         * </p>
         * <p>
         * For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
         * </p>
         * 
         * @param attemptDurationSeconds
         *        The job timeout time (in seconds) that's measured from the job attempt's <code>startedAt</code>
         *        timestamp. After this time passes, Batch terminates your jobs if they aren't finished. The minimum
         *        value for the timeout is 60 seconds.</p>
         *        <p>
         *        For array jobs, the timeout applies to the child jobs, not to the parent array job.
         *        </p>
         *        <p>
         *        For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attemptDurationSeconds(Integer attemptDurationSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer attemptDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(JobTimeout model) {
            attemptDurationSeconds(model.attemptDurationSeconds);
        }

        public final Integer getAttemptDurationSeconds() {
            return attemptDurationSeconds;
        }

        public final void setAttemptDurationSeconds(Integer attemptDurationSeconds) {
            this.attemptDurationSeconds = attemptDurationSeconds;
        }

        @Override
        public final Builder attemptDurationSeconds(Integer attemptDurationSeconds) {
            this.attemptDurationSeconds = attemptDurationSeconds;
            return this;
        }

        @Override
        public JobTimeout build() {
            return new JobTimeout(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
