/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration of a Kubernetes <code>secret</code> volume. For more information, see <a
 * href="https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <i>Kubernetes documentation</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksSecret implements SdkPojo, Serializable, ToCopyableBuilder<EksSecret.Builder, EksSecret> {
    private static final SdkField<String> SECRET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretName").getter(getter(EksSecret::secretName)).setter(setter(Builder::secretName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretName").build()).build();

    private static final SdkField<Boolean> OPTIONAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("optional").getter(getter(EksSecret::optional)).setter(setter(Builder::optional))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optional").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_NAME_FIELD,
            OPTIONAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secretName;

    private final Boolean optional;

    private EksSecret(BuilderImpl builder) {
        this.secretName = builder.secretName;
        this.optional = builder.optional;
    }

    /**
     * <p>
     * The name of the secret. The name must be allowed as a DNS subdomain name. For more information, see <a
     * href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS subdomain
     * names</a> in the <i>Kubernetes documentation</i>.
     * </p>
     * 
     * @return The name of the secret. The name must be allowed as a DNS subdomain name. For more information, see <a
     *         href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS
     *         subdomain names</a> in the <i>Kubernetes documentation</i>.
     */
    public final String secretName() {
        return secretName;
    }

    /**
     * <p>
     * Specifies whether the secret or the secret's keys must be defined.
     * </p>
     * 
     * @return Specifies whether the secret or the secret's keys must be defined.
     */
    public final Boolean optional() {
        return optional;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretName());
        hashCode = 31 * hashCode + Objects.hashCode(optional());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksSecret)) {
            return false;
        }
        EksSecret other = (EksSecret) obj;
        return Objects.equals(secretName(), other.secretName()) && Objects.equals(optional(), other.optional());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksSecret").add("SecretName", secretName()).add("Optional", optional()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "secretName":
            return Optional.ofNullable(clazz.cast(secretName()));
        case "optional":
            return Optional.ofNullable(clazz.cast(optional()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("secretName", SECRET_NAME_FIELD);
        map.put("optional", OPTIONAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksSecret, T> g) {
        return obj -> g.apply((EksSecret) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksSecret> {
        /**
         * <p>
         * The name of the secret. The name must be allowed as a DNS subdomain name. For more information, see <a
         * href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS
         * subdomain names</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * 
         * @param secretName
         *        The name of the secret. The name must be allowed as a DNS subdomain name. For more information, see <a
         *        href
         *        ="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS
         *        subdomain names</a> in the <i>Kubernetes documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretName(String secretName);

        /**
         * <p>
         * Specifies whether the secret or the secret's keys must be defined.
         * </p>
         * 
         * @param optional
         *        Specifies whether the secret or the secret's keys must be defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optional(Boolean optional);
    }

    static final class BuilderImpl implements Builder {
        private String secretName;

        private Boolean optional;

        private BuilderImpl() {
        }

        private BuilderImpl(EksSecret model) {
            secretName(model.secretName);
            optional(model.optional);
        }

        public final String getSecretName() {
            return secretName;
        }

        public final void setSecretName(String secretName) {
            this.secretName = secretName;
        }

        @Override
        public final Builder secretName(String secretName) {
            this.secretName = secretName;
            return this;
        }

        public final Boolean getOptional() {
            return optional;
        }

        public final void setOptional(Boolean optional) {
            this.optional = optional;
        }

        @Override
        public final Builder optional(Boolean optional) {
            this.optional = optional;
            return this;
        }

        @Override
        public EksSecret build() {
            return new EksSecret(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
