/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a consumable resource required to run a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConsumableResourceRequirement implements SdkPojo, Serializable,
        ToCopyableBuilder<ConsumableResourceRequirement.Builder, ConsumableResourceRequirement> {
    private static final SdkField<String> CONSUMABLE_RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("consumableResource").getter(getter(ConsumableResourceRequirement::consumableResource))
            .setter(setter(Builder::consumableResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResource").build())
            .build();

    private static final SdkField<Long> QUANTITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("quantity")
            .getter(getter(ConsumableResourceRequirement::quantity)).setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMABLE_RESOURCE_FIELD,
            QUANTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String consumableResource;

    private final Long quantity;

    private ConsumableResourceRequirement(BuilderImpl builder) {
        this.consumableResource = builder.consumableResource;
        this.quantity = builder.quantity;
    }

    /**
     * <p>
     * The name or ARN of the consumable resource.
     * </p>
     * 
     * @return The name or ARN of the consumable resource.
     */
    public final String consumableResource() {
        return consumableResource;
    }

    /**
     * <p>
     * The quantity of the consumable resource that is needed.
     * </p>
     * 
     * @return The quantity of the consumable resource that is needed.
     */
    public final Long quantity() {
        return quantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consumableResource());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumableResourceRequirement)) {
            return false;
        }
        ConsumableResourceRequirement other = (ConsumableResourceRequirement) obj;
        return Objects.equals(consumableResource(), other.consumableResource()) && Objects.equals(quantity(), other.quantity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConsumableResourceRequirement").add("ConsumableResource", consumableResource())
                .add("Quantity", quantity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "consumableResource":
            return Optional.ofNullable(clazz.cast(consumableResource()));
        case "quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consumableResource", CONSUMABLE_RESOURCE_FIELD);
        map.put("quantity", QUANTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsumableResourceRequirement, T> g) {
        return obj -> g.apply((ConsumableResourceRequirement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConsumableResourceRequirement> {
        /**
         * <p>
         * The name or ARN of the consumable resource.
         * </p>
         * 
         * @param consumableResource
         *        The name or ARN of the consumable resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResource(String consumableResource);

        /**
         * <p>
         * The quantity of the consumable resource that is needed.
         * </p>
         * 
         * @param quantity
         *        The quantity of the consumable resource that is needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Long quantity);
    }

    static final class BuilderImpl implements Builder {
        private String consumableResource;

        private Long quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumableResourceRequirement model) {
            consumableResource(model.consumableResource);
            quantity(model.quantity);
        }

        public final String getConsumableResource() {
            return consumableResource;
        }

        public final void setConsumableResource(String consumableResource) {
            this.consumableResource = consumableResource;
        }

        @Override
        public final Builder consumableResource(String consumableResource) {
            this.consumableResource = consumableResource;
            return this;
        }

        public final Long getQuantity() {
            return quantity;
        }

        public final void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Long quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public ConsumableResourceRequirement build() {
            return new ConsumableResourceRequirement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
