/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.ContainerOverrides;
import software.amazon.awssdk.services.batch.model.EcsPropertiesOverride;
import software.amazon.awssdk.services.batch.model.EksPropertiesOverride;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodePropertyOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodePropertyOverride> {
    private static final SdkField<String> TARGET_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetNodes").getter(NodePropertyOverride.getter(NodePropertyOverride::targetNodes)).setter(NodePropertyOverride.setter(Builder::targetNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetNodes").build()}).build();
    private static final SdkField<ContainerOverrides> CONTAINER_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerOverrides").getter(NodePropertyOverride.getter(NodePropertyOverride::containerOverrides)).setter(NodePropertyOverride.setter(Builder::containerOverrides)).constructor(ContainerOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerOverrides").build()}).build();
    private static final SdkField<EcsPropertiesOverride> ECS_PROPERTIES_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ecsPropertiesOverride").getter(NodePropertyOverride.getter(NodePropertyOverride::ecsPropertiesOverride)).setter(NodePropertyOverride.setter(Builder::ecsPropertiesOverride)).constructor(EcsPropertiesOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsPropertiesOverride").build()}).build();
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceTypes").getter(NodePropertyOverride.getter(NodePropertyOverride::instanceTypes)).setter(NodePropertyOverride.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EksPropertiesOverride> EKS_PROPERTIES_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eksPropertiesOverride").getter(NodePropertyOverride.getter(NodePropertyOverride::eksPropertiesOverride)).setter(NodePropertyOverride.setter(Builder::eksPropertiesOverride)).constructor(EksPropertiesOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksPropertiesOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_NODES_FIELD, CONTAINER_OVERRIDES_FIELD, ECS_PROPERTIES_OVERRIDE_FIELD, INSTANCE_TYPES_FIELD, EKS_PROPERTIES_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodePropertyOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String targetNodes;
    private final ContainerOverrides containerOverrides;
    private final EcsPropertiesOverride ecsPropertiesOverride;
    private final List<String> instanceTypes;
    private final EksPropertiesOverride eksPropertiesOverride;

    private NodePropertyOverride(BuilderImpl builder) {
        this.targetNodes = builder.targetNodes;
        this.containerOverrides = builder.containerOverrides;
        this.ecsPropertiesOverride = builder.ecsPropertiesOverride;
        this.instanceTypes = builder.instanceTypes;
        this.eksPropertiesOverride = builder.eksPropertiesOverride;
    }

    public final String targetNodes() {
        return this.targetNodes;
    }

    public final ContainerOverrides containerOverrides() {
        return this.containerOverrides;
    }

    public final EcsPropertiesOverride ecsPropertiesOverride() {
        return this.ecsPropertiesOverride;
    }

    public final boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public final EksPropertiesOverride eksPropertiesOverride() {
        return this.eksPropertiesOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsPropertiesOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypes() ? this.instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eksPropertiesOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodePropertyOverride)) {
            return false;
        }
        NodePropertyOverride other = (NodePropertyOverride)obj;
        return Objects.equals(this.targetNodes(), other.targetNodes()) && Objects.equals(this.containerOverrides(), other.containerOverrides()) && Objects.equals(this.ecsPropertiesOverride(), other.ecsPropertiesOverride()) && this.hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.eksPropertiesOverride(), other.eksPropertiesOverride());
    }

    public final String toString() {
        return ToString.builder((String)"NodePropertyOverride").add("TargetNodes", (Object)this.targetNodes()).add("ContainerOverrides", (Object)this.containerOverrides()).add("EcsPropertiesOverride", (Object)this.ecsPropertiesOverride()).add("InstanceTypes", this.hasInstanceTypes() ? this.instanceTypes() : null).add("EksPropertiesOverride", (Object)this.eksPropertiesOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetNodes": {
                return Optional.ofNullable(clazz.cast(this.targetNodes()));
            }
            case "containerOverrides": {
                return Optional.ofNullable(clazz.cast(this.containerOverrides()));
            }
            case "ecsPropertiesOverride": {
                return Optional.ofNullable(clazz.cast(this.ecsPropertiesOverride()));
            }
            case "instanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "eksPropertiesOverride": {
                return Optional.ofNullable(clazz.cast(this.eksPropertiesOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetNodes", TARGET_NODES_FIELD);
        map.put("containerOverrides", CONTAINER_OVERRIDES_FIELD);
        map.put("ecsPropertiesOverride", ECS_PROPERTIES_OVERRIDE_FIELD);
        map.put("instanceTypes", INSTANCE_TYPES_FIELD);
        map.put("eksPropertiesOverride", EKS_PROPERTIES_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodePropertyOverride, T> g) {
        return obj -> g.apply((NodePropertyOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetNodes;
        private ContainerOverrides containerOverrides;
        private EcsPropertiesOverride ecsPropertiesOverride;
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private EksPropertiesOverride eksPropertiesOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(NodePropertyOverride model) {
            this.targetNodes(model.targetNodes);
            this.containerOverrides(model.containerOverrides);
            this.ecsPropertiesOverride(model.ecsPropertiesOverride);
            this.instanceTypes(model.instanceTypes);
            this.eksPropertiesOverride(model.eksPropertiesOverride);
        }

        public final String getTargetNodes() {
            return this.targetNodes;
        }

        public final void setTargetNodes(String targetNodes) {
            this.targetNodes = targetNodes;
        }

        @Override
        public final Builder targetNodes(String targetNodes) {
            this.targetNodes = targetNodes;
            return this;
        }

        public final ContainerOverrides.Builder getContainerOverrides() {
            return this.containerOverrides != null ? this.containerOverrides.toBuilder() : null;
        }

        public final void setContainerOverrides(ContainerOverrides.BuilderImpl containerOverrides) {
            this.containerOverrides = containerOverrides != null ? containerOverrides.build() : null;
        }

        @Override
        public final Builder containerOverrides(ContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public final EcsPropertiesOverride.Builder getEcsPropertiesOverride() {
            return this.ecsPropertiesOverride != null ? this.ecsPropertiesOverride.toBuilder() : null;
        }

        public final void setEcsPropertiesOverride(EcsPropertiesOverride.BuilderImpl ecsPropertiesOverride) {
            this.ecsPropertiesOverride = ecsPropertiesOverride != null ? ecsPropertiesOverride.build() : null;
        }

        @Override
        public final Builder ecsPropertiesOverride(EcsPropertiesOverride ecsPropertiesOverride) {
            this.ecsPropertiesOverride = ecsPropertiesOverride;
            return this;
        }

        public final Collection<String> getInstanceTypes() {
            if (this.instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceTypes;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final EksPropertiesOverride.Builder getEksPropertiesOverride() {
            return this.eksPropertiesOverride != null ? this.eksPropertiesOverride.toBuilder() : null;
        }

        public final void setEksPropertiesOverride(EksPropertiesOverride.BuilderImpl eksPropertiesOverride) {
            this.eksPropertiesOverride = eksPropertiesOverride != null ? eksPropertiesOverride.build() : null;
        }

        @Override
        public final Builder eksPropertiesOverride(EksPropertiesOverride eksPropertiesOverride) {
            this.eksPropertiesOverride = eksPropertiesOverride;
            return this;
        }

        public NodePropertyOverride build() {
            return new NodePropertyOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodePropertyOverride> {
        public Builder targetNodes(String var1);

        public Builder containerOverrides(ContainerOverrides var1);

        default public Builder containerOverrides(Consumer<ContainerOverrides.Builder> containerOverrides) {
            return this.containerOverrides((ContainerOverrides)((ContainerOverrides.Builder)ContainerOverrides.builder().applyMutation(containerOverrides)).build());
        }

        public Builder ecsPropertiesOverride(EcsPropertiesOverride var1);

        default public Builder ecsPropertiesOverride(Consumer<EcsPropertiesOverride.Builder> ecsPropertiesOverride) {
            return this.ecsPropertiesOverride((EcsPropertiesOverride)((EcsPropertiesOverride.Builder)EcsPropertiesOverride.builder().applyMutation(ecsPropertiesOverride)).build());
        }

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder eksPropertiesOverride(EksPropertiesOverride var1);

        default public Builder eksPropertiesOverride(Consumer<EksPropertiesOverride.Builder> eksPropertiesOverride) {
            return this.eksPropertiesOverride((EksPropertiesOverride)((EksPropertiesOverride.Builder)EksPropertiesOverride.builder().applyMutation(eksPropertiesOverride)).build());
        }
    }
}

