/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskContainerDependency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskContainerDependency> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerName").getter(TaskContainerDependency.getter(TaskContainerDependency::containerName)).setter(TaskContainerDependency.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()}).build();
    private static final SdkField<String> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("condition").getter(TaskContainerDependency.getter(TaskContainerDependency::condition)).setter(TaskContainerDependency.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD, CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("containerName", CONTAINER_NAME_FIELD);
            this.put("condition", CONDITION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String containerName;
    private final String condition;

    private TaskContainerDependency(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.condition = builder.condition;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final String condition() {
        return this.condition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskContainerDependency)) {
            return false;
        }
        TaskContainerDependency other = (TaskContainerDependency)obj;
        return Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.condition(), other.condition());
    }

    public final String toString() {
        return ToString.builder((String)"TaskContainerDependency").add("ContainerName", (Object)this.containerName()).add("Condition", (Object)this.condition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TaskContainerDependency, T> g) {
        return obj -> g.apply((TaskContainerDependency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerName;
        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskContainerDependency model) {
            this.containerName(model.containerName);
            this.condition(model.condition);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final String getCondition() {
            return this.condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public TaskContainerDependency build() {
            return new TaskContainerDependency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskContainerDependency> {
        public Builder containerName(String var1);

        public Builder condition(String var1);
    }
}

