/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.SchedulingPolicyDetail;
import software.amazon.awssdk.services.batch.model.SchedulingPolicyDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSchedulingPoliciesResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, DescribeSchedulingPoliciesResponse> {
    private static final SdkField<List<SchedulingPolicyDetail>> SCHEDULING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("schedulingPolicies").getter(DescribeSchedulingPoliciesResponse.getter(DescribeSchedulingPoliciesResponse::schedulingPolicies)).setter(DescribeSchedulingPoliciesResponse.setter(Builder::schedulingPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchedulingPolicyDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULING_POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("schedulingPolicies", SCHEDULING_POLICIES_FIELD);
        }
    });
    private final List<SchedulingPolicyDetail> schedulingPolicies;

    private DescribeSchedulingPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.schedulingPolicies = builder.schedulingPolicies;
    }

    public final boolean hasSchedulingPolicies() {
        return this.schedulingPolicies != null && !(this.schedulingPolicies instanceof SdkAutoConstructList);
    }

    public final List<SchedulingPolicyDetail> schedulingPolicies() {
        return this.schedulingPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchedulingPolicies() ? this.schedulingPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSchedulingPoliciesResponse)) {
            return false;
        }
        DescribeSchedulingPoliciesResponse other = (DescribeSchedulingPoliciesResponse)((Object)obj);
        return this.hasSchedulingPolicies() == other.hasSchedulingPolicies() && Objects.equals(this.schedulingPolicies(), other.schedulingPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSchedulingPoliciesResponse").add("SchedulingPolicies", this.hasSchedulingPolicies() ? this.schedulingPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schedulingPolicies": {
                return Optional.ofNullable(clazz.cast(this.schedulingPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSchedulingPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeSchedulingPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private List<SchedulingPolicyDetail> schedulingPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSchedulingPoliciesResponse model) {
            super(model);
            this.schedulingPolicies(model.schedulingPolicies);
        }

        public final List<SchedulingPolicyDetail.Builder> getSchedulingPolicies() {
            List<SchedulingPolicyDetail.Builder> result = SchedulingPolicyDetailListCopier.copyToBuilder(this.schedulingPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchedulingPolicies(Collection<SchedulingPolicyDetail.BuilderImpl> schedulingPolicies) {
            this.schedulingPolicies = SchedulingPolicyDetailListCopier.copyFromBuilder(schedulingPolicies);
        }

        @Override
        public final Builder schedulingPolicies(Collection<SchedulingPolicyDetail> schedulingPolicies) {
            this.schedulingPolicies = SchedulingPolicyDetailListCopier.copy(schedulingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedulingPolicies(SchedulingPolicyDetail ... schedulingPolicies) {
            this.schedulingPolicies(Arrays.asList(schedulingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schedulingPolicies(Consumer<SchedulingPolicyDetail.Builder> ... schedulingPolicies) {
            this.schedulingPolicies(Stream.of(schedulingPolicies).map(c -> (SchedulingPolicyDetail)((SchedulingPolicyDetail.Builder)SchedulingPolicyDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeSchedulingPoliciesResponse build() {
            return new DescribeSchedulingPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSchedulingPoliciesResponse> {
        public Builder schedulingPolicies(Collection<SchedulingPolicyDetail> var1);

        public Builder schedulingPolicies(SchedulingPolicyDetail ... var1);

        public Builder schedulingPolicies(Consumer<SchedulingPolicyDetail.Builder> ... var1);
    }
}

