/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.AttemptTaskContainerDetails;
import software.amazon.awssdk.services.batch.model.ListAttemptTaskContainerDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttemptEcsTaskDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttemptEcsTaskDetails> {
    private static final SdkField<String> CONTAINER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerInstanceArn").getter(AttemptEcsTaskDetails.getter(AttemptEcsTaskDetails::containerInstanceArn)).setter(AttemptEcsTaskDetails.setter(Builder::containerInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArn").build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskArn").getter(AttemptEcsTaskDetails.getter(AttemptEcsTaskDetails::taskArn)).setter(AttemptEcsTaskDetails.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()}).build();
    private static final SdkField<List<AttemptTaskContainerDetails>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containers").getter(AttemptEcsTaskDetails.getter(AttemptEcsTaskDetails::containers)).setter(AttemptEcsTaskDetails.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttemptTaskContainerDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_INSTANCE_ARN_FIELD, TASK_ARN_FIELD, CONTAINERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("containerInstanceArn", CONTAINER_INSTANCE_ARN_FIELD);
            this.put("taskArn", TASK_ARN_FIELD);
            this.put("containers", CONTAINERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String containerInstanceArn;
    private final String taskArn;
    private final List<AttemptTaskContainerDetails> containers;

    private AttemptEcsTaskDetails(BuilderImpl builder) {
        this.containerInstanceArn = builder.containerInstanceArn;
        this.taskArn = builder.taskArn;
        this.containers = builder.containers;
    }

    public final String containerInstanceArn() {
        return this.containerInstanceArn;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<AttemptTaskContainerDetails> containers() {
        return this.containers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttemptEcsTaskDetails)) {
            return false;
        }
        AttemptEcsTaskDetails other = (AttemptEcsTaskDetails)obj;
        return Objects.equals(this.containerInstanceArn(), other.containerInstanceArn()) && Objects.equals(this.taskArn(), other.taskArn()) && this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers());
    }

    public final String toString() {
        return ToString.builder((String)"AttemptEcsTaskDetails").add("ContainerInstanceArn", (Object)this.containerInstanceArn()).add("TaskArn", (Object)this.taskArn()).add("Containers", this.hasContainers() ? this.containers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.containerInstanceArn()));
            }
            case "taskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AttemptEcsTaskDetails, T> g) {
        return obj -> g.apply((AttemptEcsTaskDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerInstanceArn;
        private String taskArn;
        private List<AttemptTaskContainerDetails> containers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttemptEcsTaskDetails model) {
            this.containerInstanceArn(model.containerInstanceArn);
            this.taskArn(model.taskArn);
            this.containers(model.containers);
        }

        public final String getContainerInstanceArn() {
            return this.containerInstanceArn;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final List<AttemptTaskContainerDetails.Builder> getContainers() {
            List<AttemptTaskContainerDetails.Builder> result = ListAttemptTaskContainerDetailsCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<AttemptTaskContainerDetails.BuilderImpl> containers) {
            this.containers = ListAttemptTaskContainerDetailsCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<AttemptTaskContainerDetails> containers) {
            this.containers = ListAttemptTaskContainerDetailsCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(AttemptTaskContainerDetails ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<AttemptTaskContainerDetails.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (AttemptTaskContainerDetails)((AttemptTaskContainerDetails.Builder)AttemptTaskContainerDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AttemptEcsTaskDetails build() {
            return new AttemptEcsTaskDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttemptEcsTaskDetails> {
        public Builder containerInstanceArn(String var1);

        public Builder taskArn(String var1);

        public Builder containers(Collection<AttemptTaskContainerDetails> var1);

        public Builder containers(AttemptTaskContainerDetails ... var1);

        public Builder containers(Consumer<AttemptTaskContainerDetails.Builder> ... var1);
    }
}

