/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSchedulingPoliciesRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, DescribeSchedulingPoliciesRequest> {
    private static final SdkField<List<String>> ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("arns").getter(DescribeSchedulingPoliciesRequest.getter(DescribeSchedulingPoliciesRequest::arns)).setter(DescribeSchedulingPoliciesRequest.setter(Builder::arns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arns", ARNS_FIELD);
        }
    });
    private final List<String> arns;

    private DescribeSchedulingPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.arns = builder.arns;
    }

    public final boolean hasArns() {
        return this.arns != null && !(this.arns instanceof SdkAutoConstructList);
    }

    public final List<String> arns() {
        return this.arns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArns() ? this.arns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSchedulingPoliciesRequest)) {
            return false;
        }
        DescribeSchedulingPoliciesRequest other = (DescribeSchedulingPoliciesRequest)((Object)obj);
        return this.hasArns() == other.hasArns() && Objects.equals(this.arns(), other.arns());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSchedulingPoliciesRequest").add("Arns", this.hasArns() ? this.arns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arns": {
                return Optional.ofNullable(clazz.cast(this.arns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSchedulingPoliciesRequest, T> g) {
        return obj -> g.apply((DescribeSchedulingPoliciesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private List<String> arns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSchedulingPoliciesRequest model) {
            super(model);
            this.arns(model.arns);
        }

        public final Collection<String> getArns() {
            if (this.arns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.arns;
        }

        public final void setArns(Collection<String> arns) {
            this.arns = StringListCopier.copy(arns);
        }

        @Override
        public final Builder arns(Collection<String> arns) {
            this.arns = StringListCopier.copy(arns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arns(String ... arns) {
            this.arns(Arrays.asList(arns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSchedulingPoliciesRequest build() {
            return new DescribeSchedulingPoliciesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSchedulingPoliciesRequest> {
        public Builder arns(Collection<String> var1);

        public Builder arns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

