/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EksContainer;
import software.amazon.awssdk.services.batch.model.EksContainersCopier;
import software.amazon.awssdk.services.batch.model.EksMetadata;
import software.amazon.awssdk.services.batch.model.EksVolume;
import software.amazon.awssdk.services.batch.model.EksVolumesCopier;
import software.amazon.awssdk.services.batch.model.ImagePullSecret;
import software.amazon.awssdk.services.batch.model.ImagePullSecretsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksPodProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksPodProperties> {
    private static final SdkField<String> SERVICE_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccountName").getter(EksPodProperties.getter(EksPodProperties::serviceAccountName)).setter(EksPodProperties.setter(Builder::serviceAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountName").build()}).build();
    private static final SdkField<Boolean> HOST_NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("hostNetwork").getter(EksPodProperties.getter(EksPodProperties::hostNetwork)).setter(EksPodProperties.setter(Builder::hostNetwork)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostNetwork").build()}).build();
    private static final SdkField<String> DNS_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsPolicy").getter(EksPodProperties.getter(EksPodProperties::dnsPolicy)).setter(EksPodProperties.setter(Builder::dnsPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsPolicy").build()}).build();
    private static final SdkField<List<ImagePullSecret>> IMAGE_PULL_SECRETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imagePullSecrets").getter(EksPodProperties.getter(EksPodProperties::imagePullSecrets)).setter(EksPodProperties.setter(Builder::imagePullSecrets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePullSecrets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImagePullSecret::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EksContainer>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containers").getter(EksPodProperties.getter(EksPodProperties::containers)).setter(EksPodProperties.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EksContainer>> INIT_CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("initContainers").getter(EksPodProperties.getter(EksPodProperties::initContainers)).setter(EksPodProperties.setter(Builder::initContainers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initContainers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EksVolume>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumes").getter(EksPodProperties.getter(EksPodProperties::volumes)).setter(EksPodProperties.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksVolume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EksMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(EksPodProperties.getter(EksPodProperties::metadata)).setter(EksPodProperties.setter(Builder::metadata)).constructor(EksMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<Boolean> SHARE_PROCESS_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("shareProcessNamespace").getter(EksPodProperties.getter(EksPodProperties::shareProcessNamespace)).setter(EksPodProperties.setter(Builder::shareProcessNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareProcessNamespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCOUNT_NAME_FIELD, HOST_NETWORK_FIELD, DNS_POLICY_FIELD, IMAGE_PULL_SECRETS_FIELD, CONTAINERS_FIELD, INIT_CONTAINERS_FIELD, VOLUMES_FIELD, METADATA_FIELD, SHARE_PROCESS_NAMESPACE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceAccountName;
    private final Boolean hostNetwork;
    private final String dnsPolicy;
    private final List<ImagePullSecret> imagePullSecrets;
    private final List<EksContainer> containers;
    private final List<EksContainer> initContainers;
    private final List<EksVolume> volumes;
    private final EksMetadata metadata;
    private final Boolean shareProcessNamespace;

    private EksPodProperties(BuilderImpl builder) {
        this.serviceAccountName = builder.serviceAccountName;
        this.hostNetwork = builder.hostNetwork;
        this.dnsPolicy = builder.dnsPolicy;
        this.imagePullSecrets = builder.imagePullSecrets;
        this.containers = builder.containers;
        this.initContainers = builder.initContainers;
        this.volumes = builder.volumes;
        this.metadata = builder.metadata;
        this.shareProcessNamespace = builder.shareProcessNamespace;
    }

    public final String serviceAccountName() {
        return this.serviceAccountName;
    }

    public final Boolean hostNetwork() {
        return this.hostNetwork;
    }

    public final String dnsPolicy() {
        return this.dnsPolicy;
    }

    public final boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !(this.imagePullSecrets instanceof SdkAutoConstructList);
    }

    public final List<ImagePullSecret> imagePullSecrets() {
        return this.imagePullSecrets;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<EksContainer> containers() {
        return this.containers;
    }

    public final boolean hasInitContainers() {
        return this.initContainers != null && !(this.initContainers instanceof SdkAutoConstructList);
    }

    public final List<EksContainer> initContainers() {
        return this.initContainers;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<EksVolume> volumes() {
        return this.volumes;
    }

    public final EksMetadata metadata() {
        return this.metadata;
    }

    public final Boolean shareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImagePullSecrets() ? this.imagePullSecrets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInitContainers() ? this.initContainers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareProcessNamespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksPodProperties)) {
            return false;
        }
        EksPodProperties other = (EksPodProperties)obj;
        return Objects.equals(this.serviceAccountName(), other.serviceAccountName()) && Objects.equals(this.hostNetwork(), other.hostNetwork()) && Objects.equals(this.dnsPolicy(), other.dnsPolicy()) && this.hasImagePullSecrets() == other.hasImagePullSecrets() && Objects.equals(this.imagePullSecrets(), other.imagePullSecrets()) && this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && this.hasInitContainers() == other.hasInitContainers() && Objects.equals(this.initContainers(), other.initContainers()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.shareProcessNamespace(), other.shareProcessNamespace());
    }

    public final String toString() {
        return ToString.builder((String)"EksPodProperties").add("ServiceAccountName", (Object)this.serviceAccountName()).add("HostNetwork", (Object)this.hostNetwork()).add("DnsPolicy", (Object)this.dnsPolicy()).add("ImagePullSecrets", this.hasImagePullSecrets() ? this.imagePullSecrets() : null).add("Containers", this.hasContainers() ? this.containers() : null).add("InitContainers", this.hasInitContainers() ? this.initContainers() : null).add("Volumes", this.hasVolumes() ? this.volumes() : null).add("Metadata", (Object)this.metadata()).add("ShareProcessNamespace", (Object)this.shareProcessNamespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceAccountName": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountName()));
            }
            case "hostNetwork": {
                return Optional.ofNullable(clazz.cast(this.hostNetwork()));
            }
            case "dnsPolicy": {
                return Optional.ofNullable(clazz.cast(this.dnsPolicy()));
            }
            case "imagePullSecrets": {
                return Optional.ofNullable(clazz.cast(this.imagePullSecrets()));
            }
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "initContainers": {
                return Optional.ofNullable(clazz.cast(this.initContainers()));
            }
            case "volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "shareProcessNamespace": {
                return Optional.ofNullable(clazz.cast(this.shareProcessNamespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EksPodProperties, T> g) {
        return obj -> g.apply((EksPodProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceAccountName;
        private Boolean hostNetwork;
        private String dnsPolicy;
        private List<ImagePullSecret> imagePullSecrets = DefaultSdkAutoConstructList.getInstance();
        private List<EksContainer> containers = DefaultSdkAutoConstructList.getInstance();
        private List<EksContainer> initContainers = DefaultSdkAutoConstructList.getInstance();
        private List<EksVolume> volumes = DefaultSdkAutoConstructList.getInstance();
        private EksMetadata metadata;
        private Boolean shareProcessNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(EksPodProperties model) {
            this.serviceAccountName(model.serviceAccountName);
            this.hostNetwork(model.hostNetwork);
            this.dnsPolicy(model.dnsPolicy);
            this.imagePullSecrets(model.imagePullSecrets);
            this.containers(model.containers);
            this.initContainers(model.initContainers);
            this.volumes(model.volumes);
            this.metadata(model.metadata);
            this.shareProcessNamespace(model.shareProcessNamespace);
        }

        public final String getServiceAccountName() {
            return this.serviceAccountName;
        }

        public final void setServiceAccountName(String serviceAccountName) {
            this.serviceAccountName = serviceAccountName;
        }

        @Override
        public final Builder serviceAccountName(String serviceAccountName) {
            this.serviceAccountName = serviceAccountName;
            return this;
        }

        public final Boolean getHostNetwork() {
            return this.hostNetwork;
        }

        public final void setHostNetwork(Boolean hostNetwork) {
            this.hostNetwork = hostNetwork;
        }

        @Override
        public final Builder hostNetwork(Boolean hostNetwork) {
            this.hostNetwork = hostNetwork;
            return this;
        }

        public final String getDnsPolicy() {
            return this.dnsPolicy;
        }

        public final void setDnsPolicy(String dnsPolicy) {
            this.dnsPolicy = dnsPolicy;
        }

        @Override
        public final Builder dnsPolicy(String dnsPolicy) {
            this.dnsPolicy = dnsPolicy;
            return this;
        }

        public final List<ImagePullSecret.Builder> getImagePullSecrets() {
            List<ImagePullSecret.Builder> result = ImagePullSecretsCopier.copyToBuilder(this.imagePullSecrets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImagePullSecrets(Collection<ImagePullSecret.BuilderImpl> imagePullSecrets) {
            this.imagePullSecrets = ImagePullSecretsCopier.copyFromBuilder(imagePullSecrets);
        }

        @Override
        public final Builder imagePullSecrets(Collection<ImagePullSecret> imagePullSecrets) {
            this.imagePullSecrets = ImagePullSecretsCopier.copy(imagePullSecrets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePullSecrets(ImagePullSecret ... imagePullSecrets) {
            this.imagePullSecrets(Arrays.asList(imagePullSecrets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePullSecrets(Consumer<ImagePullSecret.Builder> ... imagePullSecrets) {
            this.imagePullSecrets(Stream.of(imagePullSecrets).map(c -> (ImagePullSecret)((ImagePullSecret.Builder)ImagePullSecret.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EksContainer.Builder> getContainers() {
            List<EksContainer.Builder> result = EksContainersCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<EksContainer.BuilderImpl> containers) {
            this.containers = EksContainersCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<EksContainer> containers) {
            this.containers = EksContainersCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(EksContainer ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<EksContainer.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (EksContainer)((EksContainer.Builder)EksContainer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EksContainer.Builder> getInitContainers() {
            List<EksContainer.Builder> result = EksContainersCopier.copyToBuilder(this.initContainers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInitContainers(Collection<EksContainer.BuilderImpl> initContainers) {
            this.initContainers = EksContainersCopier.copyFromBuilder(initContainers);
        }

        @Override
        public final Builder initContainers(Collection<EksContainer> initContainers) {
            this.initContainers = EksContainersCopier.copy(initContainers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initContainers(EksContainer ... initContainers) {
            this.initContainers(Arrays.asList(initContainers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initContainers(Consumer<EksContainer.Builder> ... initContainers) {
            this.initContainers(Stream.of(initContainers).map(c -> (EksContainer)((EksContainer.Builder)EksContainer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EksVolume.Builder> getVolumes() {
            List<EksVolume.Builder> result = EksVolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<EksVolume.BuilderImpl> volumes) {
            this.volumes = EksVolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<EksVolume> volumes) {
            this.volumes = EksVolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(EksVolume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<EksVolume.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (EksVolume)((EksVolume.Builder)EksVolume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EksMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(EksMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(EksMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Boolean getShareProcessNamespace() {
            return this.shareProcessNamespace;
        }

        public final void setShareProcessNamespace(Boolean shareProcessNamespace) {
            this.shareProcessNamespace = shareProcessNamespace;
        }

        @Override
        public final Builder shareProcessNamespace(Boolean shareProcessNamespace) {
            this.shareProcessNamespace = shareProcessNamespace;
            return this;
        }

        public EksPodProperties build() {
            return new EksPodProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksPodProperties> {
        public Builder serviceAccountName(String var1);

        public Builder hostNetwork(Boolean var1);

        public Builder dnsPolicy(String var1);

        public Builder imagePullSecrets(Collection<ImagePullSecret> var1);

        public Builder imagePullSecrets(ImagePullSecret ... var1);

        public Builder imagePullSecrets(Consumer<ImagePullSecret.Builder> ... var1);

        public Builder containers(Collection<EksContainer> var1);

        public Builder containers(EksContainer ... var1);

        public Builder containers(Consumer<EksContainer.Builder> ... var1);

        public Builder initContainers(Collection<EksContainer> var1);

        public Builder initContainers(EksContainer ... var1);

        public Builder initContainers(Consumer<EksContainer.Builder> ... var1);

        public Builder volumes(Collection<EksVolume> var1);

        public Builder volumes(EksVolume ... var1);

        public Builder volumes(Consumer<EksVolume.Builder> ... var1);

        public Builder metadata(EksMetadata var1);

        default public Builder metadata(Consumer<EksMetadata.Builder> metadata) {
            return this.metadata((EksMetadata)((EksMetadata.Builder)EksMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder shareProcessNamespace(Boolean var1);
    }
}

