/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CRAllocationStrategy {
    BEST_FIT("BEST_FIT"),
    BEST_FIT_PROGRESSIVE("BEST_FIT_PROGRESSIVE"),
    SPOT_CAPACITY_OPTIMIZED("SPOT_CAPACITY_OPTIMIZED"),
    SPOT_PRICE_CAPACITY_OPTIMIZED("SPOT_PRICE_CAPACITY_OPTIMIZED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CRAllocationStrategy> VALUE_MAP;
    private final String value;

    private CRAllocationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CRAllocationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CRAllocationStrategy> knownValues() {
        EnumSet<CRAllocationStrategy> knownValues = EnumSet.allOf(CRAllocationStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CRAllocationStrategy.class, CRAllocationStrategy::toString);
    }
}

