/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.BatchClientBuilder;
import software.amazon.awssdk.services.batch.BatchServiceClientConfiguration;
import software.amazon.awssdk.services.batch.DefaultBatchBaseClientBuilder;
import software.amazon.awssdk.services.batch.DefaultBatchClient;
import software.amazon.awssdk.services.batch.endpoints.BatchEndpointProvider;

@SdkInternalApi
final class DefaultBatchClientBuilder
extends DefaultBatchBaseClientBuilder<BatchClientBuilder, BatchClient>
implements BatchClientBuilder {
    DefaultBatchClientBuilder() {
    }

    @Override
    public DefaultBatchClientBuilder endpointProvider(BatchEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BatchClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultBatchClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        BatchServiceClientConfiguration serviceClientConfiguration = BatchServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultBatchClient(serviceClientConfiguration, clientConfiguration);
    }
}

