/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail;
import software.amazon.awssdk.services.batch.model.EksAttemptContainerDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksAttemptDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksAttemptDetail> {
    private static final SdkField<List<EksAttemptContainerDetail>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containers").getter(EksAttemptDetail.getter(EksAttemptDetail::containers)).setter(EksAttemptDetail.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksAttemptContainerDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("podName").getter(EksAttemptDetail.getter(EksAttemptDetail::podName)).setter(EksAttemptDetail.setter(Builder::podName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podName").build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeName").getter(EksAttemptDetail.getter(EksAttemptDetail::nodeName)).setter(EksAttemptDetail.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()}).build();
    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startedAt").getter(EksAttemptDetail.getter(EksAttemptDetail::startedAt)).setter(EksAttemptDetail.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("stoppedAt").getter(EksAttemptDetail.getter(EksAttemptDetail::stoppedAt)).setter(EksAttemptDetail.setter(Builder::stoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(EksAttemptDetail.getter(EksAttemptDetail::statusReason)).setter(EksAttemptDetail.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINERS_FIELD, POD_NAME_FIELD, NODE_NAME_FIELD, STARTED_AT_FIELD, STOPPED_AT_FIELD, STATUS_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<EksAttemptContainerDetail> containers;
    private final String podName;
    private final String nodeName;
    private final Long startedAt;
    private final Long stoppedAt;
    private final String statusReason;

    private EksAttemptDetail(BuilderImpl builder) {
        this.containers = builder.containers;
        this.podName = builder.podName;
        this.nodeName = builder.nodeName;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.statusReason = builder.statusReason;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<EksAttemptContainerDetail> containers() {
        return this.containers;
    }

    public final String podName() {
        return this.podName;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final Long startedAt() {
        return this.startedAt;
    }

    public final Long stoppedAt() {
        return this.stoppedAt;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.podName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksAttemptDetail)) {
            return false;
        }
        EksAttemptDetail other = (EksAttemptDetail)obj;
        return this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && Objects.equals(this.podName(), other.podName()) && Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.stoppedAt(), other.stoppedAt()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"EksAttemptDetail").add("Containers", this.hasContainers() ? this.containers() : null).add("PodName", (Object)this.podName()).add("NodeName", (Object)this.nodeName()).add("StartedAt", (Object)this.startedAt()).add("StoppedAt", (Object)this.stoppedAt()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "podName": {
                return Optional.ofNullable(clazz.cast(this.podName()));
            }
            case "nodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "stoppedAt": {
                return Optional.ofNullable(clazz.cast(this.stoppedAt()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EksAttemptDetail, T> g) {
        return obj -> g.apply((EksAttemptDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EksAttemptContainerDetail> containers = DefaultSdkAutoConstructList.getInstance();
        private String podName;
        private String nodeName;
        private Long startedAt;
        private Long stoppedAt;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(EksAttemptDetail model) {
            this.containers(model.containers);
            this.podName(model.podName);
            this.nodeName(model.nodeName);
            this.startedAt(model.startedAt);
            this.stoppedAt(model.stoppedAt);
            this.statusReason(model.statusReason);
        }

        public final List<EksAttemptContainerDetail.Builder> getContainers() {
            List<EksAttemptContainerDetail.Builder> result = EksAttemptContainerDetailsCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<EksAttemptContainerDetail.BuilderImpl> containers) {
            this.containers = EksAttemptContainerDetailsCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<EksAttemptContainerDetail> containers) {
            this.containers = EksAttemptContainerDetailsCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(EksAttemptContainerDetail ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<EksAttemptContainerDetail.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (EksAttemptContainerDetail)((EksAttemptContainerDetail.Builder)EksAttemptContainerDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPodName() {
            return this.podName;
        }

        public final void setPodName(String podName) {
            this.podName = podName;
        }

        @Override
        public final Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Long getStoppedAt() {
            return this.stoppedAt;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public EksAttemptDetail build() {
            return new EksAttemptDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksAttemptDetail> {
        public Builder containers(Collection<EksAttemptContainerDetail> var1);

        public Builder containers(EksAttemptContainerDetail ... var1);

        public Builder containers(Consumer<EksAttemptContainerDetail.Builder> ... var1);

        public Builder podName(String var1);

        public Builder nodeName(String var1);

        public Builder startedAt(Long var1);

        public Builder stoppedAt(Long var1);

        public Builder statusReason(String var1);
    }
}

