/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrdersCopier;
import software.amazon.awssdk.services.batch.model.JQState;
import software.amazon.awssdk.services.batch.model.JQStatus;
import software.amazon.awssdk.services.batch.model.TagrisTagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobQueueDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobQueueDetail> {
    private static final SdkField<String> JOB_QUEUE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobQueueName").getter(JobQueueDetail.getter(JobQueueDetail::jobQueueName)).setter(JobQueueDetail.setter(Builder::jobQueueName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueueName").build()}).build();
    private static final SdkField<String> JOB_QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobQueueArn").getter(JobQueueDetail.getter(JobQueueDetail::jobQueueArn)).setter(JobQueueDetail.setter(Builder::jobQueueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueueArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(JobQueueDetail.getter(JobQueueDetail::stateAsString)).setter(JobQueueDetail.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(JobQueueDetail.getter(JobQueueDetail::statusAsString)).setter(JobQueueDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(JobQueueDetail.getter(JobQueueDetail::statusReason)).setter(JobQueueDetail.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(JobQueueDetail.getter(JobQueueDetail::priority)).setter(JobQueueDetail.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<List<ComputeEnvironmentOrder>> COMPUTE_ENVIRONMENT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("computeEnvironmentOrder").getter(JobQueueDetail.getter(JobQueueDetail::computeEnvironmentOrder)).setter(JobQueueDetail.setter(Builder::computeEnvironmentOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentOrder").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputeEnvironmentOrder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(JobQueueDetail.getter(JobQueueDetail::tags)).setter(JobQueueDetail.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_QUEUE_NAME_FIELD, JOB_QUEUE_ARN_FIELD, STATE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, PRIORITY_FIELD, COMPUTE_ENVIRONMENT_ORDER_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobQueueName;
    private final String jobQueueArn;
    private final String state;
    private final String status;
    private final String statusReason;
    private final Integer priority;
    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;
    private final Map<String, String> tags;

    private JobQueueDetail(BuilderImpl builder) {
        this.jobQueueName = builder.jobQueueName;
        this.jobQueueArn = builder.jobQueueArn;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
        this.tags = builder.tags;
    }

    public final String jobQueueName() {
        return this.jobQueueName;
    }

    public final String jobQueueArn() {
        return this.jobQueueArn;
    }

    public final JQState state() {
        return JQState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final JQStatus status() {
        return JQStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final boolean hasComputeEnvironmentOrder() {
        return this.computeEnvironmentOrder != null && !(this.computeEnvironmentOrder instanceof SdkAutoConstructList);
    }

    public final List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return this.computeEnvironmentOrder;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueueArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputeEnvironmentOrder() ? this.computeEnvironmentOrder() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobQueueDetail)) {
            return false;
        }
        JobQueueDetail other = (JobQueueDetail)obj;
        return Objects.equals(this.jobQueueName(), other.jobQueueName()) && Objects.equals(this.jobQueueArn(), other.jobQueueArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.priority(), other.priority()) && this.hasComputeEnvironmentOrder() == other.hasComputeEnvironmentOrder() && Objects.equals(this.computeEnvironmentOrder(), other.computeEnvironmentOrder()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"JobQueueDetail").add("JobQueueName", (Object)this.jobQueueName()).add("JobQueueArn", (Object)this.jobQueueArn()).add("State", (Object)this.stateAsString()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Priority", (Object)this.priority()).add("ComputeEnvironmentOrder", this.hasComputeEnvironmentOrder() ? this.computeEnvironmentOrder() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobQueueName": {
                return Optional.ofNullable(clazz.cast(this.jobQueueName()));
            }
            case "jobQueueArn": {
                return Optional.ofNullable(clazz.cast(this.jobQueueArn()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "computeEnvironmentOrder": {
                return Optional.ofNullable(clazz.cast(this.computeEnvironmentOrder()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobQueueDetail, T> g) {
        return obj -> g.apply((JobQueueDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobQueueName;
        private String jobQueueArn;
        private String state;
        private String status;
        private String statusReason;
        private Integer priority;
        private List<ComputeEnvironmentOrder> computeEnvironmentOrder = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobQueueDetail model) {
            this.jobQueueName(model.jobQueueName);
            this.jobQueueArn(model.jobQueueArn);
            this.state(model.state);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.priority(model.priority);
            this.computeEnvironmentOrder(model.computeEnvironmentOrder);
            this.tags(model.tags);
        }

        public final String getJobQueueName() {
            return this.jobQueueName;
        }

        public final void setJobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
        }

        @Override
        @Transient
        public final Builder jobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        public final String getJobQueueArn() {
            return this.jobQueueArn;
        }

        public final void setJobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
        }

        @Override
        @Transient
        public final Builder jobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(JQState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(JQStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        @Transient
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final List<ComputeEnvironmentOrder.Builder> getComputeEnvironmentOrder() {
            List<ComputeEnvironmentOrder.Builder> result = ComputeEnvironmentOrdersCopier.copyToBuilder(this.computeEnvironmentOrder);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder.BuilderImpl> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copyFromBuilder(computeEnvironmentOrder);
        }

        @Override
        @Transient
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... computeEnvironmentOrder) {
            this.computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder computeEnvironmentOrder(Consumer<ComputeEnvironmentOrder.Builder> ... computeEnvironmentOrder) {
            this.computeEnvironmentOrder(Stream.of(computeEnvironmentOrder).map(c -> (ComputeEnvironmentOrder)((ComputeEnvironmentOrder.Builder)ComputeEnvironmentOrder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public JobQueueDetail build() {
            return new JobQueueDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobQueueDetail> {
        public Builder jobQueueName(String var1);

        public Builder jobQueueArn(String var1);

        public Builder state(String var1);

        public Builder state(JQState var1);

        public Builder status(String var1);

        public Builder status(JQStatus var1);

        public Builder statusReason(String var1);

        public Builder priority(Integer var1);

        public Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> var1);

        public Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... var1);

        public Builder computeEnvironmentOrder(Consumer<ComputeEnvironmentOrder.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

