/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchAsyncClient;
import software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsResponse;
import software.amazon.awssdk.services.batch.model.JobDefinition;

public class DescribeJobDefinitionsPublisher
implements SdkPublisher<DescribeJobDefinitionsResponse> {
    private final BatchAsyncClient client;
    private final DescribeJobDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeJobDefinitionsPublisher(BatchAsyncClient client, DescribeJobDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeJobDefinitionsPublisher(BatchAsyncClient client, DescribeJobDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeJobDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeJobDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobDefinition> jobDefinitions() {
        Function<DescribeJobDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobDefinitions() != null) {
                return response.jobDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeJobDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeJobDefinitionsResponseFetcher
    implements AsyncPageFetcher<DescribeJobDefinitionsResponse> {
        private DescribeJobDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeJobDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeJobDefinitionsResponse> nextPage(DescribeJobDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeJobDefinitionsPublisher.this.client.describeJobDefinitions(DescribeJobDefinitionsPublisher.this.firstRequest);
            }
            return DescribeJobDefinitionsPublisher.this.client.describeJobDefinitions((DescribeJobDefinitionsRequest)((Object)DescribeJobDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

