/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.ArrayPropertiesDetail;
import software.amazon.awssdk.services.batch.model.AttemptDetail;
import software.amazon.awssdk.services.batch.model.AttemptDetailsCopier;
import software.amazon.awssdk.services.batch.model.ContainerDetail;
import software.amazon.awssdk.services.batch.model.JobDependency;
import software.amazon.awssdk.services.batch.model.JobDependencyListCopier;
import software.amazon.awssdk.services.batch.model.JobStatus;
import software.amazon.awssdk.services.batch.model.JobTimeout;
import software.amazon.awssdk.services.batch.model.NodeDetails;
import software.amazon.awssdk.services.batch.model.NodeProperties;
import software.amazon.awssdk.services.batch.model.ParametersMapCopier;
import software.amazon.awssdk.services.batch.model.PlatformCapability;
import software.amazon.awssdk.services.batch.model.PlatformCapabilityListCopier;
import software.amazon.awssdk.services.batch.model.RetryStrategy;
import software.amazon.awssdk.services.batch.model.TagrisTagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobDetail> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(JobDetail.getter(JobDetail::jobArn)).setter(JobDetail.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(JobDetail.getter(JobDetail::jobName)).setter(JobDetail.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(JobDetail.getter(JobDetail::jobId)).setter(JobDetail.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobQueue").getter(JobDetail.getter(JobDetail::jobQueue)).setter(JobDetail.setter(Builder::jobQueue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(JobDetail.getter(JobDetail::statusAsString)).setter(JobDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SHARE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareIdentifier").getter(JobDetail.getter(JobDetail::shareIdentifier)).setter(JobDetail.setter(Builder::shareIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareIdentifier").build()}).build();
    private static final SdkField<Integer> SCHEDULING_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("schedulingPriority").getter(JobDetail.getter(JobDetail::schedulingPriority)).setter(JobDetail.setter(Builder::schedulingPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingPriority").build()}).build();
    private static final SdkField<List<AttemptDetail>> ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attempts").getter(JobDetail.getter(JobDetail::attempts)).setter(JobDetail.setter(Builder::attempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attempts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttemptDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(JobDetail.getter(JobDetail::statusReason)).setter(JobDetail.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createdAt").getter(JobDetail.getter(JobDetail::createdAt)).setter(JobDetail.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<RetryStrategy> RETRY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retryStrategy").getter(JobDetail.getter(JobDetail::retryStrategy)).setter(JobDetail.setter(Builder::retryStrategy)).constructor(RetryStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStrategy").build()}).build();
    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startedAt").getter(JobDetail.getter(JobDetail::startedAt)).setter(JobDetail.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("stoppedAt").getter(JobDetail.getter(JobDetail::stoppedAt)).setter(JobDetail.setter(Builder::stoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()}).build();
    private static final SdkField<List<JobDependency>> DEPENDS_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependsOn").getter(JobDetail.getter(JobDetail::dependsOn)).setter(JobDetail.setter(Builder::dependsOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOn").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobDependency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobDefinition").getter(JobDetail.getter(JobDetail::jobDefinition)).setter(JobDetail.setter(Builder::jobDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinition").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(JobDetail.getter(JobDetail::parameters)).setter(JobDetail.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ContainerDetail> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("container").getter(JobDetail.getter(JobDetail::container)).setter(JobDetail.setter(Builder::container)).constructor(ContainerDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()}).build();
    private static final SdkField<NodeDetails> NODE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nodeDetails").getter(JobDetail.getter(JobDetail::nodeDetails)).setter(JobDetail.setter(Builder::nodeDetails)).constructor(NodeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeDetails").build()}).build();
    private static final SdkField<NodeProperties> NODE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nodeProperties").getter(JobDetail.getter(JobDetail::nodeProperties)).setter(JobDetail.setter(Builder::nodeProperties)).constructor(NodeProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeProperties").build()}).build();
    private static final SdkField<ArrayPropertiesDetail> ARRAY_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("arrayProperties").getter(JobDetail.getter(JobDetail::arrayProperties)).setter(JobDetail.setter(Builder::arrayProperties)).constructor(ArrayPropertiesDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayProperties").build()}).build();
    private static final SdkField<JobTimeout> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeout").getter(JobDetail.getter(JobDetail::timeout)).setter(JobDetail.setter(Builder::timeout)).constructor(JobTimeout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(JobDetail.getter(JobDetail::tags)).setter(JobDetail.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("propagateTags").getter(JobDetail.getter(JobDetail::propagateTags)).setter(JobDetail.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final SdkField<List<String>> PLATFORM_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("platformCapabilities").getter(JobDetail.getter(JobDetail::platformCapabilitiesAsStrings)).setter(JobDetail.setter(Builder::platformCapabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformCapabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_NAME_FIELD, JOB_ID_FIELD, JOB_QUEUE_FIELD, STATUS_FIELD, SHARE_IDENTIFIER_FIELD, SCHEDULING_PRIORITY_FIELD, ATTEMPTS_FIELD, STATUS_REASON_FIELD, CREATED_AT_FIELD, RETRY_STRATEGY_FIELD, STARTED_AT_FIELD, STOPPED_AT_FIELD, DEPENDS_ON_FIELD, JOB_DEFINITION_FIELD, PARAMETERS_FIELD, CONTAINER_FIELD, NODE_DETAILS_FIELD, NODE_PROPERTIES_FIELD, ARRAY_PROPERTIES_FIELD, TIMEOUT_FIELD, TAGS_FIELD, PROPAGATE_TAGS_FIELD, PLATFORM_CAPABILITIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobArn;
    private final String jobName;
    private final String jobId;
    private final String jobQueue;
    private final String status;
    private final String shareIdentifier;
    private final Integer schedulingPriority;
    private final List<AttemptDetail> attempts;
    private final String statusReason;
    private final Long createdAt;
    private final RetryStrategy retryStrategy;
    private final Long startedAt;
    private final Long stoppedAt;
    private final List<JobDependency> dependsOn;
    private final String jobDefinition;
    private final Map<String, String> parameters;
    private final ContainerDetail container;
    private final NodeDetails nodeDetails;
    private final NodeProperties nodeProperties;
    private final ArrayPropertiesDetail arrayProperties;
    private final JobTimeout timeout;
    private final Map<String, String> tags;
    private final Boolean propagateTags;
    private final List<String> platformCapabilities;

    private JobDetail(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.jobId = builder.jobId;
        this.jobQueue = builder.jobQueue;
        this.status = builder.status;
        this.shareIdentifier = builder.shareIdentifier;
        this.schedulingPriority = builder.schedulingPriority;
        this.attempts = builder.attempts;
        this.statusReason = builder.statusReason;
        this.createdAt = builder.createdAt;
        this.retryStrategy = builder.retryStrategy;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.dependsOn = builder.dependsOn;
        this.jobDefinition = builder.jobDefinition;
        this.parameters = builder.parameters;
        this.container = builder.container;
        this.nodeDetails = builder.nodeDetails;
        this.nodeProperties = builder.nodeProperties;
        this.arrayProperties = builder.arrayProperties;
        this.timeout = builder.timeout;
        this.tags = builder.tags;
        this.propagateTags = builder.propagateTags;
        this.platformCapabilities = builder.platformCapabilities;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobQueue() {
        return this.jobQueue;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String shareIdentifier() {
        return this.shareIdentifier;
    }

    public final Integer schedulingPriority() {
        return this.schedulingPriority;
    }

    public final boolean hasAttempts() {
        return this.attempts != null && !(this.attempts instanceof SdkAutoConstructList);
    }

    public final List<AttemptDetail> attempts() {
        return this.attempts;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Long createdAt() {
        return this.createdAt;
    }

    public final RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public final Long startedAt() {
        return this.startedAt;
    }

    public final Long stoppedAt() {
        return this.stoppedAt;
    }

    public final boolean hasDependsOn() {
        return this.dependsOn != null && !(this.dependsOn instanceof SdkAutoConstructList);
    }

    public final List<JobDependency> dependsOn() {
        return this.dependsOn;
    }

    public final String jobDefinition() {
        return this.jobDefinition;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final ContainerDetail container() {
        return this.container;
    }

    public final NodeDetails nodeDetails() {
        return this.nodeDetails;
    }

    public final NodeProperties nodeProperties() {
        return this.nodeProperties;
    }

    public final ArrayPropertiesDetail arrayProperties() {
        return this.arrayProperties;
    }

    public final JobTimeout timeout() {
        return this.timeout;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Boolean propagateTags() {
        return this.propagateTags;
    }

    public final List<PlatformCapability> platformCapabilities() {
        return PlatformCapabilityListCopier.copyStringToEnum(this.platformCapabilities);
    }

    public final boolean hasPlatformCapabilities() {
        return this.platformCapabilities != null && !(this.platformCapabilities instanceof SdkAutoConstructList);
    }

    public final List<String> platformCapabilitiesAsStrings() {
        return this.platformCapabilities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingPriority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttempts() ? this.attempts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependsOn() ? this.dependsOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrayProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatformCapabilities() ? this.platformCapabilitiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetail)) {
            return false;
        }
        JobDetail other = (JobDetail)obj;
        return Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobQueue(), other.jobQueue()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.shareIdentifier(), other.shareIdentifier()) && Objects.equals(this.schedulingPriority(), other.schedulingPriority()) && this.hasAttempts() == other.hasAttempts() && Objects.equals(this.attempts(), other.attempts()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.retryStrategy(), other.retryStrategy()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.stoppedAt(), other.stoppedAt()) && this.hasDependsOn() == other.hasDependsOn() && Objects.equals(this.dependsOn(), other.dependsOn()) && Objects.equals(this.jobDefinition(), other.jobDefinition()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.container(), other.container()) && Objects.equals(this.nodeDetails(), other.nodeDetails()) && Objects.equals(this.nodeProperties(), other.nodeProperties()) && Objects.equals(this.arrayProperties(), other.arrayProperties()) && Objects.equals(this.timeout(), other.timeout()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.propagateTags(), other.propagateTags()) && this.hasPlatformCapabilities() == other.hasPlatformCapabilities() && Objects.equals(this.platformCapabilitiesAsStrings(), other.platformCapabilitiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"JobDetail").add("JobArn", (Object)this.jobArn()).add("JobName", (Object)this.jobName()).add("JobId", (Object)this.jobId()).add("JobQueue", (Object)this.jobQueue()).add("Status", (Object)this.statusAsString()).add("ShareIdentifier", (Object)this.shareIdentifier()).add("SchedulingPriority", (Object)this.schedulingPriority()).add("Attempts", this.hasAttempts() ? this.attempts() : null).add("StatusReason", (Object)this.statusReason()).add("CreatedAt", (Object)this.createdAt()).add("RetryStrategy", (Object)this.retryStrategy()).add("StartedAt", (Object)this.startedAt()).add("StoppedAt", (Object)this.stoppedAt()).add("DependsOn", this.hasDependsOn() ? this.dependsOn() : null).add("JobDefinition", (Object)this.jobDefinition()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Container", (Object)this.container()).add("NodeDetails", (Object)this.nodeDetails()).add("NodeProperties", (Object)this.nodeProperties()).add("ArrayProperties", (Object)this.arrayProperties()).add("Timeout", (Object)this.timeout()).add("Tags", this.hasTags() ? this.tags() : null).add("PropagateTags", (Object)this.propagateTags()).add("PlatformCapabilities", this.hasPlatformCapabilities() ? this.platformCapabilitiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobQueue": {
                return Optional.ofNullable(clazz.cast(this.jobQueue()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "shareIdentifier": {
                return Optional.ofNullable(clazz.cast(this.shareIdentifier()));
            }
            case "schedulingPriority": {
                return Optional.ofNullable(clazz.cast(this.schedulingPriority()));
            }
            case "attempts": {
                return Optional.ofNullable(clazz.cast(this.attempts()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "retryStrategy": {
                return Optional.ofNullable(clazz.cast(this.retryStrategy()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "stoppedAt": {
                return Optional.ofNullable(clazz.cast(this.stoppedAt()));
            }
            case "dependsOn": {
                return Optional.ofNullable(clazz.cast(this.dependsOn()));
            }
            case "jobDefinition": {
                return Optional.ofNullable(clazz.cast(this.jobDefinition()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "nodeDetails": {
                return Optional.ofNullable(clazz.cast(this.nodeDetails()));
            }
            case "nodeProperties": {
                return Optional.ofNullable(clazz.cast(this.nodeProperties()));
            }
            case "arrayProperties": {
                return Optional.ofNullable(clazz.cast(this.arrayProperties()));
            }
            case "timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTags()));
            }
            case "platformCapabilities": {
                return Optional.ofNullable(clazz.cast(this.platformCapabilitiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobDetail, T> g) {
        return obj -> g.apply((JobDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobArn;
        private String jobName;
        private String jobId;
        private String jobQueue;
        private String status;
        private String shareIdentifier;
        private Integer schedulingPriority;
        private List<AttemptDetail> attempts = DefaultSdkAutoConstructList.getInstance();
        private String statusReason;
        private Long createdAt;
        private RetryStrategy retryStrategy;
        private Long startedAt;
        private Long stoppedAt;
        private List<JobDependency> dependsOn = DefaultSdkAutoConstructList.getInstance();
        private String jobDefinition;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private ContainerDetail container;
        private NodeDetails nodeDetails;
        private NodeProperties nodeProperties;
        private ArrayPropertiesDetail arrayProperties;
        private JobTimeout timeout;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean propagateTags;
        private List<String> platformCapabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetail model) {
            this.jobArn(model.jobArn);
            this.jobName(model.jobName);
            this.jobId(model.jobId);
            this.jobQueue(model.jobQueue);
            this.status(model.status);
            this.shareIdentifier(model.shareIdentifier);
            this.schedulingPriority(model.schedulingPriority);
            this.attempts(model.attempts);
            this.statusReason(model.statusReason);
            this.createdAt(model.createdAt);
            this.retryStrategy(model.retryStrategy);
            this.startedAt(model.startedAt);
            this.stoppedAt(model.stoppedAt);
            this.dependsOn(model.dependsOn);
            this.jobDefinition(model.jobDefinition);
            this.parameters(model.parameters);
            this.container(model.container);
            this.nodeDetails(model.nodeDetails);
            this.nodeProperties(model.nodeProperties);
            this.arrayProperties(model.arrayProperties);
            this.timeout(model.timeout);
            this.tags(model.tags);
            this.propagateTags(model.propagateTags);
            this.platformCapabilitiesWithStrings(model.platformCapabilities);
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobQueue() {
            return this.jobQueue;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getShareIdentifier() {
            return this.shareIdentifier;
        }

        public final void setShareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
        }

        @Override
        public final Builder shareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        public final Integer getSchedulingPriority() {
            return this.schedulingPriority;
        }

        public final void setSchedulingPriority(Integer schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
        }

        @Override
        public final Builder schedulingPriority(Integer schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
            return this;
        }

        public final List<AttemptDetail.Builder> getAttempts() {
            List<AttemptDetail.Builder> result = AttemptDetailsCopier.copyToBuilder(this.attempts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttempts(Collection<AttemptDetail.BuilderImpl> attempts) {
            this.attempts = AttemptDetailsCopier.copyFromBuilder(attempts);
        }

        @Override
        public final Builder attempts(Collection<AttemptDetail> attempts) {
            this.attempts = AttemptDetailsCopier.copy(attempts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attempts(AttemptDetail ... attempts) {
            this.attempts(Arrays.asList(attempts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attempts(Consumer<AttemptDetail.Builder> ... attempts) {
            this.attempts(Stream.of(attempts).map(c -> (AttemptDetail)((AttemptDetail.Builder)AttemptDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Long getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Long getStoppedAt() {
            return this.stoppedAt;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final List<JobDependency.Builder> getDependsOn() {
            List<JobDependency.Builder> result = JobDependencyListCopier.copyToBuilder(this.dependsOn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependsOn(Collection<JobDependency.BuilderImpl> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copyFromBuilder(dependsOn);
        }

        @Override
        public final Builder dependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(JobDependency ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<JobDependency.Builder> ... dependsOn) {
            this.dependsOn(Stream.of(dependsOn).map(c -> (JobDependency)((JobDependency.Builder)JobDependency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getJobDefinition() {
            return this.jobDefinition;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final ContainerDetail.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        public final void setContainer(ContainerDetail.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(ContainerDetail container) {
            this.container = container;
            return this;
        }

        public final NodeDetails.Builder getNodeDetails() {
            return this.nodeDetails != null ? this.nodeDetails.toBuilder() : null;
        }

        public final void setNodeDetails(NodeDetails.BuilderImpl nodeDetails) {
            this.nodeDetails = nodeDetails != null ? nodeDetails.build() : null;
        }

        @Override
        public final Builder nodeDetails(NodeDetails nodeDetails) {
            this.nodeDetails = nodeDetails;
            return this;
        }

        public final NodeProperties.Builder getNodeProperties() {
            return this.nodeProperties != null ? this.nodeProperties.toBuilder() : null;
        }

        public final void setNodeProperties(NodeProperties.BuilderImpl nodeProperties) {
            this.nodeProperties = nodeProperties != null ? nodeProperties.build() : null;
        }

        @Override
        public final Builder nodeProperties(NodeProperties nodeProperties) {
            this.nodeProperties = nodeProperties;
            return this;
        }

        public final ArrayPropertiesDetail.Builder getArrayProperties() {
            return this.arrayProperties != null ? this.arrayProperties.toBuilder() : null;
        }

        public final void setArrayProperties(ArrayPropertiesDetail.BuilderImpl arrayProperties) {
            this.arrayProperties = arrayProperties != null ? arrayProperties.build() : null;
        }

        @Override
        public final Builder arrayProperties(ArrayPropertiesDetail arrayProperties) {
            this.arrayProperties = arrayProperties;
            return this;
        }

        public final JobTimeout.Builder getTimeout() {
            return this.timeout != null ? this.timeout.toBuilder() : null;
        }

        public final void setTimeout(JobTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        public final Builder timeout(JobTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public final Boolean getPropagateTags() {
            return this.propagateTags;
        }

        public final void setPropagateTags(Boolean propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(Boolean propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public final Collection<String> getPlatformCapabilities() {
            if (this.platformCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.platformCapabilities;
        }

        public final void setPlatformCapabilities(Collection<String> platformCapabilities) {
            this.platformCapabilities = PlatformCapabilityListCopier.copy(platformCapabilities);
        }

        @Override
        public final Builder platformCapabilitiesWithStrings(Collection<String> platformCapabilities) {
            this.platformCapabilities = PlatformCapabilityListCopier.copy(platformCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformCapabilitiesWithStrings(String ... platformCapabilities) {
            this.platformCapabilitiesWithStrings(Arrays.asList(platformCapabilities));
            return this;
        }

        @Override
        public final Builder platformCapabilities(Collection<PlatformCapability> platformCapabilities) {
            this.platformCapabilities = PlatformCapabilityListCopier.copyEnumToString(platformCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformCapabilities(PlatformCapability ... platformCapabilities) {
            this.platformCapabilities(Arrays.asList(platformCapabilities));
            return this;
        }

        public JobDetail build() {
            return new JobDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobDetail> {
        public Builder jobArn(String var1);

        public Builder jobName(String var1);

        public Builder jobId(String var1);

        public Builder jobQueue(String var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder shareIdentifier(String var1);

        public Builder schedulingPriority(Integer var1);

        public Builder attempts(Collection<AttemptDetail> var1);

        public Builder attempts(AttemptDetail ... var1);

        public Builder attempts(Consumer<AttemptDetail.Builder> ... var1);

        public Builder statusReason(String var1);

        public Builder createdAt(Long var1);

        public Builder retryStrategy(RetryStrategy var1);

        default public Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((RetryStrategy)((RetryStrategy.Builder)RetryStrategy.builder().applyMutation(retryStrategy)).build());
        }

        public Builder startedAt(Long var1);

        public Builder stoppedAt(Long var1);

        public Builder dependsOn(Collection<JobDependency> var1);

        public Builder dependsOn(JobDependency ... var1);

        public Builder dependsOn(Consumer<JobDependency.Builder> ... var1);

        public Builder jobDefinition(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder container(ContainerDetail var1);

        default public Builder container(Consumer<ContainerDetail.Builder> container) {
            return this.container((ContainerDetail)((ContainerDetail.Builder)ContainerDetail.builder().applyMutation(container)).build());
        }

        public Builder nodeDetails(NodeDetails var1);

        default public Builder nodeDetails(Consumer<NodeDetails.Builder> nodeDetails) {
            return this.nodeDetails((NodeDetails)((NodeDetails.Builder)NodeDetails.builder().applyMutation(nodeDetails)).build());
        }

        public Builder nodeProperties(NodeProperties var1);

        default public Builder nodeProperties(Consumer<NodeProperties.Builder> nodeProperties) {
            return this.nodeProperties((NodeProperties)((NodeProperties.Builder)NodeProperties.builder().applyMutation(nodeProperties)).build());
        }

        public Builder arrayProperties(ArrayPropertiesDetail var1);

        default public Builder arrayProperties(Consumer<ArrayPropertiesDetail.Builder> arrayProperties) {
            return this.arrayProperties((ArrayPropertiesDetail)((ArrayPropertiesDetail.Builder)ArrayPropertiesDetail.builder().applyMutation(arrayProperties)).build());
        }

        public Builder timeout(JobTimeout var1);

        default public Builder timeout(Consumer<JobTimeout.Builder> timeout) {
            return this.timeout((JobTimeout)((JobTimeout.Builder)JobTimeout.builder().applyMutation(timeout)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder propagateTags(Boolean var1);

        public Builder platformCapabilitiesWithStrings(Collection<String> var1);

        public Builder platformCapabilitiesWithStrings(String ... var1);

        public Builder platformCapabilities(Collection<PlatformCapability> var1);

        public Builder platformCapabilities(PlatformCapability ... var1);
    }
}

