/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PlatformCapability {
    EC2("EC2"),
    FARGATE("FARGATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PlatformCapability(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PlatformCapability fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PlatformCapability.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PlatformCapability> knownValues() {
        return Stream.of(PlatformCapability.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

