/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeResourceUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeResourceUpdate> {
    private static final SdkField<Integer> MINV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minvCpus").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::minvCpus)).setter(ComputeResourceUpdate.setter(Builder::minvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minvCpus").build()}).build();
    private static final SdkField<Integer> MAXV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxvCpus").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::maxvCpus)).setter(ComputeResourceUpdate.setter(Builder::maxvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxvCpus").build()}).build();
    private static final SdkField<Integer> DESIREDV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredvCpus").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::desiredvCpus)).setter(ComputeResourceUpdate.setter(Builder::desiredvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredvCpus").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnets").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::subnets)).setter(ComputeResourceUpdate.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(ComputeResourceUpdate.getter(ComputeResourceUpdate::securityGroupIds)).setter(ComputeResourceUpdate.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINV_CPUS_FIELD, MAXV_CPUS_FIELD, DESIREDV_CPUS_FIELD, SUBNETS_FIELD, SECURITY_GROUP_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer minvCpus;
    private final Integer maxvCpus;
    private final Integer desiredvCpus;
    private final List<String> subnets;
    private final List<String> securityGroupIds;

    private ComputeResourceUpdate(BuilderImpl builder) {
        this.minvCpus = builder.minvCpus;
        this.maxvCpus = builder.maxvCpus;
        this.desiredvCpus = builder.desiredvCpus;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
    }

    public final Integer minvCpus() {
        return this.minvCpus;
    }

    public final Integer maxvCpus() {
        return this.maxvCpus;
    }

    public final Integer desiredvCpus() {
        return this.desiredvCpus;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeResourceUpdate)) {
            return false;
        }
        ComputeResourceUpdate other = (ComputeResourceUpdate)obj;
        return Objects.equals(this.minvCpus(), other.minvCpus()) && Objects.equals(this.maxvCpus(), other.maxvCpus()) && Objects.equals(this.desiredvCpus(), other.desiredvCpus()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeResourceUpdate").add("MinvCpus", (Object)this.minvCpus()).add("MaxvCpus", (Object)this.maxvCpus()).add("DesiredvCpus", (Object)this.desiredvCpus()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "minvCpus": {
                return Optional.ofNullable(clazz.cast(this.minvCpus()));
            }
            case "maxvCpus": {
                return Optional.ofNullable(clazz.cast(this.maxvCpus()));
            }
            case "desiredvCpus": {
                return Optional.ofNullable(clazz.cast(this.desiredvCpus()));
            }
            case "subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeResourceUpdate, T> g) {
        return obj -> g.apply((ComputeResourceUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minvCpus;
        private Integer maxvCpus;
        private Integer desiredvCpus;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeResourceUpdate model) {
            this.minvCpus(model.minvCpus);
            this.maxvCpus(model.maxvCpus);
            this.desiredvCpus(model.desiredvCpus);
            this.subnets(model.subnets);
            this.securityGroupIds(model.securityGroupIds);
        }

        public final Integer getMinvCpus() {
            return this.minvCpus;
        }

        public final void setMinvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
        }

        @Override
        @Transient
        public final Builder minvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
            return this;
        }

        public final Integer getMaxvCpus() {
            return this.maxvCpus;
        }

        public final void setMaxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
        }

        @Override
        @Transient
        public final Builder maxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        public final Integer getDesiredvCpus() {
            return this.desiredvCpus;
        }

        public final void setDesiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
        }

        @Override
        @Transient
        public final Builder desiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        @Transient
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        @Transient
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public ComputeResourceUpdate build() {
            return new ComputeResourceUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeResourceUpdate> {
        public Builder minvCpus(Integer var1);

        public Builder maxvCpus(Integer var1);

        public Builder desiredvCpus(Integer var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);
    }
}

