/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterJobDefinitionResponse extends BatchResponse implements
        ToCopyableBuilder<RegisterJobDefinitionResponse.Builder, RegisterJobDefinitionResponse> {
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobDefinitionName").getter(getter(RegisterJobDefinitionResponse::jobDefinitionName))
            .setter(setter(Builder::jobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitionName").build()).build();

    private static final SdkField<String> JOB_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobDefinitionArn").getter(getter(RegisterJobDefinitionResponse::jobDefinitionArn))
            .setter(setter(Builder::jobDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitionArn").build()).build();

    private static final SdkField<Integer> REVISION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("revision").getter(getter(RegisterJobDefinitionResponse::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_NAME_FIELD,
            JOB_DEFINITION_ARN_FIELD, REVISION_FIELD));

    private final String jobDefinitionName;

    private final String jobDefinitionArn;

    private final Integer revision;

    private RegisterJobDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionName = builder.jobDefinitionName;
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * The name of the job definition.
     * </p>
     * 
     * @return The name of the job definition.
     */
    public final String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job definition.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job definition.
     */
    public final String jobDefinitionArn() {
        return jobDefinitionArn;
    }

    /**
     * <p>
     * The revision of the job definition.
     * </p>
     * 
     * @return The revision of the job definition.
     */
    public final Integer revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterJobDefinitionResponse)) {
            return false;
        }
        RegisterJobDefinitionResponse other = (RegisterJobDefinitionResponse) obj;
        return Objects.equals(jobDefinitionName(), other.jobDefinitionName())
                && Objects.equals(jobDefinitionArn(), other.jobDefinitionArn()) && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterJobDefinitionResponse").add("JobDefinitionName", jobDefinitionName())
                .add("JobDefinitionArn", jobDefinitionArn()).add("Revision", revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDefinitionName":
            return Optional.ofNullable(clazz.cast(jobDefinitionName()));
        case "jobDefinitionArn":
            return Optional.ofNullable(clazz.cast(jobDefinitionArn()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterJobDefinitionResponse, T> g) {
        return obj -> g.apply((RegisterJobDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, RegisterJobDefinitionResponse> {
        /**
         * <p>
         * The name of the job definition.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job definition.
         * </p>
         * 
         * @param jobDefinitionArn
         *        The Amazon Resource Name (ARN) of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionArn(String jobDefinitionArn);

        /**
         * <p>
         * The revision of the job definition.
         * </p>
         * 
         * @param revision
         *        The revision of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Integer revision);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private String jobDefinitionName;

        private String jobDefinitionArn;

        private Integer revision;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterJobDefinitionResponse model) {
            super(model);
            jobDefinitionName(model.jobDefinitionName);
            jobDefinitionArn(model.jobDefinitionArn);
            revision(model.revision);
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getJobDefinitionArn() {
            return jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        public final Integer getRevision() {
            return revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        public RegisterJobDefinitionResponse build() {
            return new RegisterJobDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
