/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The platform configuration for jobs running on Fargate resources. Jobs running on EC2 resources must not specify this
 * parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FargatePlatformConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FargatePlatformConfiguration.Builder, FargatePlatformConfiguration> {
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformVersion").getter(getter(FargatePlatformConfiguration::platformVersion))
            .setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String platformVersion;

    private FargatePlatformConfiguration(BuilderImpl builder) {
        this.platformVersion = builder.platformVersion;
    }

    /**
     * <p>
     * The AWS Fargate platform version on which the jobs are running. A platform version is specified only for jobs
     * running on Fargate resources. If one isn't specified, the <code>LATEST</code> platform version is used by
     * default. This will use a recent, approved version of the AWS Fargate platform for compute resources. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS
     * Fargate platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The AWS Fargate platform version on which the jobs are running. A platform version is specified only for
     *         jobs running on Fargate resources. If one isn't specified, the <code>LATEST</code> platform version is
     *         used by default. This will use a recent, approved version of the AWS Fargate platform for compute
     *         resources. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
     *         platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FargatePlatformConfiguration)) {
            return false;
        }
        FargatePlatformConfiguration other = (FargatePlatformConfiguration) obj;
        return Objects.equals(platformVersion(), other.platformVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FargatePlatformConfiguration").add("PlatformVersion", platformVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "platformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FargatePlatformConfiguration, T> g) {
        return obj -> g.apply((FargatePlatformConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FargatePlatformConfiguration> {
        /**
         * <p>
         * The AWS Fargate platform version on which the jobs are running. A platform version is specified only for jobs
         * running on Fargate resources. If one isn't specified, the <code>LATEST</code> platform version is used by
         * default. This will use a recent, approved version of the AWS Fargate platform for compute resources. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
         * platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param platformVersion
         *        The AWS Fargate platform version on which the jobs are running. A platform version is specified only
         *        for jobs running on Fargate resources. If one isn't specified, the <code>LATEST</code> platform
         *        version is used by default. This will use a recent, approved version of the AWS Fargate platform for
         *        compute resources. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
         *        platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);
    }

    static final class BuilderImpl implements Builder {
        private String platformVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(FargatePlatformConfiguration model) {
            platformVersion(model.platformVersion);
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public FargatePlatformConfiguration build() {
            return new FargatePlatformConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
