/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2Configuration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2Configuration> {
    private static final SdkField<String> IMAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageType").getter(Ec2Configuration.getter(Ec2Configuration::imageType)).setter(Ec2Configuration.setter(Builder::imageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageType").build()}).build();
    private static final SdkField<String> IMAGE_ID_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageIdOverride").getter(Ec2Configuration.getter(Ec2Configuration::imageIdOverride)).setter(Ec2Configuration.setter(Builder::imageIdOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageIdOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_TYPE_FIELD, IMAGE_ID_OVERRIDE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String imageType;
    private final String imageIdOverride;

    private Ec2Configuration(BuilderImpl builder) {
        this.imageType = builder.imageType;
        this.imageIdOverride = builder.imageIdOverride;
    }

    public final String imageType() {
        return this.imageType;
    }

    public final String imageIdOverride() {
        return this.imageIdOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIdOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2Configuration)) {
            return false;
        }
        Ec2Configuration other = (Ec2Configuration)obj;
        return Objects.equals(this.imageType(), other.imageType()) && Objects.equals(this.imageIdOverride(), other.imageIdOverride());
    }

    public final String toString() {
        return ToString.builder((String)"Ec2Configuration").add("ImageType", (Object)this.imageType()).add("ImageIdOverride", (Object)this.imageIdOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageType": {
                return Optional.ofNullable(clazz.cast(this.imageType()));
            }
            case "imageIdOverride": {
                return Optional.ofNullable(clazz.cast(this.imageIdOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2Configuration, T> g) {
        return obj -> g.apply((Ec2Configuration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageType;
        private String imageIdOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2Configuration model) {
            this.imageType(model.imageType);
            this.imageIdOverride(model.imageIdOverride);
        }

        public final String getImageType() {
            return this.imageType;
        }

        @Override
        public final Builder imageType(String imageType) {
            this.imageType = imageType;
            return this;
        }

        public final void setImageType(String imageType) {
            this.imageType = imageType;
        }

        public final String getImageIdOverride() {
            return this.imageIdOverride;
        }

        @Override
        public final Builder imageIdOverride(String imageIdOverride) {
            this.imageIdOverride = imageIdOverride;
            return this;
        }

        public final void setImageIdOverride(String imageIdOverride) {
            this.imageIdOverride = imageIdOverride;
        }

        public Ec2Configuration build() {
            return new Ec2Configuration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2Configuration> {
        public Builder imageType(String var1);

        public Builder imageIdOverride(String var1);
    }
}

