/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeEnvironmentOrder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeEnvironmentOrder> {
    private static final SdkField<Integer> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("order").getter(ComputeEnvironmentOrder.getter(ComputeEnvironmentOrder::order)).setter(ComputeEnvironmentOrder.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()}).build();
    private static final SdkField<String> COMPUTE_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeEnvironment").getter(ComputeEnvironmentOrder.getter(ComputeEnvironmentOrder::computeEnvironment)).setter(ComputeEnvironmentOrder.setter(Builder::computeEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDER_FIELD, COMPUTE_ENVIRONMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer order;
    private final String computeEnvironment;

    private ComputeEnvironmentOrder(BuilderImpl builder) {
        this.order = builder.order;
        this.computeEnvironment = builder.computeEnvironment;
    }

    public final Integer order() {
        return this.order;
    }

    public final String computeEnvironment() {
        return this.computeEnvironment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.order());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeEnvironmentOrder)) {
            return false;
        }
        ComputeEnvironmentOrder other = (ComputeEnvironmentOrder)obj;
        return Objects.equals(this.order(), other.order()) && Objects.equals(this.computeEnvironment(), other.computeEnvironment());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeEnvironmentOrder").add("Order", (Object)this.order()).add("ComputeEnvironment", (Object)this.computeEnvironment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "order": {
                return Optional.ofNullable(clazz.cast(this.order()));
            }
            case "computeEnvironment": {
                return Optional.ofNullable(clazz.cast(this.computeEnvironment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeEnvironmentOrder, T> g) {
        return obj -> g.apply((ComputeEnvironmentOrder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer order;
        private String computeEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeEnvironmentOrder model) {
            this.order(model.order);
            this.computeEnvironment(model.computeEnvironment);
        }

        public final Integer getOrder() {
            return this.order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        public final String getComputeEnvironment() {
            return this.computeEnvironment;
        }

        @Override
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        public ComputeEnvironmentOrder build() {
            return new ComputeEnvironmentOrder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeEnvironmentOrder> {
        public Builder order(Integer var1);

        public Builder computeEnvironment(String var1);
    }
}

