/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EvaluateOnExit;
import software.amazon.awssdk.services.batch.model.EvaluateOnExitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetryStrategy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetryStrategy> {
    private static final SdkField<Integer> ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("attempts").getter(RetryStrategy.getter(RetryStrategy::attempts)).setter(RetryStrategy.setter(Builder::attempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attempts").build()}).build();
    private static final SdkField<List<EvaluateOnExit>> EVALUATE_ON_EXIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluateOnExit").getter(RetryStrategy.getter(RetryStrategy::evaluateOnExit)).setter(RetryStrategy.setter(Builder::evaluateOnExit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluateOnExit").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluateOnExit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTEMPTS_FIELD, EVALUATE_ON_EXIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer attempts;
    private final List<EvaluateOnExit> evaluateOnExit;

    private RetryStrategy(BuilderImpl builder) {
        this.attempts = builder.attempts;
        this.evaluateOnExit = builder.evaluateOnExit;
    }

    public Integer attempts() {
        return this.attempts;
    }

    public boolean hasEvaluateOnExit() {
        return this.evaluateOnExit != null && !(this.evaluateOnExit instanceof SdkAutoConstructList);
    }

    public List<EvaluateOnExit> evaluateOnExit() {
        return this.evaluateOnExit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluateOnExit() ? this.evaluateOnExit() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryStrategy)) {
            return false;
        }
        RetryStrategy other = (RetryStrategy)obj;
        return Objects.equals(this.attempts(), other.attempts()) && this.hasEvaluateOnExit() == other.hasEvaluateOnExit() && Objects.equals(this.evaluateOnExit(), other.evaluateOnExit());
    }

    public String toString() {
        return ToString.builder((String)"RetryStrategy").add("Attempts", (Object)this.attempts()).add("EvaluateOnExit", this.hasEvaluateOnExit() ? this.evaluateOnExit() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attempts": {
                return Optional.ofNullable(clazz.cast(this.attempts()));
            }
            case "evaluateOnExit": {
                return Optional.ofNullable(clazz.cast(this.evaluateOnExit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryStrategy, T> g) {
        return obj -> g.apply((RetryStrategy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer attempts;
        private List<EvaluateOnExit> evaluateOnExit = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetryStrategy model) {
            this.attempts(model.attempts);
            this.evaluateOnExit(model.evaluateOnExit);
        }

        public final Integer getAttempts() {
            return this.attempts;
        }

        @Override
        public final Builder attempts(Integer attempts) {
            this.attempts = attempts;
            return this;
        }

        public final void setAttempts(Integer attempts) {
            this.attempts = attempts;
        }

        public final Collection<EvaluateOnExit.Builder> getEvaluateOnExit() {
            if (this.evaluateOnExit instanceof SdkAutoConstructList) {
                return null;
            }
            return this.evaluateOnExit != null ? (Collection)this.evaluateOnExit.stream().map(EvaluateOnExit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder evaluateOnExit(Collection<EvaluateOnExit> evaluateOnExit) {
            this.evaluateOnExit = EvaluateOnExitListCopier.copy(evaluateOnExit);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluateOnExit(EvaluateOnExit ... evaluateOnExit) {
            this.evaluateOnExit(Arrays.asList(evaluateOnExit));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluateOnExit(Consumer<EvaluateOnExit.Builder> ... evaluateOnExit) {
            this.evaluateOnExit(Stream.of(evaluateOnExit).map(c -> (EvaluateOnExit)((EvaluateOnExit.Builder)EvaluateOnExit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvaluateOnExit(Collection<EvaluateOnExit.BuilderImpl> evaluateOnExit) {
            this.evaluateOnExit = EvaluateOnExitListCopier.copyFromBuilder(evaluateOnExit);
        }

        public RetryStrategy build() {
            return new RetryStrategy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetryStrategy> {
        public Builder attempts(Integer var1);

        public Builder evaluateOnExit(Collection<EvaluateOnExit> var1);

        public Builder evaluateOnExit(EvaluateOnExit ... var1);

        public Builder evaluateOnExit(Consumer<EvaluateOnExit.Builder> ... var1);
    }
}

