/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.ContainerProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeRangeProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeRangeProperty> {
    private static final SdkField<String> TARGET_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetNodes").getter(NodeRangeProperty.getter(NodeRangeProperty::targetNodes)).setter(NodeRangeProperty.setter(Builder::targetNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetNodes").build()}).build();
    private static final SdkField<ContainerProperties> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("container").getter(NodeRangeProperty.getter(NodeRangeProperty::container)).setter(NodeRangeProperty.setter(Builder::container)).constructor(ContainerProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_NODES_FIELD, CONTAINER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetNodes;
    private final ContainerProperties container;

    private NodeRangeProperty(BuilderImpl builder) {
        this.targetNodes = builder.targetNodes;
        this.container = builder.container;
    }

    public String targetNodes() {
        return this.targetNodes;
    }

    public ContainerProperties container() {
        return this.container;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeRangeProperty)) {
            return false;
        }
        NodeRangeProperty other = (NodeRangeProperty)obj;
        return Objects.equals(this.targetNodes(), other.targetNodes()) && Objects.equals(this.container(), other.container());
    }

    public String toString() {
        return ToString.builder((String)"NodeRangeProperty").add("TargetNodes", (Object)this.targetNodes()).add("Container", (Object)this.container()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetNodes": {
                return Optional.ofNullable(clazz.cast(this.targetNodes()));
            }
            case "container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeRangeProperty, T> g) {
        return obj -> g.apply((NodeRangeProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetNodes;
        private ContainerProperties container;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeRangeProperty model) {
            this.targetNodes(model.targetNodes);
            this.container(model.container);
        }

        public final String getTargetNodes() {
            return this.targetNodes;
        }

        @Override
        public final Builder targetNodes(String targetNodes) {
            this.targetNodes = targetNodes;
            return this;
        }

        public final void setTargetNodes(String targetNodes) {
            this.targetNodes = targetNodes;
        }

        public final ContainerProperties.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        @Override
        public final Builder container(ContainerProperties container) {
            this.container = container;
            return this;
        }

        public final void setContainer(ContainerProperties.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        public NodeRangeProperty build() {
            return new NodeRangeProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeRangeProperty> {
        public Builder targetNodes(String var1);

        public Builder container(ContainerProperties var1);

        default public Builder container(Consumer<ContainerProperties.Builder> container) {
            return this.container((ContainerProperties)((ContainerProperties.Builder)ContainerProperties.builder().applyMutation(container)).build());
        }
    }
}

