/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.ArrayJobDependency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobDependency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobDependency> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobDependency.getter(JobDependency::jobId)).setter(JobDependency.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobDependency.getter(JobDependency::typeAsString)).setter(JobDependency.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String type;

    private JobDependency(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.type = builder.type;
    }

    public String jobId() {
        return this.jobId;
    }

    public ArrayJobDependency type() {
        return ArrayJobDependency.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDependency)) {
            return false;
        }
        JobDependency other = (JobDependency)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"JobDependency").add("JobId", (Object)this.jobId()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobDependency, T> g) {
        return obj -> g.apply((JobDependency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDependency model) {
            this.jobId(model.jobId);
            this.type(model.type);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArrayJobDependency type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public JobDependency build() {
            return new JobDependency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobDependency> {
        public Builder jobId(String var1);

        public Builder type(String var1);

        public Builder type(ArrayJobDependency var1);
    }
}

