/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail;
import software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest;
import software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse;

public class DescribeComputeEnvironmentsIterable
implements SdkIterable<DescribeComputeEnvironmentsResponse> {
    private final BatchClient client;
    private final DescribeComputeEnvironmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeComputeEnvironmentsIterable(BatchClient client, DescribeComputeEnvironmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeComputeEnvironmentsResponseFetcher();
    }

    public Iterator<DescribeComputeEnvironmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComputeEnvironmentDetail> computeEnvironments() {
        Function<DescribeComputeEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.computeEnvironments() != null) {
                return response.computeEnvironments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeComputeEnvironmentsResponseFetcher
    implements SyncPageFetcher<DescribeComputeEnvironmentsResponse> {
        private DescribeComputeEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeComputeEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeComputeEnvironmentsResponse nextPage(DescribeComputeEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeComputeEnvironmentsIterable.this.client.describeComputeEnvironments(DescribeComputeEnvironmentsIterable.this.firstRequest);
            }
            return DescribeComputeEnvironmentsIterable.this.client.describeComputeEnvironments((DescribeComputeEnvironmentsRequest)((Object)DescribeComputeEnvironmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

