/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrdersCopier;
import software.amazon.awssdk.services.batch.model.JQState;
import software.amazon.awssdk.services.batch.model.JQStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobQueueDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobQueueDetail> {
    private static final SdkField<String> JOB_QUEUE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobQueueDetail.getter(JobQueueDetail::jobQueueName)).setter(JobQueueDetail.setter(Builder::jobQueueName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueueName").build()}).build();
    private static final SdkField<String> JOB_QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobQueueDetail.getter(JobQueueDetail::jobQueueArn)).setter(JobQueueDetail.setter(Builder::jobQueueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueueArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobQueueDetail.getter(JobQueueDetail::stateAsString)).setter(JobQueueDetail.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobQueueDetail.getter(JobQueueDetail::statusAsString)).setter(JobQueueDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobQueueDetail.getter(JobQueueDetail::statusReason)).setter(JobQueueDetail.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobQueueDetail.getter(JobQueueDetail::priority)).setter(JobQueueDetail.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<List<ComputeEnvironmentOrder>> COMPUTE_ENVIRONMENT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(JobQueueDetail.getter(JobQueueDetail::computeEnvironmentOrder)).setter(JobQueueDetail.setter(Builder::computeEnvironmentOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentOrder").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputeEnvironmentOrder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_QUEUE_NAME_FIELD, JOB_QUEUE_ARN_FIELD, STATE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, PRIORITY_FIELD, COMPUTE_ENVIRONMENT_ORDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobQueueName;
    private final String jobQueueArn;
    private final String state;
    private final String status;
    private final String statusReason;
    private final Integer priority;
    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private JobQueueDetail(BuilderImpl builder) {
        this.jobQueueName = builder.jobQueueName;
        this.jobQueueArn = builder.jobQueueArn;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    public String jobQueueName() {
        return this.jobQueueName;
    }

    public String jobQueueArn() {
        return this.jobQueueArn;
    }

    public JQState state() {
        return JQState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public JQStatus status() {
        return JQStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Integer priority() {
        return this.priority;
    }

    public boolean hasComputeEnvironmentOrder() {
        return this.computeEnvironmentOrder != null && !(this.computeEnvironmentOrder instanceof SdkAutoConstructList);
    }

    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return this.computeEnvironmentOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueueArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobQueueDetail)) {
            return false;
        }
        JobQueueDetail other = (JobQueueDetail)obj;
        return Objects.equals(this.jobQueueName(), other.jobQueueName()) && Objects.equals(this.jobQueueArn(), other.jobQueueArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.computeEnvironmentOrder(), other.computeEnvironmentOrder());
    }

    public String toString() {
        return ToString.builder((String)"JobQueueDetail").add("JobQueueName", (Object)this.jobQueueName()).add("JobQueueArn", (Object)this.jobQueueArn()).add("State", (Object)this.stateAsString()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Priority", (Object)this.priority()).add("ComputeEnvironmentOrder", this.computeEnvironmentOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobQueueName": {
                return Optional.ofNullable(clazz.cast(this.jobQueueName()));
            }
            case "jobQueueArn": {
                return Optional.ofNullable(clazz.cast(this.jobQueueArn()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "computeEnvironmentOrder": {
                return Optional.ofNullable(clazz.cast(this.computeEnvironmentOrder()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobQueueDetail, T> g) {
        return obj -> g.apply((JobQueueDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobQueueName;
        private String jobQueueArn;
        private String state;
        private String status;
        private String statusReason;
        private Integer priority;
        private List<ComputeEnvironmentOrder> computeEnvironmentOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobQueueDetail model) {
            this.jobQueueName(model.jobQueueName);
            this.jobQueueArn(model.jobQueueArn);
            this.state(model.state);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.priority(model.priority);
            this.computeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueueName() {
            return this.jobQueueName;
        }

        @Override
        public final Builder jobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
            return this;
        }

        public final void setJobQueueName(String jobQueueName) {
            this.jobQueueName = jobQueueName;
        }

        public final String getJobQueueArn() {
            return this.jobQueueArn;
        }

        @Override
        public final Builder jobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        public final void setJobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JQStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder.Builder> getComputeEnvironmentOrder() {
            return this.computeEnvironmentOrder != null ? (Collection)this.computeEnvironmentOrder.stream().map(ComputeEnvironmentOrder::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... computeEnvironmentOrder) {
            this.computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(Consumer<ComputeEnvironmentOrder.Builder> ... computeEnvironmentOrder) {
            this.computeEnvironmentOrder(Stream.of(computeEnvironmentOrder).map(c -> (ComputeEnvironmentOrder)((ComputeEnvironmentOrder.Builder)ComputeEnvironmentOrder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder.BuilderImpl> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copyFromBuilder(computeEnvironmentOrder);
        }

        public JobQueueDetail build() {
            return new JobQueueDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobQueueDetail> {
        public Builder jobQueueName(String var1);

        public Builder jobQueueArn(String var1);

        public Builder state(String var1);

        public Builder state(JQState var1);

        public Builder status(String var1);

        public Builder status(JQStatus var1);

        public Builder statusReason(String var1);

        public Builder priority(Integer var1);

        public Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> var1);

        public Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... var1);

        public Builder computeEnvironmentOrder(Consumer<ComputeEnvironmentOrder.Builder> ... var1);
    }
}

